<?php
    $version = $basicInfo->theme_version;
?>

<?php $__env->startSection('pageHeading'); ?>
    <?php echo e(__('Home')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_keyword_home); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
    <?php if(!empty($seoInfo)): ?>
        <?php echo e($seoInfo->meta_description_home); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="home-banner home-banner-1">
        <img class="lazyload bg-img" src="<?php echo e(asset('assets/img/hero/static/' . $heroImg)); ?>">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xxl-10">
                    <div class="content mb-40" data-aos="fade-up">
                        <h1 class="title"><?php echo e($heroStatic->title); ?></h1>
                        <p class="text">
                            <?php echo e($heroStatic->text); ?>

                        </p>
                    </div>
                    <div class="banner-filter-form" data-aos="fade-up">
                        <ul class="nav nav-tabs">
                            <li class="nav-item">
                                <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#rent"
                                    type="button"><?php echo e(__('Rent')); ?></button>
                            </li>
                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#sale"
                                    type="button"><?php echo e(__('Sale')); ?></button>
                            </li>
                        </ul>
                        <div class="tab-content form-wrapper">
                            <input type="hidden" value="<?php echo e($min); ?>" id="min">
                            <input type="hidden" value="<?php echo e($max); ?>" id="max">

                            <input type="hidden" id="currency_symbol" value="<?php echo e($basicInfo->base_currency_symbol); ?>">
                            <input class="form-control" type="hidden" value="<?php echo e($min); ?>" id="o_min">
                            <input class="form-control" type="hidden" value="<?php echo e($max); ?>" id="o_max">

                            <div class="tab-pane fade active show" id="rent">
                                <form action="<?php echo e(route('frontend.properties')); ?>" method="get">
                                    <input type="hidden" name="purposre" value="rent">
                                    <input type="hidden" name="min" value="<?php echo e($min); ?>" id="min">
                                    <input type="hidden" name="max" value="<?php echo e($max); ?>" id="max">
                                    <div class="grid">
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="search1"><?php echo e(__('Location')); ?></label>
                                                <input type="text" id="search1" name="location" class="form-control"
                                                    placeholder="<?php echo e(__('Enter Location')); ?>">
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="type" class="icon-end"><?php echo e(__('Property Type')); ?></label>
                                                <select aria-label="#" name="type" class="form-control select2 type"
                                                    id="type">
                                                    <option selected disabled value=""><?php echo e(__('Select Property')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>
                                                    <option value="residential"><?php echo e(__('Residential')); ?></option>
                                                    <option value="commercial"><?php echo e(__('Commercial')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="category" class="icon-end"><?php echo e(__('Categories')); ?></label>
                                                <select aria-label="#" class="form-control select2 bringCategory"
                                                    id="category" name="category">
                                                    <option selected disabled value=""><?php echo e(__('Select Category')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>
                                                    <?php $__currentLoopData = $all_proeprty_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e(@$category->categoryContent->slug); ?>">
                                                            <?php echo e(@$category->categoryContent->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>

                                        <div class="grid-item city">
                                            <div class="form-group">
                                                <label for="city" class="icon-end"><?php echo e(__('City')); ?></label>
                                                <select aria-label="#" name="city" class="form-control select2 city_id"
                                                    id="city">
                                                    <option selected disabled value=""><?php echo e(__('Select City')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>

                                                    <?php $__currentLoopData = $all_cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option data-id="<?php echo e($city->id); ?>"
                                                            value="<?php echo e(@$city->cityContent->name); ?>">
                                                            <?php echo e(@$city->cityContent->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <label class="price-value"><?php echo e(__('Price')); ?>: <br>
                                                <span data-range-value="filterPriceSliderValue"><?php echo e(symbolPrice($min)); ?>

                                                    -
                                                    <?php echo e(symbolPrice($max)); ?></span>
                                            </label>
                                            <div data-range-slider="filterPriceSlider"></div>
                                        </div>
                                        <div class="grid-item">
                                            <button type="submit"
                                                class="btn btn-lg btn-primary bg-secondary icon-start w-100">
                                                <?php echo e(__('Search')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="sale">
                                <form action="<?php echo e(route('frontend.properties')); ?>" method="get">
                                    <input type="hidden" name="purposre" value="sale">
                                    <div class="grid">
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="search1"><?php echo e(__('Location')); ?></label>
                                                <input type="text" id="search1" name="location"
                                                    class="form-control" placeholder="<?php echo e(__('Enter Location')); ?>">
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="type1" class="icon-end"><?php echo e(__('Property Type')); ?></label>
                                                <select aria-label="#" name="type" class="form-control select2 type"
                                                    id="type1">
                                                    <option selected disabled value=""><?php echo e(__('Select Property')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>
                                                    <option value="residential"><?php echo e(__('Residential')); ?></option>
                                                    <option value="commercial"><?php echo e(__('Commercial')); ?></option>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <div class="form-group">
                                                <label for="category1" class="icon-end"><?php echo e(__('Categories')); ?></label>
                                                <select aria-label="#" class="form-control select2 bringCategory"
                                                    id="category1" name="category">
                                                    <option selected disabled value=""><?php echo e(__('Select Category')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>
                                                    <?php $__currentLoopData = $all_proeprty_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e(@$category->categoryContent->slug); ?>">
                                                            <?php echo e(@$category->categoryContent->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>

                                        <div class="grid-item city">
                                            <div class="form-group">
                                                <label for="city1" class="icon-end"><?php echo e(__('City')); ?></label>
                                                <select aria-label="#" name="city"
                                                    class="form-control select2 city_id" id="city1">
                                                    <option selected disabled value=""><?php echo e(__('Select City')); ?>

                                                    </option>
                                                    <option value="all"><?php echo e(__('All')); ?></option>

                                                    <?php $__currentLoopData = $all_cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option data-id="<?php echo e($city->id); ?>"
                                                            value="<?php echo e(@$city->cityContent->name); ?>">
                                                            <?php echo e(@$city->cityContent->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="grid-item">
                                            <label class="price-value"><?php echo e(__('Price')); ?>: <br>
                                                <span data-range-value="filterPriceSliderValue"><?php echo e(symbolPrice($min)); ?>

                                                    -
                                                    <?php echo e(symbolPrice($max)); ?></span>
                                            </label>
                                            <div data-range-slider="filterPriceSlider"></div>
                                        </div>
                                        <div class="grid-item">
                                            <button type="submit"
                                                class="btn btn-lg btn-primary bg-secondary icon-start w-100">
                                                <?php echo e(__('Search')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if($secInfo->counter_section_status == 1): ?>
        <div class="counter-area pt-100 pb-70">
            <div class="container">
                <div class="row gx-xl-5" data-aos="fade-up">
                    <?php $__empty_1 = true; $__currentLoopData = $counters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $counter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-sm-6 col-lg-3">
                            <div class="card mb-30">
                                <div class="d-flex align-items-center justify-content-center mb-10">
                                    <div class="card-icon me-2 color-secondary"><i class="<?php echo e($counter->icon); ?>"></i>
                                    </div>
                                    <h2 class="m-0 color-secondary"><span class="counter"><?php echo e($counter->amount); ?></span>+
                                    </h2>
                                </div>
                                <p class="card-text text-center"><?php echo e($counter->title); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12">
                            <h3 class="text-center mt-20"> <?php echo e(__('No Counter Information Found')); ?> </h3>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($secInfo->featured_properties_section_status == 1): ?>
        <section class="product-area featured-product pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title title-inline mb-40" data-aos="fade-up">
                            <h2 class="title"><?php echo e($featuredSecInfo->title); ?></h2>
                        </div>
                    </div>
                    <div class="col-12" data-aos="fade-up">
                        <div class="swiper product-slider">
                            <div class="swiper-wrapper">
                                <?php $__empty_1 = true; $__currentLoopData = $featured_properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    
                                    <div class="swiper-slide">
                                        <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class=" p-3 text-center mb-30 w-100">
                                        <h3 class="mb-0"> <?php echo e(__('No Featured Property Found')); ?></h3>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <!-- Slider pagination -->
                            <div class="swiper-pagination position-static mb-30" id="product-slider-pagination"></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($secInfo->about_section_status == 1): ?>
        <section class="about-area pb-70 pt-30">
            <div class="container">
                <div class="row gx-xl-5">
                    <div class="col-lg-6">
                        <div class="img-content mb-30" data-aos="fade-up">
                            <div class="image">
                                <img class="lazyload blur-up"
                                    data-src="<?php echo e(asset('assets/img/about_section/' . $aboutImg->about_section_image1)); ?>">

                                <img class="lazyload blur-up"
                                    data-src="<?php echo e(asset('assets/img/about_section/' . $aboutImg->about_section_image2)); ?>">
                            </div>
                            <div class="absolute-text bg-secondary">
                                <div class="center-text">
                                    <span class="h2 color-primary"><?php echo e($aboutInfo?->years_of_expricence); ?>+</span>
                                    <span><?php echo e(__('Years')); ?></span>
                                </div>
                                <div id="curveText"><?php echo e(__('We are highly experience')); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="content mb-30" data-aos="fade-up">
                            <div class="content-title">
                                <span class="subtitle"><span class="line"></span>
                                    <?php echo e($aboutInfo->title); ?></span>
                                <h2><?php echo e($aboutInfo?->sub_title); ?></h2>
                            </div>
                            <div class="text summernote-content"><?php echo $aboutInfo?->description; ?></div>

                            <div class="d-flex align-items-center flex-wrap gap-15">
                                <?php if(!empty($aboutInfo->btn_url)): ?>
                                    <a href="<?php echo e($aboutInfo->btn_url); ?>"
                                        class="btn btn-lg btn-primary bg-secondary"><?php echo e($aboutInfo?->btn_name); ?></a>
                                <?php endif; ?>
                                <?php if(!empty($aboutInfo->client_text)): ?>
                                    <div class="clients d-flex align-items-center flex-wrap gap-2">
                                        <div class="client-img">
                                            <img class="lazyload"
                                                data-src="  <?php echo e(asset('assets/front/images/client/client-1.jpg')); ?>">
                                            <img class="lazyload"
                                                data-src="  <?php echo e(asset('assets/front/images/client/client-2.jpg')); ?>">
                                            <img class="lazyload"
                                                data-src="  <?php echo e(asset('assets/front/images/client/client-3.jpg')); ?>">
                                            <img class="lazyload"
                                                data-src="  <?php echo e(asset('assets/front/images/client/client-4.jpg')); ?>">
                                        </div>
                                <?php endif; ?>
                                <span><?php echo e($aboutInfo?->client_text); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($secInfo->property_section_status == 1): ?>
        <section class="product-area popular-product product-1 pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title title-inline mb-40" data-aos="fade-up">
                            <h2 class="title"><?php echo e($propertySecInfo->title); ?></h2>
                            <div class="tabs-navigation">
                                <ul class="nav nav-tabs">
                                    <li class="nav-item">
                                        <button class="nav-link active btn-md" data-bs-toggle="tab"
                                            data-bs-target="#forAll" type="button"><?php echo e(__('All Properties')); ?></button>
                                    </li>
                                    <li class="nav-item">
                                        <button class="nav-link btn-md" data-bs-toggle="tab" data-bs-target="#forRent"
                                            type="button"><?php echo e(__('For Rent')); ?></button>
                                    </li>
                                    <li class="nav-item">
                                        <button class="nav-link btn-md" data-bs-toggle="tab" data-bs-target="#forSell"
                                            type="button"><?php echo e(__('For Sale')); ?></button>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="tab-content" data-aos="fade-up">
                            <div class="tab-pane fade show active" id="forAll">
                                <div class="row">

                                    <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        
                                        <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-lg-4 col-xxl-3 col-md-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="p-3 text-center mb-30">
                                            <h3 class="mb-0"> <?php echo e(__('No Properties Found')); ?></h3>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <div class="tab-pane fade" id="forRent">
                                <div class="row">
                                    <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php if($property->purpose == 'rent'): ?>
                                            
                                            <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-lg-4 col-xxl-3 col-md-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="p-3 text-center mb-30">
                                            <h3 class="mb-0"> <?php echo e(__('No Properties Found')); ?></h3>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <div class="tab-pane fade" id="forSell">
                                <div class="row">
                                    <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php if($property->purpose == 'sale'): ?>
                                            
                                            <?php if (isset($component)) { $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062 = $component; } ?>
<?php $component = App\View\Components\Property::resolve(['property' => $property] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('property'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Property::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'col-lg-4 col-xxl-3 col-md-6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062)): ?>
<?php $component = $__componentOriginal639634bf4019fd173d700efbbafd2b3557577062; ?>
<?php unset($__componentOriginal639634bf4019fd173d700efbbafd2b3557577062); ?>
<?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="p-3 text-center mb-30">
                                            <h3 class="mb-0"> <?php echo e(__('No Properties Found')); ?></h3>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($secInfo->why_choose_us_section_status == 1): ?>
        <section class="choose-area pb-70">
            <div class="container">
                <div class="row gx-xl-5">
                    <div class="col-lg-7">
                        <div class="img-content mb-30 image-right" data-aos="fade-up">
                            <div class="img-1">
                                <img class="lazyload blur-up"
                                    data-src="<?php echo e(asset('assets/img/why-choose-us/' . $whyChooseUsImg->why_choose_us_section_img1)); ?> "
                                    alt="Image">
                                <?php if(!empty($whyChooseUsImg->why_choose_us_section_video_link)): ?>
                                    <a href="<?php echo e($whyChooseUsImg->why_choose_us_section_video_link); ?>"
                                        class="video-btn youtube-popup p-absolute">
                                        <i class="fas fa-play"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="img-2">
                                <img class="lazyload blur-up"
                                    data-src="  <?php echo e(asset('assets/img/why-choose-us/' . $whyChooseUsImg->why_choose_us_section_img2)); ?> "
                                    alt="Image">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 order-lg-first">
                        <div class="content" data-aos="fade-up">
                            <div class="content-title">
                                <span class="subtitle"><span class="line"></span><?php echo e($whyChooseUsInfo->title); ?></span>
                                <h2><?php echo e($whyChooseUsInfo?->sub_title); ?></h2>
                            </div>
                            <div class="text"><?php echo $whyChooseUsInfo?->description; ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($secInfo->vendor_section_status == 1): ?>
        <section class="agent-area pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title title-center mb-40" data-aos="fade-up">
                            <span class="subtitle"><?php echo e($vendorInfo->title); ?></span>
                            <h2 class="title"><?php echo e($vendorInfo?->subtitle); ?></h2>
                        </div>
                    </div>
                    <div class="col-12" data-aos="fade-up">
                        <div class="swiper agent-slider">
                            <div class="swiper-wrapper">
                                <?php $__empty_1 = true; $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="swiper-slide">
                                        <div class="agent-box radius-md mb-30">
                                            <div class="agent-img">
                                                <figure>
                                                    <a href="#" class="lazy-container ratio ratio-1-2">
                                                        <img class="lazyload"
                                                            data-src="<?php echo e($vendor->photo ? asset('assets/admin/img/vendor-photo/' . $vendor->photo) : asset('assets/img/blank-user.jpg')); ?>">
                                                    </a>
                                                </figure>
                                                <div
                                                    class="agent-ratings d-flex align-items-center justify-content-between">
                                                    <div class="ratings">

                                                    </div>
                                                    <span class="label"><?php echo e(__('Real Estate')); ?></span>
                                                </div>

                                            </div>
                                            <div class="agent-details text-center">
                                                <?php
                                                    $vendor_info = App\Models\VendorInfo::where([
                                                        ['vendor_id', $vendor->vendorId],
                                                        ['language_id', $language->id],
                                                    ])
                                                        ->select('name')
                                                        ->first();
                                                    $agents = App\Models\Agent::where(
                                                        'vendor_id',
                                                        $vendor->vendorId,
                                                    )->get();

                                                ?>
                                                <span class="color-primary font-sm"><?php echo e(count($vendor->properties)); ?>

                                                    <?php echo e(__('Properties')); ?></span> |
                                                <span class="color-primary font-sm"><?php echo e(count($vendor->agents)); ?>

                                                    <?php echo e(__('Agents')); ?></span> |
                                                <span class="color-primary font-sm"><?php echo e(count($vendor->projects)); ?>

                                                    <?php echo e(__('Projects')); ?></span>


                                                <h4 class="agent-title"><a
                                                        href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>"><?php echo e(@$vendor_info->name); ?></a>
                                                </h4>
                                                <ul class="agent-info list-unstyled p-0">

                                                    <?php if($vendor->show_phone_number == 1): ?>
                                                        <?php if(!is_null($vendor->phone)): ?>
                                                            <li class="icon-start ">
                                                                <a href="tel:<?php echo e($vendor->phone); ?>"> <i
                                                                        class="fal fa-phone-plus"></i>
                                                                    <?php echo e($vendor->phone); ?></a>
                                                            </li>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                    <?php if($vendor->show_email_addresss == 1): ?>
                                                        <li class="icon-start font-sm">
                                                            <a href="mailto:<?php echo e($vendor->email); ?>"> <i
                                                                    class="fal fa-envelope"></i>
                                                                <?php echo e($vendor->email); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                </ul>
                                                <a href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>"
                                                    class="btn-text"><?php echo e(__('View Profile')); ?></a>
                                            </div>
                                        </div><!-- agent-default -->
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="p-3 text-center mb-30 w-100">
                                        <h3 class="mb-0"> <?php echo e(__('No Vendors Found')); ?></h3>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php if(count($vendors) > 0): ?>
                        <div class="text-center">
                            <a href="<?php echo e(route('frontend.vendors')); ?>"
                                class="btn btn-lg btn-primary bg-secondary mb-30"><?php echo e($vendorInfo->btn_name); ?></a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($secInfo->cities_section_status == 1): ?>
        <section class="gallery-area pt-100 pb-70">
            <img class="lazyload bg-img" src="<?php echo e(asset('assets/front/images/245re4e1r53.png')); ?>">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title title-inline mb-40" data-aos="fade-up">
                            <div>
                                <span class="subtitle"><span class="line"></span>
                                    <?php echo e($citySecInfo->title); ?></span>
                                <h2 class="title"><?php echo e($citySecInfo?->subtitle); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row" data-aos="fade-up">
                            <?php $__empty_1 = true; $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="col-lg-4 col-sm-6">
                                    <div class="card radius-md mb-30">
                                        <a href="#">
                                            <div class="card-img">
                                                <div class="lazy-container ratio ratio-16-11">
                                                    <img class="lazyload blur-up"
                                                        data-src="<?php echo e(asset('assets/img/property-city/' . $city->image)); ?>">
                                                </div>
                                            </div>
                                            <div class="card-text text-center">
                                                <h5 class="card-title color-white mb-0"><?php echo e($city->name); ?></h5>
                                                <span class="font-sm color-white"><?php echo e($city->propertyCount); ?>

                                                    <?php if($city->propertyCount > 0): ?>
                                                        <?php echo e(__('Properties')); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('Property')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class=" p-3 text-center mb-30 w-100">
                                    <h3 class="mb-0"> <?php echo e(__('No Cities Found')); ?></h3>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($secInfo->testimonial_section_status == 1): ?>
        <section class="testimonial-area pt-100 pb-70">
            <div class="overlay-bg d-none d-lg-block">
                <img class="lazyload blur-up" data-src="<?php echo e(asset('assets/img/' . $testimonialSecImage)); ?>">
            </div>
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-4">
                        <div class="content mb-30" data-aos="fade-up">
                            <div class="content-title">
                                <span class="subtitle"><span
                                        class="line"></span><?php echo e($testimonialSecInfo->title); ?></span>
                                <h2 class="title">
                                    <?php echo e($testimonialSecInfo?->subtitle); ?></h2>
                            </div>
                            <p class="text mb-30">
                                <?php echo e($testimonialSecInfo?->content); ?></p>
                            <!-- Slider navigation buttons -->
                            <div class="slider-navigation scroll-animate">
                                <button type="button" title="Slide prev" class="slider-btn slider-btn-prev">
                                    <i class="fal fa-angle-left"></i>
                                </button>
                                <button type="button" title="Slide next" class="slider-btn slider-btn-next">
                                    <i class="fal fa-angle-right"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8" data-aos="fade-up">
                        <div class="swiper" id="testimonial-slider-1">
                            <div class="swiper-wrapper">
                                <?php $__empty_1 = true; $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="swiper-slide pb-30" data-aos="fade-up">
                                        <div class="slider-item">
                                            <div class="client-img">
                                                <div class="lazy-container ratio ratio-1-1">
                                                    <?php if(is_null($testimonial->image)): ?>
                                                        <img data-src="<?php echo e(asset('assets/img/profile.jpg')); ?>"
                                                            class="lazyload">
                                                    <?php else: ?>
                                                        <img class="lazyload"
                                                            data-src="<?php echo e(asset('assets/img/clients/' . $testimonial->image)); ?>">
                                                    <?php endif; ?>


                                                </div>
                                            </div>
                                            <div class="client-content mt-30">
                                                <div class="quote">
                                                    <p class="text"><?php echo e($testimonial->comment); ?></p>
                                                </div>
                                                <div
                                                    class="client-info d-flex flex-wrap gap-10 align-items-center justify-content-between">
                                                    <div class="content">
                                                        <h6 class="name"><?php echo e($testimonial->name); ?></h6>
                                                        <span class="designation"><?php echo e($testimonial->occupation); ?></span>
                                                    </div>
                                                    <div class="ratings">

                                                        <div class="rate">
                                                            <div class="rating-icon"
                                                                style="width: <?php echo e($testimonial->rating * 20); ?>%"></div>
                                                        </div>
                                                        <span class="ratings-total">(<?php echo e($testimonial->rating); ?>) </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="bg-light p-3 text-center mb-30 w-100">
                                        <h3 class="mb-0"> <?php echo e(__('No Testimonials Found')); ?></h3>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($secInfo->subscribe_section_status == 1): ?>
        <section class="newsletter-area pb-100" data-aos="fade-up">
            <div class="container">
                <div class="newsletter-inner px-4">
                    <img class="lazyload bg-img" src="<?php echo e(asset('assets/img/' . $subscribeSectionImage)); ?>">
                    <div class="row justify-content-center text-center" data-aos="fade-up">
                        <div class="col-lg-6 col-xxl-5">
                            <div class="content mb-30">
                                <span class="subtitle color-white mb-10 d-block"><?php echo e($subscribeSecInfo->title); ?></span>
                                <h2 class="color-white"><?php echo e($subscribeSecInfo?->subtitle); ?></h2>
                            </div>
                            <form id="newsletterForm" class="subscription-form newsletter-form"
                                action="<?php echo e(route('store_subscriber')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="input-group radius-md">
                                    <input class="form-control" placeholder="<?php echo e(__('Enter Your Email')); ?>"
                                        type="email" name="email_id" required>
                                    <button class="btn btn-lg btn-primary" type="submit">
                                        <?php echo e($subscribeSecInfo->btn_name ?? __('Start Now')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.layout-v' . $version, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/frontend/home/index-v1.blade.php ENDPATH**/ ?>