<div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(__('Add Property Category')); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <form id="ajaxForm" class="modal-form create"
                    action="<?php echo e(route('admin.property_specification.store_category')); ?>" method="post"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?> 

                    <div class="form-group">
                        <label for=""><?php echo e(__('Image') . '*'); ?></label>
                        <br>
                        <div class="thumb-preview">
                            <img src="<?php echo e(asset('assets/img/noimage.jpg')); ?>" alt="..." class="uploaded-img">
                        </div>

                        <div class="mt-3">
                            <div role="button" class="btn btn-primary btn-sm upload-btn">
                                <?php echo e(__('Choose Image')); ?>

                                <input type="file" class="img-input" name="image">
                            </div>
                        </div>
                        
                        <p id="err_image" class=" mb-0 text-danger em"></p>
                    </div>

                    <div class="form-group">
                        <label for=""><?php echo e(__('Type') . '*'); ?></label>

                        <select name="type" class="form-control">
                            <option selected disabled><?php echo e(__('Select a Type')); ?></option>
                            <option value="residential"><?php echo e(__('Residential')); ?></option>
                            <option value="commercial"><?php echo e(__("Commercial")); ?></option>

                        </select>
                        <p id="err_type" class="mt-2 mb-0 text-danger em"></p>
                    </div> 

                    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group <?php echo e($lang->direction == 1 ? 'rtl text-right' : ''); ?>">
                            <label for=""><?php echo e(__('Name') . '*'); ?> (<?php echo e($lang->name); ?>)</label>
                            <input type="text" class="form-control" name="<?php echo e($lang->code); ?>_name"
                                placeholder="Enter category name">
                            <p id="err_<?php echo e($lang->code); ?>_name" class="mt-2 mb-0 text-danger em"></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <div class="form-group">
                        <label for=""><?php echo e(__('Status') . '*'); ?></label>
                        <select name="status" class="form-control">
                            <option selected disabled><?php echo e(__('Select Category Status')); ?></option>
                            <option value="1"><?php echo e(__('Active')); ?></option>
                            <option value="0"><?php echo e(__('Deactive')); ?></option>
                        </select>
                        <p id="err_status" class="mt-2 mb-0 text-danger em"></p>
                    </div>

                    <div class="form-group">
                        <label for=""><?php echo e(__('Serial Number') . '*'); ?></label>
                        <input type="number" class="form-control ltr" name="serial_number"
                            placeholder="Enter Serial Number">
                        <p id="err_serial_number" class="mt-2 mb-0 text-danger em"></p>
                        <p class="text-warning mt-2 mb-0">
                            <small><?php echo e(__('The higher the serial number is, the later the category will be shown.')); ?></small>
                        </p>
                    </div>
                </form>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">
                    <?php echo e(__('Close')); ?>

                </button>
                <button id="submitBtn" type="button" class="btn btn-primary btn-sm">
                    <?php echo e(__('Save')); ?>

                </button>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/backend/property/category/create.blade.php ENDPATH**/ ?>