<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Admin Profile')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Profile Settings')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card-title"><?php echo e(__('Update Profile')); ?></div>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8 mx-auto">
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger pb-1  " id="carErrors">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    <ul>
                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($errors->has($language->code . '_first_name')): ?>
                                                <li class="text-danger">
                                                    <?php echo e($errors->first($language->code . '_first_name')); ?>

                                                </li>
                                            <?php endif; ?>
                                            <?php if($errors->has($language->code . '_last_name')): ?>
                                                <li class="text-danger">
                                                    <?php echo e($errors->first($language->code . '_last_name')); ?>

                                                </li>
                                            <?php endif; ?>
                                            <?php if($errors->has($language->code . '_country')): ?>
                                                <li class="text-danger"> <?php echo e($errors->first($language->code . '_country')); ?>

                                                </li>
                                            <?php endif; ?>
                                            <?php if($errors->has($language->code . '_city')): ?>
                                                <li class="text-danger"> <?php echo e($errors->first($language->code . '_city')); ?>

                                                </li>
                                            <?php endif; ?>
                                            <?php if($errors->has($language->code . '_state')): ?>
                                                <li class="text-danger"> <?php echo e($errors->first($language->code . '_state')); ?>

                                                </li>
                                            <?php endif; ?>
                                            <?php if($errors->has($language->code . '_zip_code')): ?>
                                                <li class="text-danger"> <?php echo e($errors->first($language->code . '_zip_code')); ?>

                                                </li>
                                            <?php endif; ?>
                                            <?php if($errors->has($language->code . '_email')): ?>
                                                <li class="text-danger"> <?php echo e($errors->first($language->code . '_email')); ?>

                                                </li>
                                            <?php endif; ?>
                                            <?php if($errors->has($language->code . '_details')): ?>
                                                <li class="text-danger"> <?php echo e($errors->first($language->code . '_details')); ?>

                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                            <form id="editProfileForm" action="<?php echo e(route('admin.update_profile')); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Image') . '*'); ?></label>
                                            <br>
                                            <div class="thumb-preview">
                                                <?php if(!empty($admin->image)): ?>
                                                    <img src="<?php echo e(asset('assets/img/admins/' . $admin->image)); ?>"
                                                        alt="image" class="uploaded-img">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/img/noimage.jpg')); ?>" alt="..."
                                                        class="uploaded-img">
                                                <?php endif; ?>
                                            </div>

                                            <div class="mt-3">
                                                <div role="button" class="btn btn-primary btn-sm upload-btn">
                                                    <?php echo e(__('Choose Image')); ?>

                                                    <input type="file" class="img-input" name="image">
                                                </div>
                                            </div>
                                            <?php if($errors->has('image')): ?>
                                                <p class="mt-2 mb-0 text-danger"><?php echo e($errors->first('image')); ?></p>
                                            <?php endif; ?>
                                            <p class="text-warning mt-2 mb-0">
                                                <?php echo e(__('Upload squre size image for best quality.')); ?></p>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label><?php echo e(__('Username') . '*'); ?></label>
                                            <input type="text" class="form-control" name="username"
                                                value="<?php echo e($admin->username); ?>">
                                            <?php if($errors->has('username')): ?>
                                                <p class="mt-2 mb-0 text-danger"><?php echo e($errors->first('username')); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label><?php echo e(__('Email') . '*'); ?></label>
                                            <input type="email" class="form-control" name="email"
                                                value="<?php echo e($admin->email); ?>">
                                            <?php if($errors->has('email')): ?>
                                                <p class="mt-2 mb-0 text-danger"><?php echo e($errors->first('email')); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label><?php echo e(__('Phone')); ?></label>
                                            <input type="text" class="form-control" name="phone"
                                                value="<?php echo e($admin->phone); ?>">
                                            <?php if($errors->has('phone')): ?>
                                                <p class="mt-2 mb-0 text-danger"><?php echo e($errors->first('phone')); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                </div>


                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox"
                                                            <?php echo e($admin->show_email_addresss == 1 ? 'checked' : ''); ?>

                                                            name="show_email_addresss" class="custom-control-input"
                                                            id="show_email_addresss">
                                                        <label class="custom-control-label"
                                                            for="show_email_addresss"><?php echo e(__('Show Email Address')); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox"
                                                            <?php echo e($admin->show_phone_number == 1 ? 'checked' : ''); ?>

                                                            name="show_phone_number" class="custom-control-input"
                                                            id="show_phone_number">
                                                        <label class="custom-control-label"
                                                            for="show_phone_number"><?php echo e(__('Show Phone Number')); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox"
                                                            <?php echo e($admin->show_contact_form == 1 ? 'checked' : ''); ?>

                                                            name="show_contact_form" class="custom-control-input"
                                                            id="show_contact_form">
                                                        <label class="custom-control-label"
                                                            for="show_contact_form"><?php echo e(__('Show  Contact Form')); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div id="accordion" class="mt-5">
                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="version">
                                                    <div class="version-header" id="heading<?php echo e($language->id); ?>">
                                                        <h5 class="mb-0">
                                                            <button type="button" class="btn btn-link "
                                                                data-toggle="collapse"
                                                                data-target="#collapse<?php echo e($language->id); ?>"
                                                                aria-expanded="<?php echo e($language->is_default == 1 ? 'true' : 'false'); ?>"
                                                                aria-controls="collapse<?php echo e($language->id); ?>">
                                                                <?php echo e($language->name . __(' Language')); ?>

                                                                <?php echo e($language->is_default == 1 ? '(Default)' : ''); ?>

                                                            </button>
                                                        </h5>
                                                    </div>

                                                    <?php
                                                        $vendor_info = App\Models\AdminInfo::where('admin_id', $admin->id)
                                                            ->where('language_id', $language->id)
                                                            ->first();
                                                    ?>

                                                    <div id="collapse<?php echo e($language->id); ?>"
                                                        class="collapse <?php echo e($language->is_default == 1 ? 'show' : ''); ?>"
                                                        aria-labelledby="heading<?php echo e($language->id); ?>"
                                                        data-parent="#accordion">
                                                        <div class="version-body">
                                                            <div class="row">
                                                                <div class="col-lg-4">
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <label><?php echo e(__('First Name*')); ?></label>
                                                                        <input type="text"
                                                                            value="<?php echo e(!empty($vendor_info) ? $vendor_info->first_name : ''); ?>"
                                                                            class="form-control"
                                                                            name="<?php echo e($language->code); ?>_first_name"
                                                                            placeholder="Enter First Name">

                                                                    </div>
                                                                </div>

                                                                <div class="col-lg-4">
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <label><?php echo e(__('Last Name*')); ?></label>
                                                                        <input type="text"
                                                                            value="<?php echo e(!empty($vendor_info) ? $vendor_info->last_name : ''); ?>"
                                                                            class="form-control"
                                                                            name="<?php echo e($language->code); ?>_last_name"
                                                                            placeholder="Enter Last Name">

                                                                    </div>
                                                                </div>


                                                                <div class="col-lg-4">
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <label><?php echo e(__('Country')); ?></label>
                                                                        <input type="text"
                                                                            value="<?php echo e(!empty($vendor_info) ? $vendor_info->country : ''); ?>"
                                                                            class="form-control"
                                                                            name="<?php echo e($language->code); ?>_country"
                                                                            placeholder="Enter Country">

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <label><?php echo e(__('City')); ?></label>
                                                                        <input type="text"
                                                                            value="<?php echo e(!empty($vendor_info) ? $vendor_info->city : ''); ?>"
                                                                            class="form-control"
                                                                            name="<?php echo e($language->code); ?>_city"
                                                                            placeholder="Enter City">

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <label><?php echo e(__('State')); ?></label>
                                                                        <input type="text"
                                                                            value="<?php echo e(!empty($vendor_info) ? $vendor_info->state : ''); ?>"
                                                                            class="form-control"
                                                                            name="<?php echo e($language->code); ?>_state"
                                                                            placeholder="Enter State">

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <label><?php echo e(__('Zip Code')); ?></label>
                                                                        <input type="text"
                                                                            value="<?php echo e(!empty($vendor_info) ? $vendor_info->zipcode : ''); ?>"
                                                                            class="form-control"
                                                                            name="<?php echo e($language->code); ?>_zip_code"
                                                                            placeholder="Enter Zip Code">

                                                                        </p>
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-12">
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <label><?php echo e(__('Address')); ?></label>
                                                                        <input type="text"
                                                                            name="<?php echo e($language->code); ?>_address"
                                                                            class="form-control"
                                                                            placeholder="Enter Address"
                                                                            value="<?php echo e(!empty($vendor_info) ? $vendor_info->address : ''); ?>">

                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-12">
                                                                    <div
                                                                        class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                        <label><?php echo e(__('Details')); ?></label>
                                                                        <textarea name="<?php echo e($language->code); ?>_details" class="form-control" rows="5" placeholder="Enter Details"><?php echo e(!empty($vendor_info) ? $vendor_info->details : ''); ?></textarea>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>


                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" form="editProfileForm" class="btn btn-success">
                                <?php echo e(__('Update')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/backend/admin/edit-profile.blade.php ENDPATH**/ ?>