<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('Edit Post')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Blog Management')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Posts')); ?></a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e(__('Edit Post')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block"><?php echo e(__('Edit Post')); ?></div>
                    <a class="btn btn-info btn-sm float-right d-inline-block"
                        href="<?php echo e(route('admin.blog_management.blogs', ['language' => $defaultLang->code])); ?>">
                        <span class="btn-label">
                            <i class="fas fa-backward"></i>
                        </span>
                        <?php echo e(__('Back')); ?>

                    </a>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8 offset-lg-2">
                            <div class="alert alert-danger pb-1 dis-none" id="blogErrors">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <ul></ul>
                            </div>

                            <form id="blogForm"
                                action="<?php echo e(route('admin.blog_management.update_blog', ['id' => $blog->id])); ?>"
                                method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for=""><?php echo e(__('Image') . '*'); ?></label>
                                    <br>
                                    <div class="thumb-preview">
                                        <img src="<?php echo e(asset('assets/img/blogs/' . $blog->image)); ?>" alt="image"
                                            class="uploaded-img">
                                    </div>

                                    <div class="mt-3">
                                        <div role="button" class="btn btn-primary btn-sm upload-btn">
                                            <?php echo e(__('Choose Image')); ?>

                                            <input type="file" class="img-input" name="image">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(__('Serial Number') . '*'); ?></label>
                                    <input class="form-control" type="number" name="serial_number"
                                        placeholder="Enter Serial Number" value="<?php echo e($blog->serial_number); ?>">
                                    <p class="text-warning mt-2 mb-0">
                                        <small><?php echo e(__('The higher the serial number is, the later the blog will be shown.')); ?></small>
                                    </p>
                                </div>


                                <div class="form-group">
                                    <label for=""><?php echo e(__('Status') . '*'); ?></label>
                                    <select name="status" class="form-control">
                                        <option disabled><?php echo e(__('Select Status')); ?></option>
                                        <option value="1" <?php echo e($blog->isActive ? 'selected' : ''); ?>><?php echo e(__('Active')); ?>

                                        </option>
                                        <option value="0" <?php echo e(!$blog->isActive ? 'selected' : ''); ?>>
                                            <?php echo e(__('Inactive')); ?></option>
                                    </select>

                                </div>

                                <div id="accordion" class="mt-3">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $blogData = $language->blogData; ?>

                                        <div class="version">
                                            <div class="version-header" id="heading<?php echo e($language->id); ?>">
                                                <h5 class="mb-0">
                                                    <button type="button"
                                                        class="btn btn-link <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>"
                                                        data-toggle="collapse" data-target="#collapse<?php echo e($language->id); ?>"
                                                        aria-expanded="<?php echo e($language->is_default == 1 ? 'true' : 'false'); ?>"
                                                        aria-controls="collapse<?php echo e($language->id); ?>">
                                                        <?php echo e($language->name . __(' Language')); ?>

                                                        <?php echo e($language->is_default == 1 ? '(Default)' : ''); ?>

                                                    </button>
                                                </h5>
                                            </div>

                                            <div id="collapse<?php echo e($language->id); ?>"
                                                class="collapse <?php echo e($language->is_default == 1 ? 'show' : ''); ?>"
                                                aria-labelledby="heading<?php echo e($language->id); ?>" data-parent="#accordion">
                                                <div class="version-body">
                                                    <div class="row">
                                                        <div class="col-lg-6">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Title') . '*'); ?></label>
                                                                <input type="text" class="form-control"
                                                                    name="<?php echo e($language->code); ?>_title"
                                                                    placeholder="Enter Title"
                                                                    value="<?php echo e(is_null($blogData) ? '' : $blogData->title); ?>">
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-6">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <?php $categories = $language->categories; ?>
                                                                <label for=""><?php echo e(__('Category') . '*'); ?></label>
                                                                <select name="<?php echo e($language->code); ?>_category_id"
                                                                    class="form-control">
                                                                    <?php if(is_null($blogData)): ?>
                                                                        <option selected disabled>
                                                                            <?php echo e(__('Select Category')); ?></option>
                                                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($category->id); ?>">
                                                                                <?php echo e($category->name); ?>

                                                                            </option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php else: ?>
                                                                        <option disabled><?php echo e(__('Select Category')); ?>

                                                                        </option>

                                                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($category->id); ?>"
                                                                                <?php echo e($blogData->blog_category_id == $category->id ? 'selected' : ''); ?>>
                                                                                <?php echo e($category->name); ?>

                                                                            </option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php endif; ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Author') . '*'); ?></label>
                                                                <input type="text" class="form-control"
                                                                    name="<?php echo e($language->code); ?>_author"
                                                                    placeholder="Enter Author Name"
                                                                    value="<?php echo e(is_null($blogData) ? '' : $blogData->author); ?>">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Content') . '*'); ?></label>
                                                                <textarea class="form-control summernote" name="<?php echo e($language->code); ?>_content" data-height="300"><?php echo e(is_null($blogData) ? '' : replaceBaseUrl($blogData->content, 'summernote')); ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Keywords')); ?></label>
                                                                <input class="form-control"
                                                                    name="<?php echo e($language->code); ?>_meta_keywords"
                                                                    placeholder="Enter Meta Keywords"
                                                                    data-role="tagsinput"
                                                                    value="<?php echo e(is_null($blogData) ? '' : $blogData->meta_keywords); ?>">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col">
                                                            <div
                                                                class="form-group <?php echo e($language->direction == 1 ? 'rtl text-right' : ''); ?>">
                                                                <label><?php echo e(__('Meta Description')); ?></label>
                                                                <textarea class="form-control" name="<?php echo e($language->code); ?>_meta_description" rows="5"
                                                                    placeholder="Enter Meta Description"><?php echo e(is_null($blogData) ? '' : $blogData->meta_description); ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" form="blogForm" class="btn btn-success">
                                <?php echo e(__('Update')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/admin-partial.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mwsserverco/public_html/realestate/resources/views/backend/journal/blog/edit.blade.php ENDPATH**/ ?>