<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Auth::login');

// Authentication routes
$routes->get('/login', 'Auth::login');
$routes->post('/login', 'Auth::loginProcess');
$routes->get('/logout', 'Auth::logout');

// Protected routes
$routes->get('/dashboard', 'Dashboard::index');
$routes->get('/files', 'Files::index');
$routes->get('/files/upload', 'Files::upload');
$routes->post('/files/upload', 'Files::upload');
$routes->post('/files/update', 'Files::update');
$routes->post('/files/delete', 'Files::delete');
$routes->get('/files/view/(:num)', 'Files::view/$1');

// Reports routes
$routes->get('/reports', 'Reports::index');
$routes->post('/reports/generate', 'Reports::generateData');
$routes->get('/reports/tab-data/(:alpha)/(:num)', 'Reports::getTabData/$1/$2');
