<?php

namespace App\Controllers;

class Auth extends BaseController
{
    public function login()
    {
        return view('login');
    }
    
    public function loginProcess()
    {
        // Handle login form submission
        $session = session();
        
        $username = $this->request->getPost('uname');
        $password = $this->request->getPost('pass');
        
        // Validate input
        if (empty($username)) {
            return $this->response->setJSON([
                'sts' => false,
                'type' => 'error',
                'msg' => 'Please Enter User Name!'
            ]);
        }
        
        if (empty($password)) {
            return $this->response->setJSON([
                'sts' => false,
                'type' => 'error',
                'msg' => 'Please Enter password!'
            ]);
        }
        
        // Load UserModel for database authentication
        $userModel = new \App\Models\UserModel();
        
        // Check if user exists
        $user = $userModel->where('uname', $username)->first();
        
        if (!$user) {
            return $this->response->setJSON([
                'sts' => false,
                'type' => 'error',
                'msg' => 'Login Details Not found!'
            ]);
        }
        
        // Check if user account is active
        if ($user['status'] == 0) {
            return $this->response->setJSON([
                'sts' => false,
                'type' => 'error',
                'msg' => 'Your Account is inactive contact your administrator!'
            ]);
        }
        
        // Verify password using password_verify for hashed passwords
        if (!password_verify($password, $user['password'])) {
            return $this->response->setJSON([
                'sts' => false,
                'type' => 'error',
                'msg' => 'Password Invalid, Please Enter Correct Password!'
            ]);
        }
        
        // Set session data
        $session->set([
            'login' => true,
            'uId' => $user['id'],
            'uName' => $user['uname'],
            'Name' => $user['name'],
            'logged_in' => true,
            'user_id' => $user['id'],
            'username' => $user['uname']
        ]);
        
        return $this->response->setJSON([
            'sts' => true,
            'type' => 'success',
            'msg' => 'Login Successful!'
        ]);
    }
    
    public function logout()
    {
        $session = session();
        $session->destroy();
        
        return redirect()->to('/login')->with('success', 'You have been logged out successfully');
    }
}