<?php

namespace App\Controllers;

use App\Models\FileUploadModel;
use App\Models\UserModel;

class Dashboard extends BaseController
{
    protected $fileUploadModel;
    protected $userModel;
    
    public function __construct()
    {
        $this->fileUploadModel = new FileUploadModel();
        $this->userModel = new UserModel();
    }
    
    public function index()
    {
        $session = session();
        
        // Check if user is logged in
        if (!$session->get('logged_in')) {
            return redirect()->to('/login');
        }
        
        // Get dashboard data
        $data = [
            'title' => 'Dashboard - Reports',
            'username' => $session->get('username'),
            'totalFiles' => $this->fileUploadModel->countAll(),
            'totalUsers' => $this->userModel->countAll(),
            'recentFiles' => [$this->fileUploadModel->first()], // Single file record
            'fileStats' => $this->getFileStatistics()
        ];
        
        return view('dashboard', $data);
    }
    
    private function getFileStatistics()
    {
        // Get file statistics for charts/reports
        $stats = [
            'today' => $this->fileUploadModel->where('DATE(media_modification_time)', date('Y-m-d'))->countAllResults(),
            'this_week' => $this->fileUploadModel->where('media_modification_time >=', date('Y-m-d', strtotime('-7 days')))->countAllResults(),
            'this_month' => $this->fileUploadModel->where('media_modification_time >=', date('Y-m-01'))->countAllResults(),
            'total' => $this->fileUploadModel->countAll()
        ];
        
        return $stats;
    }
}