<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateFileUploadTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'file_id' => [
                'type'           => 'INT',
                'auto_increment' => true,
                'null'           => false,
            ],
            'file_importer' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'file_exporter' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'source_file' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'exporter_output_file' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'importer_output_file' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'media_modification_time' => [
                'type' => 'DATETIME',
                'null' => false,
            ],
        ]);

        $this->forge->addKey('file_id', true);
        
        $this->forge->createTable('file_upload', true, [
            'ENGINE' => 'InnoDB',
            'DEFAULT CHARSET' => 'utf8',
        ]);
    }

    public function down()
    {
        $this->forge->dropTable('file_upload');
    }
}