<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class UserSeeder extends Seeder
{
    public function run()
    {
        $data = [
            'uname' => 'admin',
            'name' => 'Administrator',
            'password' => password_hash('123456', PASSWORD_DEFAULT),
            'status' => 1,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        ];

        // Check if user already exists
        $userModel = new \App\Models\UserModel();
        $existingUser = $userModel->where('uname', 'admin')->first();
        
        if (!$existingUser) {
            $userModel->insert($data);
            echo "Admin user created successfully with username: admin and password: 123456\n";
        } else {
            // Update existing user with hashed password
            $userModel->where('uname', 'admin')->set(['password' => $data['password']])->update();
            echo "Admin user password updated with hashed password (123456)\n";
        }
    }
}