<?php

namespace App\Models;

use CodeIgniter\Model;

class FileUploadModel extends Model
{
    protected $table = 'file_upload';
    protected $primaryKey = 'id';
    
    protected $allowedFields = [
        'file_importer', 'file_exporter', 'source_file', 
        'exporter_output_file', 'importer_output_file', 
        'media_modification_time'
    ];
    
    protected $useTimestamps = false; // We're using custom datetime field
    
    // Get the single file record (no pagination needed)
    public function getFilesPaginated($perPage = 10)
    {
        $file = $this->first();
        return $file ? [$file] : [];
    }
    
    // Search files by filename or path
    public function searchFiles($searchTerm)
    {
        return $this->like('source_file', $searchTerm)
                    ->orLike('exporter_output_file', $searchTerm)
                    ->orLike('importer_output_file', $searchTerm)
                    ->orderBy('id', 'DESC')
                    ->findAll();
    }
    
    // Get recent files
    public function getRecentFiles($limit = 10)
    {
        return $this->orderBy('media_modification_time', 'DESC')
                    ->limit($limit)
                    ->findAll();
    }
    
    // Get files count by type
    public function getFilesCountByType()
    {
        return [
            'with_importer' => $this->where('file_importer IS NOT NULL')->countAllResults(false),
            'with_exporter' => $this->where('file_exporter IS NOT NULL')->countAllResults(false),
            'with_source' => $this->where('source_file IS NOT NULL')->countAllResults(false),
        ];
    }
}