<?= $this->include('templates/header') ?>

<div class="container-fluid">
    <div class="row">
        <?= $this->include('templates/sidebar') ?>
        
        <main class="col-md-10 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Dashboard</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <span class="text-muted">Welcome, <?= esc($username) ?></span>
                        <a href="<?= base_url('/logout') ?>" class="btn btn-outline-danger btn-sm ms-3">Logout</a>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        Total Files</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $totalFiles ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-files fs-2 text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Files Today</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $fileStats['today'] ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-calendar-day fs-2 text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-info shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                        This Week</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $fileStats['this_week'] ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-calendar-week fs-2 text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-warning shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                        Total Users</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $totalUsers ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-people fs-2 text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Files Table -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Recent Files</h6>
                </div>
                <div class="card-body">
                    <?php if (!empty($recentFiles)): ?>
                        <div class="table-responsive">
                            <table class="table table-bordered" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Source File</th>
                                        <th>File Importer</th>
                                        <th>File Exporter</th>
                                        <th>Last Modified</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recentFiles as $file): ?>
                                        <tr>
                                            <td><?= $file['id'] ?></td>
                                            <td><?= esc($file['source_file']) ?></td>
                                            <td><?= esc($file['file_importer']) ?></td>
                                            <td><?= esc($file['file_exporter']) ?></td>
                                            <td><?= date('M d, Y H:i', strtotime($file['media_modification_time'])) ?></td>
                                            <td>
                                                <a href="<?= base_url('/files/view/' . $file['id']) ?>" class="btn btn-sm btn-primary">View</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center mt-3">
                            <a href="<?= base_url('/files') ?>" class="btn btn-primary">View All Files</a>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="bi bi-inbox display-4 text-muted"></i>
                            <p class="mt-3 text-muted">No files uploaded yet.</p>
                            <a href="<?= base_url('/files') ?>" class="btn btn-primary">Upload Your First File</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
</div>

<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}
.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}
.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}
.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}
.text-gray-300 {
    color: #dddfeb !important;
}
.text-gray-800 {
    color: #5a5c69 !important;
}
</style>

<?= $this->include('templates/footer') ?>