<?= $this->include('templates/header') ?>

<div class="container-fluid">
  <div class="row">
    <?= $this->include('templates/sidebar') ?>

    <main class="col-md-10 ms-sm-auto col-lg-10 px-md-4">
      <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Data Upload</h1>
        <div class="btn-toolbar mb-2 mb-md-0">
          <div class="btn-group me-2">
            <span class="text-muted">Welcome, <?= esc($username) ?></span>
            <a href="<?= base_url('/logout') ?>" class="btn btn-outline-danger btn-sm ms-3">Logout</a>
          </div>
        </div>
      </div>

      <div class="card mb-4">
        <div class="card-body">
          <h5 class="card-title mb-3">File Upload Requirements</h5>
          <div class="alert alert-info">
            <strong>These Three files are required:</strong><br>
            <ul class="mb-0">
              <li><strong>ICE_DATA_file.csv:</strong> ICE number must be first column</li>
              <li><strong>importer_file.csv:</strong> ICE number must be second column</li>
              <li><strong>exporter_file.csv:</strong> ICE number must be second column</li>
            </ul>
          </div>
          
          <!-- Success/Error Messages -->
          <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              <i class="bi bi-check-circle-fill me-2"></i>
              <?= session()->getFlashdata('success') ?>
              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
          <?php endif; ?>
          
          <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
              <i class="bi bi-exclamation-triangle-fill me-2"></i>
              <?= session()->getFlashdata('error') ?>
              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
          <?php endif; ?>
          
          <?php if (session()->getFlashdata('errors')): ?>
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
              <i class="bi bi-exclamation-triangle-fill me-2"></i>
              <strong>Validation Errors:</strong>
              <ul class="mb-0 mt-2">
                <?php foreach (session()->getFlashdata('errors') as $error): ?>
                  <li><?= esc($error) ?></li>
                <?php endforeach; ?>
              </ul>
              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
          <?php endif; ?>
          
          <div class="col-12" id="error-div"></div>

          <!-- File Upload Form -->
          <form method="post" enctype="multipart/form-data" action="<?= base_url('/files/upload') ?>">
            <?= csrf_field() ?>
            <div class="row g-3">
              <!-- Importer File -->
              <div class="col-md-4">
                <div class="card h-100">
                  <div class="card-body text-center">
                    <i class="bi bi-file-excel display-4 text-success mb-3"></i>
                    <h6>Importer File</h6>
                    <input type="file" name="importer_file" class="form-control mb-2" accept=".csv,.xlsx,.xls">
                    <small class="text-muted">ICE number must be second column</small>
                    <div class="file-actions">
                      <a href="<?= base_url('example_csv_files/importer_file.csv') ?>"
                        class="btn btn-info btn-sm demo-link" target="_blank">
                        <i class="bi bi-download"></i> View Importer Demo Files
                      </a>
                      <div class="btn-group w-100" role="group">
                        <button type="button" class="btn btn-primary btn-sm" onclick="updateFile('importer')">
                          <i class="bi bi-pencil"></i> Update
                        </button>
                        <button type="button" class="btn btn-danger btn-sm" onclick="deleteFile('importer')">
                          <i class="bi bi-trash"></i> Delete
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Exporter File -->
              <div class="col-md-4">
                <div class="card h-100">
                  <div class="card-body text-center">
                    <i class="bi bi-file-excel display-4 text-info mb-3"></i>
                    <h6>Exporter File</h6>
                    <input type="file" name="exporter_file" class="form-control mb-2" accept=".csv,.xlsx,.xls">
                    <small class="text-muted">ICE number must be second column</small>
                    <div class="file-actions">
                      <a href="<?= base_url('example_csv_files/exporter_file.csv') ?>"
                        class="btn btn-info btn-sm demo-link" target="_blank">
                        <i class="bi bi-download"></i> View Exporter Demo Files
                      </a>
                      <div class="btn-group w-100" role="group">
                        <button type="button" class="btn btn-primary btn-sm" onclick="updateFile('exporter')">
                          <i class="bi bi-pencil"></i> Update
                        </button>
                        <button type="button" class="btn btn-danger btn-sm" onclick="deleteFile('exporter')">
                          <i class="bi bi-trash"></i> Delete
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Source File -->
              <div class="col-md-4">
                <div class="card h-100">
                  <div class="card-body text-center">
                    <i class="bi bi-file-excel display-4 text-warning mb-3"></i>
                    <h6>ICE GATE Source File</h6>
                    <input type="file" name="source_file" class="form-control mb-2" accept=".csv,.xlsx,.xls">
                    <small class="text-muted">ICE number must be first column</small>
                    <div class="file-actions">
                      <a href="<?= base_url('example_csv_files/ICEGATE_Data2.csv') ?>"
                        class="btn btn-info btn-sm demo-link" target="_blank">
                        <i class="bi bi-download"></i> View Source Demo Files
                      </a>
                      <div class="btn-group w-100" role="group">
                        <button type="button" class="btn btn-primary btn-sm" onclick="updateFile('source')">
                          <i class="bi bi-pencil"></i> Update
                        </button>
                        <button type="button" class="btn btn-danger btn-sm" onclick="deleteFile('source')">
                          <i class="bi bi-trash"></i> Delete
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="text-center mt-4">
              <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-upload"></i> Upload Files
              </button>
            </div>
          </form>
        </div>
      </div>
    </main>
  </div>
</div>

<!-- Custom CSS for file buttons -->
<style>
  .file-actions {
    margin-top: 1rem;
  }

  .file-actions .btn {
    margin: 2px;
    font-size: 0.85rem;
  }

  .demo-link {
    display: block;
    margin-bottom: 8px;
  }

  .btn-group .btn {
    flex: 1;
  }
</style>

<!-- Update/Delete Modals and JavaScript -->
<script>
  function updateFile(fileType) {
    // Show confirmation dialog
    if (confirm('Are you sure you want to update the ' + fileType + ' file?')) {
      // Create a form to trigger file selection
      let input = document.createElement('input');
      input.type = 'file';
      input.accept = '.csv,.xlsx,.xls';
      input.onchange = function (e) {
        let file = e.target.files[0];
        if (file) {
          // Create form data and submit
          let formData = new FormData();
          formData.append('file', file);
          formData.append('file_type', fileType);
          formData.append('<?= csrf_token() ?>', '<?= csrf_hash() ?>');

          fetch('<?= base_url('/files/update') ?>', {
            method: 'POST',
            body: formData
          })
            .then(response => response.json())
            .then(data => {
              if (data.sts) {
                alert(data.msg);
                location.reload();
              } else {
                alert('Error: ' + data.msg);
              }
            })
            .catch(error => {
              console.error('Error:', error);
              alert('An error occurred while updating the file.');
            });
        }
      };
      input.click();
    }
  }

  function deleteFile(fileType) {
    if (confirm('Are you sure you want to delete the ' + fileType + ' file? This action cannot be undone.')) {
      fetch('<?= base_url('/files/delete') ?>', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({
          file_type: fileType,
          '<?= csrf_token() ?>': '<?= csrf_hash() ?>'
        })
      })
        .then(response => response.json())
        .then(data => {
          if (data.sts) {
            alert(data.msg);
            location.reload();
          } else {
            alert('Error: ' + data.msg);
          }
        })
        .catch(error => {
          console.error('Error:', error);
          alert('An error occurred while deleting the file.');
        });
    }
  }

  // Auto-hide success messages after 5 seconds
  document.addEventListener('DOMContentLoaded', function() {
    const successAlert = document.querySelector('.alert-success');
    if (successAlert) {
      setTimeout(function() {
        successAlert.classList.remove('show');
        setTimeout(function() {
          successAlert.remove();
        }, 150);
      }, 5000);
    }

    // Add form submission loading state
    const uploadForm = document.querySelector('form[action*="files/upload"]');
    if (uploadForm) {
      uploadForm.addEventListener('submit', function(e) {
        const submitBtn = uploadForm.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        
        // Check if at least one file is selected
        const files = uploadForm.querySelectorAll('input[type="file"]');
        let hasFile = false;
        
        files.forEach(file => {
          if (file.files.length > 0) {
            hasFile = true;
          }
        });
        
        if (!hasFile) {
          e.preventDefault();
          alert('Please select at least one file to upload.');
          return;
        }
        
        // Show loading state
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i> Uploading...';
        
        // Re-enable button after 10 seconds (in case of error)
        setTimeout(function() {
          submitBtn.disabled = false;
          submitBtn.innerHTML = originalText;
        }, 10000);
      });
    }
  });
</script>

<?= $this->include('templates/footer') ?>