<?= $this->include('templates/header') ?>

<div class="container-fluid">
  <div class="row">
    <?= $this->include('templates/sidebar') ?>

    <main class="col-md-10 col-lg-10">
      <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Reports</h1>
        <div class="btn-toolbar mb-2 mb-md-0">
          <div class="btn-group me-2">
            <span class="text-muted">Welcome, <?= esc($username) ?></span>
            <a href="<?= base_url('/logout') ?>" class="btn btn-outline-danger btn-sm ms-3">Logout</a>
          </div>
        </div>
      </div>

      <!-- Generate Data Button -->
      <div class="card mb-4">
        <div class="card-body">
          <button type="button" id="generateDataBtn" class="btn btn-info">
            <i class="bi bi-gear"></i> Generate Data
          </button>
          <div id="generateStatus" class="mt-2"></div>
        </div>
      </div>

      <!-- Data Tabs -->
      <div class="card">
        <div class="card-body">
          <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
            <li class="nav-item" role="presentation">
              <button class="nav-link active" id="pills-importer-tab" data-bs-toggle="pill"
                data-bs-target="#pills-importer" type="button" role="tab" aria-controls="pills-importer"
                aria-selected="true">
                Importer Data
              </button>
            </li>
            <li class="nav-item" role="presentation">
              <button class="nav-link" id="pills-exporter-tab" data-bs-toggle="pill" data-bs-target="#pills-exporter"
                type="button" role="tab" aria-controls="pills-exporter" aria-selected="false">
                Exporter Data
              </button>
            </li>
          </ul>

          <div class="tab-content" id="pills-tabContent">
            <!-- Importer Data Tab -->
            <div class="tab-pane fade show active" id="pills-importer" role="tabpanel"
              aria-labelledby="pills-importer-tab">
              <div class="row mb-3">
                <div class="col-md-6">
                  <h5 class="card-title">Importer Data</h5>
                </div>
                <div class="col-md-6 text-end">
                  <?php if (!empty($fileRecord['importer_output_file'])): ?>
                    <a href="<?= base_url('uploads/' . $fileRecord['importer_output_file']) ?>"
                      class="btn btn-success btn-sm" download>
                      <i class="bi bi-download"></i> Download Importer Data
                    </a>
                  <?php endif; ?>
                </div>
              </div>
              <div id="importer-data-container">
                <?php if (!empty($importerData['pagination']['hasData'])): ?>
                  <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                      <?php 
                      $headers = null;
                      $displayData = [];
                      foreach ($importerData['data'] as $index => $row) {
                        if ($index === 0) {
                          $headers = $row; // First row is headers
                        } else {
                          $displayData[] = $row; // Rest are data rows
                        }
                      }
                      ?>
                      
                      <?php if ($headers): ?>
                        <thead class="table-dark">
                          <tr>
                            <?php foreach ($headers as $header): ?>
                              <th><?= esc($header) ?></th>
                            <?php endforeach; ?>
                          </tr>
                        </thead>
                      <?php endif; ?>
                      
                      <tbody>
                        <?php foreach ($displayData as $row): ?>
                          <tr>
                            <?php foreach ($row as $cell): ?>
                              <td><?= esc($cell) ?></td>
                            <?php endforeach; ?>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  </div>

                  <!-- Pagination -->
                  <?php if ($importerData['pagination']['totalPages'] > 1): ?>
                    <!-- Pagination Info -->
                    <div class="d-flex justify-content-between align-items-center mb-3">
                      <div class="text-muted">
                        <?php 
                        $currentPage = $importerData['pagination']['currentPage'] + 1;
                        $totalPages = $importerData['pagination']['totalPages'];
                        $perPage = $importerData['pagination']['perPage'];
                        $currentItems = count($importerData['data']) - 1; // Subtract 1 for header
                        $startItem = ($importerData['pagination']['currentPage'] * $perPage) + 1;
                        $endItem = $startItem + $currentItems - 1;
                        $totalEntries = $importerData['pagination']['totalEntries'] ?? 0;
                        ?>
                        Showing <?= $startItem ?> to <?= $endItem ?> of <?= $totalEntries ?> entries
                      </div>
                      <div class="text-muted">
                        Page <?= $currentPage ?> of <?= $totalPages ?>
                      </div>
                    </div>
                    
                    <nav aria-label="Importer data pagination">
                      <ul class="pagination justify-content-center">
                        <!-- Previous Button -->
                        <li class="page-item <?= $importerData['pagination']['currentPage'] == 0 ? 'disabled' : '' ?>">
                          <a class="page-link pagination-link" href="#" data-page="<?= $importerData['pagination']['currentPage'] ?>" data-type="importer">
                            &laquo; Previous
                          </a>
                        </li>
                        
                        <?php 
                        $currentPage = $importerData['pagination']['currentPage'];
                        $totalPages = $importerData['pagination']['totalPages'];
                        
                        // Calculate start and end for 3 visible pages
                        $startPage = max(0, $currentPage - 1);
                        $endPage = min($totalPages - 1, $startPage + 2);
                        
                        // Adjust start if we're near the end
                        if ($endPage - $startPage < 2) {
                          $startPage = max(0, $endPage - 2);
                        }
                        
                        for ($i = $startPage; $i <= $endPage; $i++): ?>
                          <li class="page-item <?= $i === $currentPage ? 'active' : '' ?>">
                            <a class="page-link pagination-link" href="#" data-page="<?= $i + 1 ?>" data-type="importer">
                              <?= $i + 1 ?>
                            </a>
                          </li>
                        <?php endfor; ?>
                        
                        <!-- Next Button -->
                        <li class="page-item <?= $importerData['pagination']['currentPage'] >= $totalPages - 1 ? 'disabled' : '' ?>">
                          <a class="page-link pagination-link" href="#" data-page="<?= $importerData['pagination']['currentPage'] + 2 ?>" data-type="importer">
                            Next &raquo;
                          </a>
                        </li>
                      </ul>
                    </nav>
                  <?php endif; ?>
                <?php else: ?>
                  <div class="text-center py-4">
                    <i class="bi bi-inbox display-4 text-muted"></i>
                    <p class="mt-3 text-muted">No importer data available. Please generate data first.</p>
                  </div>
                <?php endif; ?>
              </div>
            </div>

            <!-- Exporter Data Tab -->
            <div class="tab-pane fade" id="pills-exporter" role="tabpanel" aria-labelledby="pills-exporter-tab">
              <div class="row mb-3">
                <div class="col-md-6">
                  <h5 class="card-title">Exporter Data</h5>
                </div>
                <div class="col-md-6 text-end">
                  <?php if (!empty($fileRecord['exporter_output_file'])): ?>
                    <a href="<?= base_url('uploads/' . $fileRecord['exporter_output_file']) ?>"
                      class="btn btn-success btn-sm" download>
                      <i class="bi bi-download"></i> Download Exporter Data
                    </a>
                  <?php endif; ?>
                </div>
              </div>

              <div id="exporter-data-container">
                <?php if (!empty($exporterData['pagination']['hasData'])): ?>
                  <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                      <?php 
                      $headers = null;
                      $displayData = [];
                      foreach ($exporterData['data'] as $index => $row) {
                        if ($index === 0) {
                          $headers = $row; // First row is headers
                        } else {
                          $displayData[] = $row; // Rest are data rows
                        }
                      }
                      ?>
                      
                      <?php if ($headers): ?>
                        <thead class="table-dark">
                          <tr>
                            <?php foreach ($headers as $header): ?>
                              <th><?= esc($header) ?></th>
                            <?php endforeach; ?>
                          </tr>
                        </thead>
                      <?php endif; ?>
                      
                      <tbody>
                        <?php foreach ($displayData as $row): ?>
                          <tr>
                            <?php foreach ($row as $cell): ?>
                              <td><?= esc($cell) ?></td>
                            <?php endforeach; ?>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  </div>

                  <!-- Pagination -->
                  <?php if ($exporterData['pagination']['totalPages'] > 1): ?>
                    <!-- Pagination Info -->
                    <div class="d-flex justify-content-between align-items-center mb-3">
                      <div class="text-muted">
                        <?php 
                        $currentPage = $exporterData['pagination']['currentPage'] + 1;
                        $totalPages = $exporterData['pagination']['totalPages'];
                        $perPage = $exporterData['pagination']['perPage'];
                        $currentItems = count($exporterData['data']) - 1; // Subtract 1 for header
                        $startItem = ($exporterData['pagination']['currentPage'] * $perPage) + 1;
                        $endItem = $startItem + $currentItems - 1;
                        $totalEntries = $exporterData['pagination']['totalEntries'] ?? 0;
                        ?>
                        Showing <?= $startItem ?> to <?= $endItem ?> of <?= $totalEntries ?> entries
                      </div>
                      <div class="text-muted">
                        Page <?= $currentPage ?> of <?= $totalPages ?>
                      </div>
                    </div>
                    
                    <nav aria-label="Exporter data pagination">
                      <ul class="pagination justify-content-center">
                        <!-- Previous Button -->
                        <li class="page-item <?= $exporterData['pagination']['currentPage'] == 0 ? 'disabled' : '' ?>">
                          <a class="page-link pagination-link" href="#" data-page="<?= $exporterData['pagination']['currentPage'] ?>" data-type="exporter">
                            &laquo; Previous
                          </a>
                        </li>
                        
                        <?php 
                        $currentPage = $exporterData['pagination']['currentPage'];
                        $totalPages = $exporterData['pagination']['totalPages'];
                        
                        // Calculate start and end for 3 visible pages
                        $startPage = max(0, $currentPage - 1);
                        $endPage = min($totalPages - 1, $startPage + 2);
                        
                        // Adjust start if we're near the end
                        if ($endPage - $startPage < 2) {
                          $startPage = max(0, $endPage - 2);
                        }
                        
                        for ($i = $startPage; $i <= $endPage; $i++): ?>
                          <li class="page-item <?= $i === $currentPage ? 'active' : '' ?>">
                            <a class="page-link pagination-link" href="#" data-page="<?= $i + 1 ?>" data-type="exporter">
                              <?= $i + 1 ?>
                            </a>
                          </li>
                        <?php endfor; ?>
                        
                        <!-- Next Button -->
                        <li class="page-item <?= $exporterData['pagination']['currentPage'] >= $totalPages - 1 ? 'disabled' : '' ?>">
                          <a class="page-link pagination-link" href="#" data-page="<?= $exporterData['pagination']['currentPage'] + 2 ?>" data-type="exporter">
                            Next &raquo;
                          </a>
                        </li>
                      </ul>
                    </nav>
                  <?php endif; ?>
                <?php else: ?>
                  <div class="text-center py-4">
                    <i class="bi bi-inbox display-4 text-muted"></i>
                    <p class="mt-3 text-muted">No exporter data available. Please generate data first.</p>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    // Generate Data Button
    document.getElementById('generateDataBtn').addEventListener('click', function () {
      let btn = this;
      let statusDiv = document.getElementById('generateStatus');

      btn.disabled = true;
      btn.innerHTML = '<i class="spinner-border spinner-border-sm me-2"></i>Generating...';

      fetch('<?= base_url('/reports/generate') ?>', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-Requested-With': 'XMLHttpRequest'
        }
      })
        .then(response => response.json())
        .then(data => {
          if (data.status === 'success') {
            statusDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
            // Reload the page to show generated data
            setTimeout(() => {
              window.location.reload();
            }, 1500);
          } else {
            statusDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
          }
        })
        .catch(error => {
          statusDiv.innerHTML = '<div class="alert alert-danger">Error generating data</div>';
        })
        .finally(() => {
          btn.disabled = false;
          btn.innerHTML = '<i class="bi bi-gear"></i> Generate Data';
        });
    });

    // Pagination handlers
    document.addEventListener('click', function (e) {
      if (e.target.classList.contains('pagination-link')) {
        e.preventDefault();
        
        // Check if the parent li has disabled class
        if (e.target.closest('li').classList.contains('disabled')) {
          return;
        }
        
        let page = e.target.getAttribute('data-page');
        let type = e.target.getAttribute('data-type');
        loadTabData(type, page);
      }
    });
  });

  function loadTabData(type, page) {
    let container = document.getElementById(type + '-data-container');
    container.innerHTML = '<div class="text-center py-4"><div class="spinner-border"></div></div>';
    
    console.log('Loading tab data:', type, page);

    fetch('<?= base_url('reports/tab-data') ?>/' + type + '/' + page)
      .then(response => {
        console.log('Response status:', response.status);
        if (!response.ok) {
          throw new Error('HTTP error! status: ' + response.status);
        }
        return response.json();
      })
      .then(data => {
        console.log('Received data:', data);
        
        // Check if there's an error in the response
        if (data.status === 'error') {
          container.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
          return;
        }
        
        // Check if we have data and pagination info
        if (data.data && data.pagination && data.pagination.hasData && data.data.length > 0) {
          renderTable(container, data, type);
        } else {
          container.innerHTML = '<div class="text-center py-4"><i class="bi bi-inbox display-4 text-muted"></i><p class="mt-3 text-muted">No data available for this page.</p></div>';
        }
      })
      .catch(error => {
        console.error('Error:', error);
        container.innerHTML = '<div class="alert alert-danger">Error loading data: ' + error.message + '</div>';
      });
  }

  function renderTable(container, data, type) {
    console.log('Rendering table with data:', data);
    
    // Convert data object to array if needed
    let dataArray = Array.isArray(data.data) ? data.data : Object.values(data.data);
    
    let headers = null;
    let displayData = [];
    
    // Separate headers from data
    dataArray.forEach((row, index) => {
      if (index === 0) {
        headers = row;
      } else if (row && Array.isArray(row)) {
        displayData.push(row);
      }
    });

    console.log('Headers:', headers);
    console.log('Display data:', displayData);

    let tableHtml = '<div class="table-responsive">';
    tableHtml += '<table class="table table-bordered table-striped">';
    
    // Headers
    if (headers && Array.isArray(headers)) {
      tableHtml += '<thead class="table-dark"><tr>';
      headers.forEach(header => {
        tableHtml += '<th>' + escapeHtml(header || '') + '</th>';
      });
      tableHtml += '</tr></thead>';
    }
    
    // Data rows
    tableHtml += '<tbody>';
    displayData.forEach(row => {
      if (row && Array.isArray(row)) {
        tableHtml += '<tr>';
        row.forEach(cell => {
          tableHtml += '<td>' + escapeHtml(cell || '') + '</td>';
        });
        tableHtml += '</tr>';
      }
    });
    tableHtml += '</tbody></table></div>';

    // Pagination
    if (data.pagination && data.pagination.totalPages > 1) {
      let currentPage = data.pagination.currentPage;
      let totalPages = data.pagination.totalPages;
      let perPage = data.pagination.perPage;
      let currentItems = displayData.length;
      let startItem = (currentPage * perPage) + 1;
      let endItem = startItem + currentItems - 1;
      let totalEntries = data.pagination.totalEntries || 0;
      
      // Pagination Info
      tableHtml += '<div class="d-flex justify-content-between align-items-center mb-3">';
      tableHtml += '<div class="text-muted">';
      tableHtml += 'Showing ' + startItem + ' to ' + endItem + ' of ' + totalEntries + ' entries';
      tableHtml += '</div>';
      tableHtml += '<div class="text-muted">';
      tableHtml += 'Page ' + (currentPage + 1) + ' of ' + totalPages;
      tableHtml += '</div>';
      tableHtml += '</div>';
      
      tableHtml += '<nav aria-label="' + type + ' data pagination">';
      tableHtml += '<ul class="pagination justify-content-center">';
      
      // Previous Button
      let prevDisabled = currentPage === 0 ? 'disabled' : '';
      let prevPage = currentPage > 0 ? currentPage : 1;
      tableHtml += '<li class="page-item ' + prevDisabled + '">';
      tableHtml += '<a class="page-link pagination-link" href="#" data-page="' + prevPage + '" data-type="' + type + '">';
      tableHtml += '&laquo; Previous</a></li>';
      
      // Calculate start and end for 3 visible pages
      let startPage = Math.max(0, currentPage - 1);
      let endPage = Math.min(totalPages - 1, startPage + 2);
      
      // Adjust start if we're near the end
      if (endPage - startPage < 2) {
        startPage = Math.max(0, endPage - 2);
      }
      
      // Page numbers
      for (let i = startPage; i <= endPage; i++) {
        let isActive = i === currentPage ? 'active' : '';
        tableHtml += '<li class="page-item ' + isActive + '">';
        tableHtml += '<a class="page-link pagination-link" href="#" data-page="' + (i + 1) + '" data-type="' + type + '">';
        tableHtml += (i + 1) + '</a></li>';
      }
      
      // Next Button
      let nextDisabled = currentPage >= totalPages - 1 ? 'disabled' : '';
      let nextPage = currentPage < totalPages - 1 ? currentPage + 2 : totalPages;
      tableHtml += '<li class="page-item ' + nextDisabled + '">';
      tableHtml += '<a class="page-link pagination-link" href="#" data-page="' + nextPage + '" data-type="' + type + '">';
      tableHtml += 'Next &raquo;</a></li>';
      
      tableHtml += '</ul></nav>';
    }

    container.innerHTML = tableHtml;
  }

  function escapeHtml(text) {
    const map = {
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#039;'
    };
    return String(text).replace(/[&<>"']/g, function(m) { return map[m]; });
  }
</script>

<?= $this->include('templates/footer') ?>