<?php if (!empty($data['data'])): ?>
    <div class="table-responsive">
        <table class="table table-striped table-bordered" style="width:auto;">
            <thead>
                <tr>
                    <th width="8%">S No.</th>
                    <th width="10%">IEC</th>
                    <th width="25%"><?= $type === 'importer' ? 'Importer' : 'Exporter' ?> Name</th>
                    <th>M/s.</th>
                    <th>City</th>
                    <th width="5%">BCD Value</th>
                    <th width="5%">Number of Scroll</th>
                    <th width="5%">Scroll Value</th>
                    <th width="5%">Formula</th>
                    <th width="10%">Contact Number</th>
                    <th width="10%">Email ID</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $serialStart = (($data['page'] - 1) * $data['perPage']) + 1;
                foreach ($data['data'] as $index => $row): 
                ?>
                    <tr>
                        <td width="8%"><?= $serialStart + $index ?></td>
                        <td width="10%"><?= esc($row['IEC'] ?? $row[array_keys($row)[1]] ?? '') ?></td>
                        <td width="25%"><?= esc($row['Importer Name'] ?? $row['Exporter Name'] ?? $row[array_keys($row)[2]] ?? '') ?></td>
                        <td><?= esc($row['M/s.'] ?? $row[array_keys($row)[3]] ?? '') ?></td>
                        <td><?= esc($row['City'] ?? $row[array_keys($row)[4]] ?? '') ?></td>
                        <td width="5%"><?= esc($row['BCD Value'] ?? $row[array_keys($row)[6]] ?? '') ?></td>
                        <td width="5%"><?= esc($row['Number of Scroll'] ?? $row[array_keys($row)[7]] ?? '') ?></td>
                        <td width="5%"><?= esc($row['Scroll Value'] ?? $row[array_keys($row)[8]] ?? '') ?></td>
                        <td width="5%"><?= esc($row['Formula'] ?? $row[array_keys($row)[9]] ?? '') ?></td>
                        <td width="10%"><?= esc($row['Contact Number'] ?? $row[array_keys($row)[10]] ?? '') ?></td>
                        <td width="10%"><?= esc($row['Email ID'] ?? $row[array_keys($row)[11]] ?? '') ?></td>
                        <td><?= esc($row['Remarks'] ?? $row[array_keys($row)[12]] ?? '') ?></td>
                    </tr>
                    
                    <!-- Address Row if available -->
                    <?php if (!empty($row['Address']) || !empty($row[array_keys($row)[5]])): ?>
                        <tr>
                            <td colspan="12">
                                <strong>Address:</strong> <?= esc($row['Address'] ?? $row[array_keys($row)[5]] ?? '') ?>
                            </td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if ($data['totalPages'] > 1): ?>
        <nav aria-label="Page navigation">
            <ul class="pagination justify-content-center">
                <!-- Previous Button -->
                <li class="page-item <?= $data['page'] <= 1 ? 'disabled' : '' ?>">
                    <a class="page-link pagination-link" href="#" 
                       data-page="<?= max(1, $data['page'] - 1) ?>" 
                       data-type="<?= $type ?>">Previous</a>
                </li>
                
                <!-- Page Numbers -->
                <?php 
                $startPage = max(1, $data['page'] - 2);
                $endPage = min($data['totalPages'], $data['page'] + 2);
                
                for ($i = $startPage; $i <= $endPage; $i++): 
                ?>
                    <li class="page-item <?= $i == $data['page'] ? 'active' : '' ?>">
                        <a class="page-link pagination-link" href="#" 
                           data-page="<?= $i ?>" 
                           data-type="<?= $type ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>
                
                <!-- Next Button -->
                <li class="page-item <?= $data['page'] >= $data['totalPages'] ? 'disabled' : '' ?>">
                    <a class="page-link pagination-link" href="#" 
                       data-page="<?= min($data['totalPages'], $data['page'] + 1) ?>" 
                       data-type="<?= $type ?>">Next</a>
                </li>
            </ul>
        </nav>
        
        <!-- Page Info -->
        <div class="text-center mt-2">
            <small class="text-muted">
                Showing <?= (($data['page'] - 1) * $data['perPage']) + 1 ?> to 
                <?= min($data['page'] * $data['perPage'], $data['total']) ?> of 
                <?= $data['total'] ?> entries
            </small>
        </div>
    <?php endif; ?>

<?php else: ?>
    <div class="text-center py-4">
        <i class="bi bi-inbox display-4 text-muted"></i>
        <p class="mt-3 text-muted">No records found</p>
    </div>
<?php endif; ?>