<?php
session_start();
include_once 'dbconnect.php';
$clients = getClientsData($conn);

if (isset($_POST["submit"])) {
    $client = isset($_POST['client']) ? $_POST['client'] : '';
    $file_text = isset($_POST['file_text']) ? $_POST['file_text'] : '';
    
    $file_uploaded = '';
    if (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) {
        // get details of the uploaded file
        $fileTmpPath = $_FILES['file']['tmp_name'];
        $fileName = $_FILES['file']['name'];
        $fileSize = $_FILES['file']['size'];
        $fileType = $_FILES['file']['type'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));

        $newFileName = md5(time() . $fileName) . '.' . $fileExtension;
        $allowedfileExtensions = array('pdf', 'csv', 'doc');
        if (in_array($fileExtension, $allowedfileExtensions)) {
            $uploadFileDir = './uploads/client-files/';
            $dest_path = $uploadFileDir . $newFileName;
            if (move_uploaded_file($fileTmpPath, $dest_path)) {
                $file_uploaded = $newFileName;
                $message = 'File is successfully uploaded.';
            } else {
                $message = 'There was some error moving the file to upload directory. Please make sure the upload directory is writable by web server.';
            }
        }
    }
    
    $sql = "INSERT INTO `client_files` (`client_id`, `file_text`, `file_uploaded`, `created_at`, `updated_at`)
        VALUES ($client, '$file_text', '$file_uploaded', now(), NULL);";
        $conn->query($sql);
        $status = 'success';
}

?>
<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="">
        <meta name="author" content="">
        <title>Dashboard</title>
        <!-- Bootstrap core CSS-->
        <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
        <!-- Custom fonts for this template-->
        <link href="vendor/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">
        <!-- Custom styles for this template-->
        <link href="css/sb-admin.css" rel="stylesheet">
    </head>

    <body class="fixed-nav sticky-footer bg-dark" id="page-top">
        <!-- Navigation-->
        <?php include 'nav.php'; ?>
        <!-- Navigation-->
        <div class="content-wrapper">
            <div class="container-fluid">
                <!-- Breadcrumbs-->
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="dashboard.php">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active">Upload Client File</li>
                </ol>
                <div class="row">
                    <div class="col-12">
                        <h1>Upload File</h1>
                    </div>
                </div>
                <div class="row">
                    <div class="col-6">
                        <?php
                        if (isset($status) && $status == 'success') {
                            echo '<div class="alert alert-success">File successfully uploaded.</div>';
                        }

                        ?>
                        <form enctype="multipart/form-data" method="post" action="client-downloads.php" role="form">
                            <div class="form-group">
                                <select class="form-control" name="client">
                                    <option value="0">Select client</option>
                                    <?php
                                    if (!empty($clients)) :
                                        foreach ($clients as $key => $client) :

                                            ?>
                                            <option value="<?php echo $client['id'] ?>"><?php echo $client['name'] ?></option>
                                            <?php
                                        endforeach;
                                    endif;

                                    ?>
                                </select>
                            </div>    
                            <div class="form-group">
                                <label for="file_text">Title</label>
                                <input type="text" name="file_text" id="file_text" class="form-control" />
                            </div>
                            <div class="form-group">
                                <label for="exampleInputFile">File Upload</label>
                                <input type="file" name="file" id="file" class="form-control" />
                                <p class="help-block">Only pdf,csv.doc File allowed.</p>
                            </div>
                            <button type="submit" class="btn btn-default" name="submit" value="submit">Upload</button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /.container-fluid-->
            <!-- /.content-wrapper-->
            <footer class="sticky-footer">
                <div class="container">
                    <div class="text-center">
                        <small>Copyright © Your Website 2018</small>
                    </div>
                </div>
            </footer>
            <!-- Scroll to Top Button-->
            <a class="scroll-to-top rounded" href="#page-top">
                <i class="fa fa-angle-up"></i>
            </a>
            <!-- Logout Modal-->
            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                            <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                        <div class="modal-footer">
                            <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                            <a class="btn btn-primary" href="login.php">Logout</a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Bootstrap core JavaScript-->
            <script src="vendor/jquery/jquery.min.js"></script>
            <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
            <!-- Core plugin JavaScript-->
            <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
            <!-- Custom scripts for all pages-->
            <script src="js/sb-admin.min.js"></script>
        </div>
    </body>

</html>