<?php
session_start();
require_once 'dbconnect.php';

if (isset($_GET["action"]) && $_GET["action"] == 'download') {
    $client_id = isset($_GET['client_id']) ? $_GET['client_id'] : '';
    $res = "SELECT * FROM `clients_folio` WHERE `id` = $client_id;";
    $result = $conn->query($res);

    $headers = array();
    while ($property = mysqli_fetch_field($result)) {
        $headers[] = $property->name;
    }
    $fp = fopen('php://output', 'w');
    if ($fp && $result) {
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="folio-download.csv"');
        header('Pragma: no-cache');
        header('Expires: 0');
        fputcsv($fp, $headers);
        while ($row = $result->fetch_array(MYSQLI_NUM)) {
            fputcsv($fp, array_values($row));
        }
        die;
    }
}

if (isset($_GET['pageno'])) {
    $pageno = $_GET['pageno'];
} else {
    $pageno = 1;
}
$no_of_records_per_page = 20;
$offset = ($pageno - 1) * $no_of_records_per_page;
$client_id = $_SESSION['user_session']['id'];
$res = "SELECT COUNT(*) AS total_rows FROM clients_folio WHERE clients_folio.client_id = $client_id";
$result = $conn->query($res);
$row = mysqli_fetch_assoc($result);
$total_pages = ceil($row['total_rows'] / $no_of_records_per_page);

$clients_folio = getFolioByClient($conn, $client_id, $offset, $no_of_records_per_page);

?>
<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="">
        <meta name="author" content="">
        <title>Client Dashboard</title>
        <!-- Bootstrap core CSS-->
        <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
        <!-- Custom fonts for this template-->
        <link href="vendor/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">
        <!-- Custom styles for this template-->
        <link href="css/sb-admin.css" rel="stylesheet">
    </head>

    <body class="fixed-nav sticky-footer bg-dark" id="page-top">
        <!-- Navigation-->
        <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top" id="mainNav">
            <a class="navbar-brand" href="client-dashboard.php">Start Dashboard</a>
            <button class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse" data-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarResponsive">
                <ul class="navbar-nav navbar-sidenav" id="exampleAccordion">
                    <li class="nav-item" data-toggle="tooltip" data-placement="right" title="Dashboard">
                        <a class="nav-link" href="client-dashboard.php">
                            <i class="fa fa-fw fa-dashboard"></i>
                            <span class="nav-link-text">Dashboard</span>
                        </a>
                    </li>
                    <li class="nav-item" data-toggle="tooltip" data-placement="right" title="Tables">
                        <a class="nav-link" href="client-search-folio.php">
                            <i class="fa fa-fw fa-table"></i>
                            <span class="nav-link-text">Search By Folio</span>
                        </a>
                    </li>
                    <li class="nav-item" data-toggle="tooltip" data-placement="right" title="Tables">
                        <a class="nav-link" href="client-folio-download.php">
                            <i class="fa fa-fw fa-table"></i>
                            <span class="nav-link-text">Download Folio</span>
                        </a>
                    </li>
                    <li class="nav-item" data-toggle="tooltip" data-placement="right" title="Tables">
                        <a class="nav-link" href="download-file.php">
                            <i class="fa fa-fw fa-table"></i>
                            <span class="nav-link-text">Download file</span>
                        </a>
                    </li>
                </ul>
                <ul class="navbar-nav sidenav-toggler">
                    <li class="nav-item">
                        <a class="nav-link text-center" id="sidenavToggler">
                            <i class="fa fa-fw fa-angle-left"></i>
                        </a>
                    </li>
                </ul>
                <article>
                    <h2><i class="fa fa-leaf"></i> 
                        <span style="text-decoration:none; font-size:20px; color:#fff;">Welcome 
                            <?php
                            echo isset($_SESSION['user_session']['name']) ? $_SESSION['user_session']['name'] : '';

                            ?>  
                        </span>
                    </h2>
                </article>
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="modal" data-target="#exampleModal">
                            <i class="fa fa-fw fa-sign-out"></i>Logout
                        </a>
                    </li>
                </ul>
            </div>
        </nav>
        <div class="content-wrapper">
            <div class="container-fluid">
                <!-- Breadcrumbs-->
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="client-dashboard.php">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active">Download Folio</li>
                </ol>
                <div class="row">
                    <div class="col-12">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Client name</th>
                                    <th scope="col">Folio No.</th>
                                    <th scope="col">Holder name</th>
                                    <th scope="col">Email</th>
                                    <!--<th scope="col">Mobile</th>-->
                                    <th scope="col">Uploaded At</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if (!empty($clients_folio)) :
                                    $i = 1;
                                    foreach ($clients_folio as $client_folio) :

                                        ?>
                                        <tr>
                                            <th scope="row"><?php echo $i; ?></th>
                                            <td><?php echo $client_folio['name']; ?></td>
                                            <td><?php echo $client_folio['folio_no']; ?></td>
                                            <td><?php echo $client_folio['holder_name']; ?></td>
                                            <td><?php echo $client_folio['email']; ?></td>
                                            <!--<td><?php // echo ($client_folio['mobile_no'] != '') ? $client_folio['mobile_no'] : 'N\A';          ?></td>-->
                                            <td><?php echo prettyDate($client_folio['created_at']); ?></td>
                                            <td>
                                                <a href="client-folio-download.php?action=download&client_id=<?php echo $client_folio['id']; ?>" class="btn btn-primary">Download</a>
                                            </td>
                                        </tr>
                                        <?php
                                        $i++;
                                    endforeach;
                                else:
                                    echo '<tr><td class="text-center" colspan="7">No Client Found.</td></tr>';
                                endif;

                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.container-fluid-->
        <!-- /.content-wrapper-->
        <footer class="sticky-footer">
            <div class="container">
                <div class="text-center">
                    <small>Copyright © Your Website 2019</small>
                </div>
            </div>
        </footer>
        <!-- Scroll to Top Button-->
        <a class="scroll-to-top rounded" href="#page-top">
            <i class="fa fa-angle-up"></i>
        </a>
        <!-- Logout Modal-->
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                        <a class="btn btn-primary" href="login.php">Logout</a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Bootstrap core JavaScript-->
        <script src="vendor/jquery/jquery.min.js"></script>
        <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
        <!-- Core plugin JavaScript-->
        <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
        <!-- Custom scripts for all pages-->
        <script src="js/sb-admin.min.js"></script>
    </div>
</body>

</html>
