<?php
ob_start();
session_start();
include_once 'dbconnect.php';

if (isset($_GET["action"]) && $_GET["action"] == 'delete') {
    $id = isset($_GET['id']) ? $_GET['id'] : '';
    $sql = "DELETE FROM `companies_list` WHERE `com_id` = $id;";
    $conn->query($sql);
    $status = 'success';
}

if (isset($_GET['pageno'])) {
    $pageno = $_GET['pageno'];
} else {
    $pageno = 1;
}
$no_of_records_per_page = 20;
$offset = ($pageno - 1) * $no_of_records_per_page;

$total_rows = getTotalRecords($conn, 'companies_list');
$total_pages = ceil($total_rows / $no_of_records_per_page);

$clients_files = getCompaniesData($conn, $offset, $no_of_records_per_page);

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <title>Dashboard</title>
    <!-- Bootstrap core CSS-->
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom fonts for this template-->
    <link href="vendor/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">
    <!-- Custom styles for this template-->
    <link href="css/sb-admin.css" rel="stylesheet">
</head>

<body class="fixed-nav sticky-footer bg-dark" id="page-top">
    <!-- Navigation-->
    <?php require_once 'nav.php'; ?>
    <!-- Navigation End -->
    <div class="content-wrapper">

        <div class="container-fluid">
            <!-- Breadcrumbs-->
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="dashboard.php">Dashboard</a>
                </li>
                <li class="breadcrumb-item active">Company</li>
            </ol>
            <div class="row">
                <div class="col-12">
                    <?php
                    if (isset($status) && $status == 'success') {
                        echo '<div class="alert alert-success">Client has been deleted successfully.</div>';
                    }

                    ?>
                    <h3>Manage Company Folio</h3>Total Rows: <?php echo $total_rows; ?>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Company name</th>
                                <th scope="col">Created At</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if (!empty($clients_files)) :
                                $i = 1;
                                foreach ($clients_files as $clients_file) :
                            ?>
                                    <tr>
                                        <th scope="row"><?php echo $i; ?></th>
                                        <td><?php echo $clients_file['com_name']; ?></td>
                                        <td><?php echo prettyDate($clients_file['com_created_at']); ?></td>
                                        <td>
                                            <a href="add_folio_company.php?action=edit&id=<?php echo $clients_file['com_id']; ?>" class="btn btn-primary">Edit</a>

                                            <a href="clients_folios_list.php?action=delete&id=<?php echo $clients_file['com_id']; ?>" class="btn btn-danger">Delete</a>
                                        </td>
                                    </tr>
                            <?php
                                    $i++;
                                endforeach;
                            else :
                                echo '<tr><td class="text-center" colspan="7">No Client Found.</td></tr>';
                            endif;

                            ?>
                        </tbody>
                    </table>
                    <?php if (count($clients_files) > 0) : ?>
                        <nav aria-label="Page navigation example">
                            <ul class="pagination">
                                <li class="page-item"><a class="page-link" href="?pageno=1">First</a></li>
                                <li class="page-item <?php echo ($pageno <= 1) ? 'disabled' : ''; ?>">
                                    <a class="page-link" href="<?php echo ($pageno <= 1) ? '#' : "?pageno=" . ($pageno - 1); ?>">Prev</a>
                                </li>
                                <li class="page-item <?php echo ($pageno >= $total_pages) ? 'disabled' : ''; ?>">
                                    <a class="page-link" href="<?php echo ($pageno >= $total_pages) ? '#' : "?pageno=" . ($pageno + 1); ?>">Next</a>
                                </li>
                                <li class="page-item"><a class="page-link" href="?pageno=<?php echo $total_pages; ?>">Last</a></li>
                            </ul>
                        </nav>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- /.container-fluid-->
        <!-- /.content-wrapper-->
        <footer class="sticky-footer">
            <div class="container">
                <div class="text-center">
                    <small>Copyright © satellitecorporate.com <?php echo date('Y'); ?></small>
                </div>
            </div>
        </footer>
        <!-- Scroll to Top Button-->
        <a class="scroll-to-top rounded" href="#page-top">
            <i class="fa fa-angle-up"></i>
        </a>
        <!-- Logout Modal-->
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                        <a class="btn btn-primary" href="login.php">Logout</a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Bootstrap core JavaScript-->
        <script src="vendor/jquery/jquery.min.js"></script>
        <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
        <!-- Core plugin JavaScript-->
        <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
        <!-- Custom scripts for all pages-->
        <script src="js/sb-admin.min.js"></script>
    </div>
</body>

</html>