<?php
// define('SITE_URL', 'http://localhost/satelite_m/');

define('SITE_URL', "http://localhost/satelite_m/");
define('ADMIN_URL', "http://localhost/satelite_m/adminpanel/");
// define('SITE_URL', 'http://satellitecorporate.com');
define('CLIENT_FILE_PATH', '/adminpanel/uploads/client-files/');
define('CLIENT_IMAGE_PATH', '/adminpanel/uploads/client-images/');
define('INVESTOR_IMAGE_PATH', '/adminpanel/uploads/investorgrievance-files/');

/**
 * Function to pretty print
 * @param array/string $val
 */
function pr($val)
{
  echo '<pre>';
  print_r($val);
  echo '</pre>';
}

function prettyDate($date)
{
  return date('F, j Y', strtotime($date));
}

/**
 * Function to get companies details
 * @param object $conn database object
 */
function getApplicants($conn)
{
  echo $res = 'SELECT c.company_name,a.id,a.application_no,a.pan_no,a.applicant_name,a.ipo_closing_date,a.shares_applied,a.shared_allotted '
    . 'FROM `applicants` AS a LEFT JOIN company AS c ON a.company = c.id ORDER BY a.`id` DESC';
  $result = $conn->query($res);
  $companies = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $companies[] = $row;
    }
  }

  return $companies;
}

function getCompaniesOnly($conn)
{
  $res = 'SELECT c.id, c.company_name, c.created_at, (SELECT COUNT(id) FROM applicants WHERE applicants.company = c.id) AS applicants_count FROM `company` AS c ORDER BY c.`id` DESC';
  $result = $conn->query($res);
  $companies = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $companies[] = $row;
    }
  }

  return $companies;
}

function getCompany($conn, $id = 0)
{
  if ($id != '' && $id > 0) {
    $res = 'SELECT c.id, c.company_name, c.created_at FROM `company` AS c WHERE c.id = ' . $id;
    $result = $conn->query($res);
    $company = [];
    if ($result->num_rows > 0) {
      while ($row = mysqli_fetch_assoc($result)) {
        $company = $row;
      }
    }
    return $company;
  }
}

function getApplicantDetailsByApplication($conn, $application_no = null, $company)
{
  $res = 'SELECT * FROM `applicants` WHERE company=' . $company . ' AND application_no = "' . $application_no . '"';
  $result = $conn->query($res);
  $application_details = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $application_details = $row;
    }
  }

  return $application_details;
}

function getApplicantDetailsByPan($conn, $pan_no = null, $company)
{
  $res = 'SELECT * FROM `applicants` WHERE company=' . $company . ' AND pan_no = "' . $pan_no . '"';
  $result = $conn->query($res);
  $application_details = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $application_details = $row;
    }
  }

  return $application_details;
}

function getClientsData($conn)
{
  $res = 'SELECT * FROM clients ORDER BY `id` DESC';
  $result = $conn->query($res);
  $clients = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $clients[] = $row;
    }
  }

  return $clients;
}


function getCompaniesData($conn)
{
  $res = 'SELECT * FROM companies_list ORDER BY `com_id` DESC';
  $result = $conn->query($res);
  $clients = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $clients[] = $row;
    }
  }

  return $clients;
}

function getCompaniesDetails($conn, $id)
{
  $res = 'SELECT * FROM companies_list Where `com_id` = ' . $id;
  $result = $conn->query($res);
  $clients = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $clients[] = $row;
    }
  }

  return $clients;
}

function getClientsDetails($conn, $id, $folio)
{
  $res = "SELECT *,(SELECT com_name FROM companies_list WHERE com_id = ccf_company_id) as company_name  FROM company_clients_folio Where `ccf_company_id` = " . $id . " AND ccf_folio_no LIKE '" . $folio . "'";
  $result = $conn->query($res);
  $clients = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $clients[] = $row;
    }
  }

  return $clients;
}
function getClientDetails($conn, $id = 0)
{
  if ($id != '' && $id > 0) {
    $res = 'SELECT * FROM `clients` WHERE id = ' . $id;
    $result = $conn->query($res);
    $client = [];
    if ($result->num_rows > 0) {
      while ($row = mysqli_fetch_assoc($result)) {
        $client = $row;
      }
    }
    return $client;
  }
}

function getFolioUploadLists($conn, $offset, $no_of_records_per_page)
{
  $res = "SELECT clients_folio.*,clients.name "
    . "FROM `clients_folio` "
    . "LEFT JOIN clients ON clients_folio.client_id = clients.id "
    . "ORDER BY clients_folio.id ASC LIMIT $offset, $no_of_records_per_page";
  $result = $conn->query($res);
  $client_folio = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_folio[] = $row;
    }
  }
  return $client_folio;
}

function getFolioByClient($conn, $client_id, $offset, $no_of_records_per_page)
{
  $res = "SELECT clients_folio.*,clients.name "
    . "FROM `clients_folio` "
    . "LEFT JOIN clients ON clients_folio.client_id = clients.id "
    . "WHERE clients_folio.client_id = $client_id ORDER BY clients_folio.id ASC LIMIT $offset, $no_of_records_per_page";
  $result = $conn->query($res);
  $client_folio = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_folio[] = $row;
    }
  }
  return $client_folio;
}

function getTotalRecords($conn, $table_name)
{
  $res = "SELECT COUNT(*) AS total_rows FROM $table_name";
  $result = $conn->query($res);
  $row = mysqli_fetch_assoc($result);
  return $row['total_rows'];
}

function getClientFileList($conn, $offset = 0, $no_of_records_per_page = 20)
{
  $res = "SELECT client_files.*,clients.name FROM `client_files` "
    . "LEFT JOIN clients ON client_files.client_id = clients.id "
    . "ORDER BY id ASC LIMIT $offset, $no_of_records_per_page";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files[] = $row;
    }
  }
  return $client_files;
}


function getClientFoliosList($conn, $offset = 0, $no_of_records_per_page = 20)
{
  $res = "SELECT *,(SELECT com_name FROM companies_list WHERE com_id = ccf_company_id) as company_name FROM `company_clients_folio` ORDER BY ccf_id ASC LIMIT $offset, $no_of_records_per_page";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files[] = $row;
    }
  }
  return $client_files;
}

function getClientFile($conn, $client_id, $offset = 0, $no_of_records_per_page = 20)
{
  $res = "SELECT * FROM `client_files` "
    . "WHERE client_id = $client_id ORDER BY id ASC LIMIT $offset, $no_of_records_per_page";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files[] = $row;
    }
  }
  return $client_files;
}

function getCompanyFileList($conn, $offset = 0, $no_of_records_per_page = 20)
{
  $res = "SELECT company_files.* FROM `company_files` ORDER BY id ASC LIMIT $offset, $no_of_records_per_page";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files[] = $row;
    }
  }
  return $client_files;
}

function getCompanyFile($conn, $company_id)
{
  $res = "SELECT * FROM `company_files` WHERE id = $company_id ORDER BY id ASC LIMIT 1";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {

    $client_files = mysqli_fetch_assoc($result);
  }
  return $client_files;
}

function getFilesCompany($conn)
{
  $res = "SELECT * FROM `company_files` ORDER BY id ASC";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files[] = $row;
    }
  }
  return $client_files;
}

// Investor Grievance

function getFilesInvestorGrievance($conn, $offset = 0, $no_of_records_per_page = 20)
{
  $res = "SELECT investor_grievance_files.* FROM `investor_grievance_files` ORDER BY id ASC LIMIT $offset, $no_of_records_per_page";
  $result = $conn->query($res);
  $investor_files = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $investor_files[] = $row;
    }
  }
  return $investor_files;
}

function getInvestorFile($conn, $company_id)
{
  $res = "SELECT * FROM `investor_grievance_files` WHERE id = $company_id ORDER BY id ASC LIMIT 1";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {

    $client_files = mysqli_fetch_assoc($result);
  }
  return $client_files;
}

function getInvestorFiles($conn)
{
  $res = "SELECT * FROM `investor_grievance_files` ORDER BY id ASC";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files[] = $row;
    }
  }
  return $client_files;
}

function getMonthInvestorFiles($conn, $month)
{
  $res = "SELECT * FROM `investor_grievance_files` WHERE MONTH(date) = '$month' ORDER BY id ASC";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files[] = $row;
    }
  }
  return $client_files;
}

function getCompanies($conn)
{
  $res = "SELECT * FROM `companies` ORDER BY id ASC";
  $result = $conn->query($res);
  $companies = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $companies[] = $row;
    }
  }
  return $companies;
}

function getFolioList($conn)
{
  $res = "SELECT * FROM `folio_details`";
  $result = $conn->query($res);
  $client_files = "";
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files = $row;
    }
  }
  return $client_files;
}

function getFolioDetails($conn, $folio_no, $company_name)
{
  $res = "SELECT * FROM `folio_details` WHERE company = '$company_name' AND folio_no = '$folio_no'";
  $result = $conn->query($res);
  $client_files = "";
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files = $row;
    }
  }
  return $client_files;
}

function getOnlineQueries($conn, $id)
{
  $res = "SELECT * FROM `online_queries` WHERE id = '$id'";
  $result = $conn->query($res);
  $client_files = "";
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files = $row;
    }
  }
  return $client_files;
}
function getOnlineQueriesList($conn)
{
  $res = "SELECT * FROM `online_queries` ORDER BY id ASC";
  $result = $conn->query($res);
  $client_files = [];
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files[] = $row;
    }
  }
  return $client_files;
}

function getOnlineQueriesByTrackingno($conn, $tracking_id)
{
  $res = "SELECT * FROM `online_queries` WHERE tracking_id = '$tracking_id'";
  $result = $conn->query($res);
  $client_files = "";
  if ($result->num_rows > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $client_files = $row;
    }
  }
  return $client_files;
}

function uploadFile(array $name, string $dir, array $allowed_files)
{
  if (isset($name) && $name['error'] === UPLOAD_ERR_OK) {
    // get details of the uploaded file
    $fileTmpPath = $name['tmp_name'];
    $fileName = $name['name'];
    $fileSize = $name['size'];
    $fileType = $name['type'];
    $fileNameCmps = explode(".", $fileName);
    $fileExtension = strtolower(end($fileNameCmps));

    $newFileName = md5(time() . $fileName) . '.' . $fileExtension;
    $allowedfileExtensions = $allowed_files;
    if (in_array($fileExtension, $allowedfileExtensions)) {
      $uploadFileDir = getcwd() . $dir;
      $dest_path = $uploadFileDir . DIRECTORY_SEPARATOR . $newFileName;
      if (move_uploaded_file($fileTmpPath, $dest_path)) {
        return $newFileName;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }
  return false;
}
