<?php
require_once 'adminpanel/dbconnect.php';
$companies = getCompaniesOnly($conn);

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>Satellite Corporate</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="description" content="" />
        <meta name="author" content="" />

        <!-- css -->
        <link href="https://fonts.googleapis.com/css?family=Noto+Serif:400,400italic,700|Open+Sans:300,400,600,700" rel="stylesheet">
        <link href="css/bootstrap.css" rel="stylesheet" />
        <link href="css/bootstrap-responsive.css" rel="stylesheet" />
        <link href="css/fancybox/jquery.fancybox.css" rel="stylesheet">
        <link href="css/jcarousel.css" rel="stylesheet" />
        <link href="css/flexslider.css" rel="stylesheet" />
        <link href="css/style.css" rel="stylesheet" />
        <!-- Theme skin -->
        <link href="skins/default.css" rel="stylesheet" />
        <!-- Fav and touch icons -->
        <link rel="apple-touch-icon-precomposed" sizes="144x144" href="ico/apple-touch-icon-144-precomposed.png" />
        <link rel="apple-touch-icon-precomposed" sizes="114x114" href="ico/apple-touch-icon-114-precomposed.png" />
        <link rel="apple-touch-icon-precomposed" sizes="72x72" href="ico/apple-touch-icon-72-precomposed.png" />
        <link rel="apple-touch-icon-precomposed" href="ico/apple-touch-icon-57-precomposed.png" />
        <link rel="shortcut icon" href="ico/favicon.png" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    </head>

    <body>
        <div id="wrapper">
            <!-- toggle top area -->
            <div class="hidden-top">
                <div class="hidden-top-inner container">
                    <div class="row">
                        <div class="span12">
                            <ul>
                                <li><strong>We are available for any custom works this month</strong></li>
                                <li>Main office: B-302, SONY APARTMENT,JARIMARI, SAKINAKA, MUMBAI-400072</li>
                                <li>Call us <i class="icon-phone"></i> +91-22-28520461/462</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end toggle top area -->
            <!-- start header -->
            <?php include 'header.php'; ?>
            <!-- end header -->
            <section class="callaction1">
                <div class="container">
                    <div class="span12">
                        <div class="big-cta">
                            <div class="cta-text">
                                <h3>SATELLITE CORPORATE SERVICES PVT LTD </h3>
                            </div>
                            <div class="cta floatright">
                                <a class="btn btn-large btn-theme btn-rounded" href="#">Download Our Profile</a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section style="bottom:20px;" id="content">
                <div  class="jumbotron vertical-center">
                    <div style="left:50px; width:300px; border-style: double;"   class="container">
                        <h3 style="text-align:center;">IPO STATUS </h3>
                        <form  class="form-horizontal">
                            <div class="control-group">
                                <select id="company" name="company" class="form-control">
                                    <option value="">Select Company</option>
                                    <?php
                                    if (!empty($companies)) :
                                        foreach ($companies as $key => $company) :

                                            ?>
                                            <option value="<?php echo $company['id'] ?>"><?php echo $company['company_name'] ?></option>
                                            <?php
                                        endforeach;
                                    endif;

                                    ?>
                                </select>
                            </div>
                            <div class="control-group">
                                <label class="checkbox inline">
                                    <input type="radio" name="search_criteria" id="application_no" value="application_no"> Application No.
                                </label>
                                <label class="checkbox inline">
                                    <input type="radio" name="search_criteria" id="pan_no" value="pan_no"> Pan No.
                                </label>
                            </div>

                            <div class="control-group show_application_no" style="display: none;">
                                <div class="form-group">
                                    <label for="input_application_no">Application No. </label>
                                    <input type="text" class="form-control input_search_no" id="input_application_no" name="input_application_no" />
                                </div>
                            </div>
                            <div class="control-group show_pan_no" style="display: none;">
                                <label for="input_pan_no">Pan No. </label>
                                <input type="text" class="form-control input_search_no" id="input_pan_no" name="input_pan_no" />
                            </div>
                            <button type="button" id="check_applicant" class="btn btn-primary">Check</button>
                        </form>
                        
                        
                        <div   class="applicant_details" style="display: none;">
                            <table class="table">
                                <tbody>
                                    <tr><th>Application Number</th><td class="data_application_no"></td></tr>
                                    <tr><th>Applicant Name</th><td class="data_applicant_name"></td></tr>
                                    <tr><th>IPO Closing Date</th><td class="data_ipo_closing_date"></td></tr>
                                    <tr><th>PAN</th><td class="data_pan"></td></tr>
                                    <tr><th>Shares Applied</th><td class="data_shares_applied"></td></tr>
                                    <tr><th>Shares Alloted</th><td class="data_shares_alloted"></td></tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </section>
            <footer>
                <div class="container">
                    <div class="row">
                        <div class="span6">
                            <div class="copyright">
                                <p>
                                    <span>&copy; SATELLITE CORPORATE SERVICES PVT LTD - All right reserved.</span>
                                </p>
                                <div class="credits">

                                    Designed by <a href="#">Magic Web Services</a>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <ul class="social-network">
                                <li><a href="#" data-placement="bottom" title="Facebook"><i class="icon-facebook icon-square"></i></a></li>
                                <li><a href="#" data-placement="bottom" title="Twitter"><i class="icon-twitter icon-square"></i></a></li>
                                <li><a href="#" data-placement="bottom" title="Linkedin"><i class="icon-linkedin icon-square"></i></a></li>
                                <li><a href="#" data-placement="bottom" title="Pinterest"><i class="icon-pinterest icon-square"></i></a></li>
                                <li><a href="#" data-placement="bottom" title="Google plus"><i class="icon-google-plus icon-square"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
        <a href="#" class="scrollup"><i class="icon-chevron-up icon-square icon-32 active"></i></a>
        <!-- javascript
          ================================================== -->
        <!-- Placed at the end of the document so the pages load faster -->
        <script src="js/jquery.js"></script>
        <script src="js/jquery.easing.1.3.js"></script>
        <script src="js/bootstrap.js"></script>
        <script src="js/jcarousel/jquery.jcarousel.min.js"></script>
        <script src="js/jquery.fancybox.pack.js"></script>
        <script src="js/jquery.fancybox-media.js"></script>
        <script src="js/google-code-prettify/prettify.js"></script>
        <script src="js/portfolio/jquery.quicksand.js"></script>
        <script src="js/portfolio/setting.js"></script>
        <script src="js/jquery.flexslider.js"></script>
        <script src="js/jquery.nivo.slider.js"></script>
        <script src="js/modernizr.custom.js"></script>
        <script src="js/jquery.ba-cond.min.js"></script>
        <script src="js/jquery.slitslider.js"></script>
        <script src="js/animate.js"></script>

        <!-- Template Custom JavaScript File -->
        <script src="js/custom.js"></script>
        <script>
            $(document).ready(function () {
                $('input[name="search_criteria"]').on('click', function () {
                    var search_value = $(this).val();
                    if (search_value == 'application_no') {
                        $(".show_application_no").show();
                        $(".show_pan_no").hide();
                    } else {
                        $(".show_pan_no").show();
                        $(".show_application_no").hide();
                    }
                });

                $('#check_applicant').on('click', function () {
                    var data_search = $('input[name="search_criteria"]:checked').val();
                    var search_no = '';
                    if(data_search == 'pan_no'){
                        search_no = $('#input_pan_no').val();
                    } else {
                        search_no = $('#input_application_no').val();
                    }
                    var company = $('#company').val();
                    if (search_no != '' && data_search != '') {
                        $.ajax({
                            url: 'mainAjax.php',
                            data: {
                                'action': 'search_applicant',
                                'data_search': data_search,
                                company: company,
                                search_no: search_no
                            },
                            type: 'GET',
                            dataType: 'json',
                            beforeSend: function () {
                                //pnotifyAlert({msg: "Requesting Please Wait.", status: 'info'});
                            },
                            success: function (data) {
                                if (data.status == 'success') {
                                    var d = data.applicantDetails;
                                    $('.data_application_no').text(d.application_no);
                                    $('.data_applicant_name').text(d.applicant_name);
                                    $('.data_ipo_closing_date').text(d.ipo_closing_date);
                                    $('.data_pan').text(d.pan_no);
                                    $('.data_shares_applied').text(d.shares_applied);
                                    $('.data_shares_alloted').text(d.shared_allotted);
                                    
                                    $('.applicant_details').show();
                                    
                                    //pnotifyAlert({msg: data.bs_response, status: 'success'});
                                } else {
                                    //pnotifyAlert({msg: data.bs_response, status: 'error'});
                                }
                            },
                            error: function (request, status, error) {
                                //alert('Unable to request server!');
                                //pnotifyAlert({msg: "Unable To Process Your Request.", status: 'error'});
                            }
                        });
                    }
                });
            });
        </script>
    </body>
</html>
