<?php
require_once '../adminpanel/dbconnect.php';
session_start();

if (!empty($_POST["send"])) {
  $company = $_POST['company'] ?? "";
  $folio_no = $_POST['folio_no'] ?? "";
  $email = $_POST['email'] ?? "";
  $holding_type = $_POST['holding_type'] ?? "";
  $folio_details = [];
  if (!empty($folio_no)) {
    $folio_details = getFolioDetails($conn, $folio_no, $company);
  }
  $captcha = $_POST["captcha"];

  $captchaUser = filter_var($_POST["captcha"], FILTER_SANITIZE_STRING);

  if (empty($captcha)) {
    $captchaError = array(
        "status" => "alert-danger",
        "message" => "Please enter the captcha."
    );
  } else if ($_SESSION['CAPTCHA_CODE'] == $captchaUser) {
    $captchaError = array(
        "status" => "alert-success",
        "message" => "Your form has been submitted successfuly."
    );
  } else {
    $captchaError = array(
        "status" => "alert-danger",
        "message" => "Captcha is invalid."
    );
  }
}
?>
<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>Satellite Corporate - Query - Service Request</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="description" content="" />
        <meta name="author" content="" />

        <!-- css -->
        <link href="https://fonts.googleapis.com/css?family=Noto+Serif:400,400italic,700|Open+Sans:300,400,600,700" rel="stylesheet">
        <link href="../css/bootstrap.css" rel="stylesheet" />
        <link href="../css/bootstrap-responsive.css" rel="stylesheet" />
        <link href="../css/fancybox/jquery.fancybox.css" rel="stylesheet">
        <link href="../css/jcarousel.css" rel="stylesheet" />
        <link href="../css/flexslider.css" rel="stylesheet" />
        <link href="../css/style.css" rel="stylesheet" />
        <!-- Theme skin -->
        <link href="../skins/default.css" rel="stylesheet" />
        <!-- Fav and touch icons -->
        <link rel="apple-touch-icon-precomposed" sizes="144x144" href="ico/apple-touch-icon-144-precomposed.png" />
        <link rel="apple-touch-icon-precomposed" sizes="114x114" href="ico/apple-touch-icon-114-precomposed.png" />
        <link rel="apple-touch-icon-precomposed" sizes="72x72" href="ico/apple-touch-icon-72-precomposed.png" />
        <link rel="apple-touch-icon-precomposed" href="ico/apple-touch-icon-57-precomposed.png" />
        <link rel="shortcut icon" href="ico/favicon.png" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    </head>

    <body>
        <div id="wrapper">
            <!-- toggle top area -->
            <div class="hidden-top">
                <div class="hidden-top-inner container">
                    <div class="row">
                        <div class="span12">
                            <ul>
                                <li><strong>We are available for any custom works this month</strong></li>
                                <li>Main office: B-302, SONY APARTMENT,JARIMARI, SAKINAKA, MUMBAI-400072</li>
                                <li>Call us <i class="icon-phone"></i> +91-22-28520461/462</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end toggle top area -->
            <!-- start header -->
            <?php include '../header.php'; ?>
            <!-- end header -->
            <section class="callaction1">
                <div class="container">
                    <div class="span12">
                        <div class="big-cta">
                            <div class="cta-text">
                                <h3>Query/Service request for Physical Shares </h3>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section style="bottom:20px;" id="content">
                <div  class="jumbotron vertical-center">
                    <div class="container">
                        <div class="form-center">
                            <form id="form-1" class="track-form" action="folio-details.php" method="POST">
                                <div class="form-group col-6">
                                    <label>Company*</label>
                                    <select name="company" class="span6 form-control" required="required">
                                        <option value="">--select--</option>
                                        <?php
                                        $companies = getCompanies($conn);
                                        if (!empty($companies)) {
                                          echo '<ul>';
                                          foreach ($companies as $company) {
                                            ?>
                                            <option value="<?= $company['company_name'] ?>"><?= $company['company_name'] ?></option>
                                            <?php
                                          }
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group col-6">
                                    <label>I am holding the bonds/shares in (select the holding type)*</label>
                                    <select name="holding_type" class="span6 form-control" required="required">
                                        <option value="">--select--</option>
                                        <option value="Physical">Physical</option>
                                        <option value="NSDL">NSDL</option>
                                        <option value="CDSL">CDSL</option>
                                    </select>
                                </div>
                                <br>
                                <h5>Please enter here your physical folio details*</h5>

                                <div class="form-group col-6">
                                    <label>Folio no. (as appearing in bond/share  certificates)*</label>
                                    <input type="text" name="folio_no" class="input-block-level span6" value="" required="required" />
                                </div>

                                <div class="form-group col-6">
                                    <label>Enter Correspondence Email (where the response will be shared)*</label>
                                    <input type="email" name="email" class="input-block-level span6" value="" required="required" />
                                </div>

                                <div class="form-group col-6">
                                    <label>Enter Captcha*</label>
                                    <input type="text" class="input-block-level span6" name="captcha" id="captcha" required="required">
                                    <?php
                                    if (isset($_GET['error_captcha'])) {
                                      echo '<p class="error">' . $_GET['error_captcha'] . '</p>';
                                    }
                                    ?>
                                </div>
                                <div class="form-group col-6">
                                    <label>Captcha Code</label>
                                    <img src="scripts/captcha.php" alt="PHP Captcha">
                                </div>
                                <div class="form-group col-6">
                                    <input type="button" value="Submit" class="btn btn-primary" id="get_folio_details">
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <footer>
                <div class="container">
                    <div class="row">
                        <div class="span6">
                            <div class="copyright">
                                <p>
                                    <span>&copy; SATELLITE CORPORATE SERVICES PVT LTD - All right reserved.</span>
                                </p>
                                <div class="credits">
                                    Designed by <a href="#">Magic Web Services</a>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <ul class="social-network">
                                <li><a href="#" data-placement="bottom" title="Facebook"><i class="icon-facebook icon-square"></i></a></li>
                                <li><a href="#" data-placement="bottom" title="Twitter"><i class="icon-twitter icon-square"></i></a></li>
                                <li><a href="#" data-placement="bottom" title="Linkedin"><i class="icon-linkedin icon-square"></i></a></li>
                                <li><a href="#" data-placement="bottom" title="Pinterest"><i class="icon-pinterest icon-square"></i></a></li>
                                <li><a href="#" data-placement="bottom" title="Google plus"><i class="icon-google-plus icon-square"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
        <a href="#" class="scrollup"><i class="icon-chevron-up icon-square icon-32 active"></i></a>
        <!-- javascript
          ================================================== -->
        <!-- Placed at the end of the document so the pages load faster -->
        <script src="../js/jquery.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js" integrity="sha512-rstIgDs0xPgmG6RX1Aba4KV5cWJbAMcvRCVmglpam9SoHZiUCyQVDdH2LPlxoHtrv17XWblE/V/PP+Tr04hbtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="../js/jquery.easing.1.3.js"></script>
        <script src="../js/bootstrap.js"></script>
        <script src="../js/jcarousel/jquery.jcarousel.min.js"></script>
        <script src="../js/jquery.fancybox.pack.js"></script>
        <script src="../js/jquery.fancybox-media.js"></script>
        <script src="../js/google-code-prettify/prettify.js"></script>
        <script src="../js/portfolio/jquery.quicksand.js"></script>
        <script src="../js/portfolio/setting.js"></script>
        <script src="../js/jquery.flexslider.js"></script>
        <script src="../js/jquery.nivo.slider.js"></script>
        <script src="../js/modernizr.custom.js"></script>
        <script src="../js/jquery.ba-cond.min.js"></script>
        <script src="../js/jquery.slitslider.js"></script>
        <script src="../js/animate.js"></script>

        <!-- Template Custom JavaScript File -->
        <script src="../js/custom.js"></script>
        <script>
          $(document).ready(function () {
              $("#form-1").validate();

              $('#get_folio_details').on('click', function () {
                  $('#form-1').submit();
              });
          });
        </script>
    </body>
</html>
