<?php include 'inc/config.php'; ?>

<!DOCTYPE html>
<html lang="en-US">

<head>
    <title> Shelburne Stays </title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="slider/css/owl.carousel.min.css">
    <link rel="stylesheet" href="slider/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/4.5.6/css/ionicons.min.css">
    <link rel="stylesheet" href="slider/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Oswald:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Mulish:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="icon" href="images/BloomingInn-Logo-Color-FINAL-150x150.png" sizes="32x32">
    <link rel="icon" href="images/BloomingInn-Logo-Color-FINAL.png" sizes="192x192">
    <link rel="apple-touch-icon" href="images/BloomingInn-Logo-Color-FINAL.png">
    <meta name="msapplication-TileImage" content="images/BloomingInn-Logo-Color-FINAL.png">
    <script src="slider/js/popper.js"></script>
    <!-- <script src="slider/js/jquery.min.js"></script>
    <script src="slider/js/bootstrap.min.js"></script> -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.js"></script>
    <style>
        *,

        *::before,

        *::after {

            padding: 0;

            margin: 0;

            box-sizing: border-box;

            list-style: none;

            list-style-type: none;

            text-decoration: none;

            -webkit-font-smoothing: antialiased;

            -moz-osx-font-smoothing: grayscale;

            text-rendering: optimizeLegibility;

        }

        html {

            font-size: 100%;

            box-sizing: inherit;

            scroll-behavior: smooth;

            height: -webkit-fill-available;

        }

        body {

            font-family: "Quicksand", sans-serif;

            font-style: normal;

            font-size: clamp(1rem, 2vw, 1.125rem);

            font-weight: 400;

            line-height: 1.5;

            height: -webkit-fill-available;

            color: #000;

            background-color: #fff;

        }

        main {
            overflow: hidden;
        }

        a,
        button {

            cursor: pointer;

            border: none;

            outline: none;

            user-select: none;

            background: none;

            box-shadow: none;

            text-decoration: none;

        }



        img,
        video {

            display: block;

            max-width: 100%;

            height: auto;

            object-fit: cover;

        }

        .section {

            margin: 0 auto;

            padding: 0rem 0 0.5rem;

        }


        .container {

            max-width: 75rem;

            height: auto;

            margin: 0 auto;

            padding: 0 1.25rem;

        }

        .centered {

            text-align: center;

            vertical-align: middle;

            margin-bottom: 1rem;

        }


        .heading-xl {

            font-size: clamp(2.648rem, 6vw, 4.241rem);

            font-weight: 700;

            line-height: 1.15;

            letter-spacing: -1px;

        }



        .heading-lg {

            font-size: clamp(2.179rem, 5vw, 3.176rem);

            font-weight: 700;

            line-height: 1.15;

            letter-spacing: -1px;

        }



        .heading-md {

            font-size: clamp(1.794rem, 4vw, 2.379rem);

            font-weight: 700;

            line-height: 1.25;

            letter-spacing: -1px;

        }







        .heading-sm {

            font-size: clamp(1.476rem, 3vw, 1.782rem);

            font-weight: 600;

            line-height: 1.5;

        }



        .heading-xs {

            font-size: clamp(1.215rem, 2vw, 1.335rem);

            font-weight: 500;

            line-height: 1.5;

        }



        .paragraph {

            font-size: clamp(1rem, 2vw, 1.125rem);

            text-wrap: balance;

            color: var(--color-white-200);

        }



        .btn {

            display: inline-block;

            font-size: 1rem;

            font-weight: 500;

            line-height: 1.5;

            text-align: center;

            vertical-align: middle;

            white-space: nowrap;

            user-select: none;

            outline: none;

            border: none;

            border-radius: 0.25rem;

            text-transform: unset;

            transition: all 0.3s ease-in-out;

        }



        .btn-inline {

            display: inline-flex;

            align-items: center;

            justify-content: center;

            column-gap: 0.5rem;

        }



        .btn-darken {

            padding: 0.75rem 2rem;

            color: var(--color-white-100);

            background-color: var(--color-black-200);

            box-shadow: var(--shadow-medium);

        }



        .btn-neutral {

            padding: 0.75rem 2rem;

            color: var(--color-black-500);

            background-color: var(--color-white-100);

            box-shadow: var(--shadow-medium);

        }



        .header {

            position: fixed;

            top: 0;

            left: 0;

            z-index: 100;

            width: 100%;

            height: auto;

            margin: 0 auto;

            transition: all 0.35s ease;

        }



        .header.on-scroll {

            /* background: #fff; */

            box-shadow: var(--shadow-medium);

        }



        .navbar {

            display: flex;

            flex-direction: row;

            align-items: center;

            justify-content: flex-start;

            column-gap: 1.25rem;

            background: #09628aa8;

            width: 100%;

            height: 7.25rem;

            margin: 0 auto;

        }



        .header.on-scroll .navbar {

            background: #09628aa8;

        }



        .header.on-scroll .navbar .menu-link {

            color: #fff;

        }



        .brand {

            font-size: 1.6rem;

            font-weight: 600;

            line-height: 1.5;

            letter-spacing: -1px;

            color: var(--color-white-100);

            text-transform: uppercase;

        }







        .brand img {

            height: 100px;

            width: 100px;

        }



        .menu {

            position: fixed;

            top: -100%;

            left: 0;

            width: 100%;

            height: auto;

            padding: 4rem 0 3rem;

            overflow: hidden;

            background-color: #fff;

            box-shadow: var(--shadow-medium);

            transition: all 0.4s ease-in-out;

        }



        .menu.is-active {

            top: 0;

            width: 100%;

            height: auto;

        }



        .menu.is-active .menu-link {

            color: #000;

        }

        .menu-inner .menu-item a {
            font-family: "Arial", Sans-serif;
            font-size: 16px;
            font-weight: 400;
            line-height: 1.2em;
        }



        .menu-inner {

            display: flex;

            flex-direction: column;

            justify-content: center;

            align-items: center;

            row-gap: 1.25rem;

        }



        .menu-link {

            font-size: 18px;

            font-weight: 900;

            line-height: 1.5;

            color: #fff;

            text-transform: uppercase;

            transition: all 0.3s ease;

        }



        .menu-block {

            display: inline-block;

            font-size: 0.875rem;

            font-weight: 500;

            line-height: 1.25;

            user-select: none;

            white-space: nowrap;

            text-align: center;

            margin-left: auto;

            padding: 0.65rem 1.5rem;

            border-radius: 2px;

            text-transform: capitalize;

            color: #fff;

            background-color: hsl(198.58deg 97.41% 54.51%);

            box-shadow: var(--shadow-medium);

            transition: all 0.3s ease-in-out;

        }



        .menu-block:hover {

            background-color: #fff;

            border: 1px solid;

            border-color: hsl(198.58deg 97.41% 54.51%);

            color: hsl(198.58deg 97.41% 54.51%);

        }



        .burger {

            position: relative;

            display: block;

            cursor: pointer;

            user-select: none;

            order: -1;

            z-index: 10;

            width: 1.6rem;

            height: 1.15rem;

            border: none;

            outline: none;

            background: none;

            visibility: visible;

            transform: rotate(0deg);

            transition: 0.35s ease;

        }



        .burger-line {

            position: absolute;

            display: block;

            left: 0;

            width: 100%;

            height: 2px;

            border: none;

            outline: none;

            opacity: 1;

            border-radius: 1rem;

            transform: rotate(0deg);

            background-color: #000;

            transition: 0.25s ease-in-out;

        }



        .burger-line:nth-child(1) {

            top: 0px;

        }



        .burger-line:nth-child(2) {

            top: 0.5rem;

            width: 70%;

        }



        .burger-line:nth-child(3) {

            top: 1rem;

        }



        .burger.is-active .burger-line:nth-child(1) {

            top: 0.5rem;

            transform: rotate(135deg);

        }



        .burger.is-active .burger-line:nth-child(2) {

            opacity: 0;

            visibility: hidden;

        }



        .burger.is-active .burger-line:nth-child(3) {

            top: 0.5rem;

            transform: rotate(-135deg);

        }



        .owl-item {

            height: 600px;

            max-height: 600px;

        }



        .owl-carousel .owl-nav button.owl-next,

        .owl-carousel .owl-nav button.owl-prev,

        .owl-carousel button.owl-dot {

            background: none !important;

            color: #fff;

            padding: 0px 30px !important;

        }



        .owl-nav button {

            position: absolute;

            top: 50%;

            background-color: #000;

            color: #fff;

            margin: 0;

            transition: all 0.3s ease-in-out;

        }



        .owl-nav button.owl-prev {

            left: 0;

        }



        .owl-nav button.owl-next {

            right: 0;

        }



        .owl-dots {

            text-align: center;

            padding-top: 15px;

        }



        .owl-dots button.owl-dot {

            width: 15px;

            height: 15px;

            border-radius: 50%;

            display: inline-block;

            background: #ccc;

            margin: 0 3px;

        }



        .owl-dots button.owl-dot.active {

            background-color: #000;

        }



        .owl-dots button.owl-dot:focus {

            outline: none;

        }



        .owl-nav button {

            position: absolute;

            top: 50%;

            transform: translateY(-50%);

            background: rgba(255, 255, 255, 0.38) !important;

        }



        .owl-nav button:focus {

            outline: none;

        }



        span {

            font-size: 70px;

            position: relative;

            top: -5px;

        }



        .block {

            background: url('images/home_bg.png');

            width: 100%;

            height: 100%;

            position: relative;

            overflow: hidden;

            background-attachment: fixed;

            background-size: cover;

            font-size: 16px;

            background-color: #fff;

            margin-top: -10px;

            transition: background 0.3s, border-radius 0.3s, opacity 0.3s;

            padding-bottom: 35px;

        }



        .block h2 {

            position: relative;

            display: block;

            text-align: center;

            margin: 0;

            top: 50%;

            transform: translateY(-50%);

            font-size: 10vw;

            color: white;

            font-weight: 400;

        }



        .img-parallax {

            width: 100vmax;

            z-index: -1;

            position: absolute;

            top: 0;

            left: 50%;

            transform: translate(-50%, 0);

            pointer-events: none;

        }



        .form-container {

            /* margin: 0px 150px 0px 150px; */

            padding: 20px 20px 0px 0px;

            background-color: #1fb7ffc2;

            border-radius: 5px;

            margin-top: 25px;

            width: 100%;

            display: inline-grid;

        }



        .input-group.date {

            margin-left: 15px;

        }



        .search-bar .search-bar-button {

            width: auto;

            flex: 0 0 auto;

            padding: 0;

            margin-right: 25px;

        }



        button.btn.btn-default,
        a.btn.btn-default {
            background-color: #1FB7FF;
            color: #ffffff;
            text-shadow: none;
            border: 1px solid #ffffff;
        }

        button.btn.btn-default:hover,
        a.btn.btn-default:hover {
            background-color: #ffffff;
            color: #1FB7FF;
            border: 1px solid #1FB7FF;

        }



        .card-form-layout {

            margin-top: 35px;

            display: flex;

            flex-wrap: wrap;

            justify-content: center;

        }



        .card-layout {

            display: inline-block;

            margin: 10px;

            padding: 10px;

            height: 250px;

            width: 400px;

            border-radius: 25px;

            background: #fff;

            transition: transform .2s;

            background-size: cover !important;

            background-repeat: no-repeat !important;

        }



        .card-layout:hover {

            transform: scale(0.75);



        }



        .card-main-container {

            display: flex;

            flex-wrap: wrap;

            justify-content: center;

            align-items: center;

            justify-items: center;

        }



        .card-layout p a {

            display: flex;

            color: #fff;

            background: #09628aa8;
            /* 
            font-size: 18px;

            font-weight: 900; */

            justify-content: center;

            position: relative;

            top: 200px;

            width: 100%;
            font-family: "Mulish", Sans-serif;
            font-size: 16px;
            font-weight: 700;
            line-height: 1.2em;
            letter-spacing: 2.2px;

        }



        h2.elementor-heading-title {

            color: #0071b8;

            text-align: center;

            font-size: 50px;

            font-weight: 500;

            text-transform: capitalize;

            line-height: 1.2em;

            margin-top: 15px;

            font-family: "Quicksand", Sans-serif;
            font-style: normal;
            letter-spacing: 0px;

        }

        h3.elementor-heading-title {

            color: #0071b8;

            text-align: center;

            font-size: 1.8vw;

            font-weight: 500;

            text-transform: capitalize;

            line-height: 1.2em;

            margin-top: 15px;
            font-family: "Montserrat", Sans-serif;
            font-style: normal;
            letter-spacing: 0px;

        }



        .elementor-6300 .elementor-element.elementor-element-15cb7c4 .elementor-button {

            font-size: 18px;

            font-weight: 500;

            line-height: 1.5;

            fill: #FFFFFF;

            color: #FFFFFF;

            background-color: #0071B8;

            padding: 1% 2% 1% 2%;



        }



        .card-container-button {

            display: flex;

            align-items: center;

            justify-content: center;

            margin-bottom: 25px;

        }



        .card-container-button a {

            color: #FFFFFF;

            background-color: #0071B8;

            font-size: 22px;

            padding: 10px 15px;

        }



        .image-card {

            background-size: cover !important;

            background-repeat: no-repeat !important;

            background-position: center center !important;
            height: 350px;
            width: 100%;

        }



        .image-card-content {

            background: #09628aa8;

            position: relative;

            height: fit-content;
            top: 240px;

            width: 100%;

        }



        .image-card h3 a,

        .image-card p a {
            font-family: "Oswald", Sans-serif;
            font-weight: 600;
            line-height: 1.2em;
            display: flex;

            color: #fff;

            font-size: 28px;

            text-align: center;

            position: relative;

            justify-content: center;

        }



        .image-card p a {

            font-size: 18px;

        }



        #carousel2 .owl-item {

            height: 240px;

            max-height: 240px;

            text-align: center;

        }



        .block-body {

            padding-top: 15px;

            padding-bottom: 15px;

        }



        .services_blocks {

            padding-top: 15px;

            padding-bottom: 15px;

            margin-top: 20px;

            margin-bottom: 20px;

        }



        .services_blocks img {

            width: 100%;

        }


        .services_blocks h3 {
            padding-left: 20px;
            color: #0071B8;
            font-family: "Quicksand", Sans-serif;
            font-size: 30px;
            font-weight: 500;
            line-height: 2em;
            letter-spacing: 1.2px;
        }


        .services_blocks p {
            padding-left: 20px;
            text-align: justify;
            font-family: "Montserrat", Sans-serif;
            font-size: 1em;
            font-weight: 400;
            text-shadow: 0px 0px 0px rgba(0, 0, 0, 0.3);
        }


        .services_content_blocks {
            padding-top: 20px;
            padding-left: 20px;
            padding-right: 20px;
        }


        .main-footer {
            position: relative;
            background: #1e2129;
        }


        .main-footer:before {
            position: absolute;
            content: "";
            background: url('images/0b196391-b759-4036-8cd4-d975bdb07dc8.jpeg');
            width: 100%;
            height: 100%;
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center center;
            opacity: 0.4;
        }

        .footer-column {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .footer-content {
            position: relative;
            padding: 85px 0px 80px 0px;
        }


        .footer-content .logo-widget {
            position: relative;
            margin-top: -5px;
        }


        .footer-content .logo-widget .logo-box a {
            justify-content: center;
            align-items: center;
            display: flex;
        }


        .footer-content .logo-widget .footer-social li {
            position: relative;
            display: inline-block;
            margin-right: 9px;
        }


        .footer-content .logo-widget .footer-social li:last-child {
            margin-right: 0px;
        }


        .footer-content .logo-widget .footer-social li a {
            position: relative;
            display: inline-flex;
            vertical-align: middle;
            justify-content: center;
            width: 50px;
            align-items: center;
            font-size: 35px;
            height: 50px;
            background: #1ab6fc;
            line-height: 42px;
            color: #ffffff;
            text-align: center;
            border-radius: 50%;
        }


        .footer-content .logo-widget .footer-social li a:hover {
            color: #ffffff;
            background: #1486ff;
        }


        .footer-content .logo-widget .logo-box {
            margin-bottom: 25px;
        }


        .footer-content .logo-widget .text p {
            color: #9ea0a9;
            margin-bottom: 32px;
        }


        .footer-content .footer-title {
            font-family: "Oswald", Sans-serif;
            font-size: 2vw;
            font-weight: 600;
            line-height: 1.2em;
            position: relative;
            color: #ffffff;
            margin-bottom: 27px;
            text-align: center;
            /* font-size: 40px;
            font-weight: 700;
            font-size: 24px;
            line-height: 35px; */
        }


        .footer-content .service-widget .list li {
            display: block;
            margin-bottom: 12px;
        }


        .footer-content .service-widget .list li a {
            position: relative;
            display: inline-block;
            color: #9ea0a9;
        }


        .footer-content .service-widget .list li a:hover {
            color: #ff5e14;
        }


        .footer-content .contact-widget p {
            color: #fff;
            margin-bottom: 15px;
            font-size: 14px;
            font-family: 'Mulish', Sans-serif;
            font-weight: 400;
        }


        .footer-content .contact-widget .footer-title {
            margin-bottom: 29px;
        }

        /** footer-bottom **/

        .footer-bottom {
            position: relative;
            background: #1ab6fc;
            padding: 5px 0px 0px 0px;
        }


        .footer-bottom .copyright,
        .footer-bottom .copyright a,
        .footer-bottom .footer-nav li a {
            position: relative;
            color: #fff;
            text-align: center;
        }


        .footer-bottom .copyright a:hover,
        .footer-bottom .footer-nav li a:hover {
            color: #ff5e14;
        }


        .footer-bottom .footer-nav {
            position: relative;
            text-align: right;
        }


        .footer-bottom .footer-nav li {
            position: relative;
            display: inline-block;
            margin-left: 29px;
        }


        .footer-bottom .footer-nav li:first-child {

            margin-left: 0px;

        }


        .footer-bottom .footer-nav li:before {

            position: absolute;

            content: "";

            background: #9ea0a9;

            width: 1px;

            height: 14px;

            top: 7px;

            left: -18px;

        }



        .footer-bottom .footer-nav li:first-child:before {

            display: none;

        }


        .logo-box img {

            max-width: 150px;

        }


        .footer-widget ul.list {

            border-top: 2px solid #fff;

        }


        .footer-widget ul.list li {

            display: inline-block;

            padding: 20px 15px;

            width: 32.75%;

        }


        .footer-widget ul.list li a .icon {

            justify-content: center;

            align-items: center;

            display: flex;

            margin-bottom: 10px;

            color: #fff;

        }


        .footer-widget ul.list li a .icon i {
            font-size: 35px;
        }


        .footer-widget ul.list li a h3 {
            font-family: "Oswald", Sans-serif;

            color: #fff;

            text-align: center;

            font-weight: bolder;

        }


        .footer-widget ul.list li a p {
            color: #fff;
            text-align: center;

        }


        @media screen and (min-width: 1280px) {

            .menu-block {

                margin-left: 2rem;

            }

        }


        @media screen and (min-width: 1024px) {

            .menu-block {
                margin-left: 2rem;
            }

        }


        @media screen and (min-width: 768px) {

            .menu {
                display: contents;
                position: relative;
                top: 0;
                width: auto;
                height: auto;
                padding: 0rem;
                margin-left: auto;
                background: none;
                box-shadow: none;
            }

            .menu-inner {
                display: flex;
                flex-direction: row;
                column-gap: 3rem;
                margin: 0 auto;
            }


            .menu-link {
                text-transform: capitalize;
            }


            .menu-link:hover {
                color: hsl(198.58deg 97.41% 54.51%);
            }


            .menu-block {
                margin-left: 2rem;
            }


            .burger {
                display: none;
                visibility: hidden;
            }


            .search-bar {
                display: flex;
                margin: 0;
            }


            .search-bar .search-bar-field {
                flex: 1 1 0;
            }

            .search-bar .search-bar-button {
                width: auto;
                flex: 0 0 auto;
            }

        }


        /* For Tablet View */

        @media screen and (min-device-width: 768px) and (max-device-width: 1024px) {
            .menu-block {
                margin-left: 2rem;
            }
        }


        /* For Mobile Portrait View */

        @media screen and (max-device-width: 480px) and (orientation: portrait) {
            .menu-block {
                margin-left: 2rem;
            }
        }


        /* For Mobile Landscape View */

        @media screen and (max-device-width: 640px) and (orientation: landscape) {
            .menu-block {
                margin-left: 2rem;
            }
        }


        /* For Mobile Phones Portrait or Landscape View */

        @media screen and (max-device-width: 640px) {
            .menu-block {
                margin-left: 2rem;
            }
        }


        /* For iPhone 4 Portrait or Landscape View */

        @media screen and (min-device-width: 320px) and (-webkit-min-device-pixel-ratio: 2) {
            .menu-block {
                margin-left: 2rem;
            }
        }


        /* For iPhone 5 Portrait or Landscape View */

        @media (device-height: 568px) and (device-width: 320px) and (-webkit-min-device-pixel-ratio: 2) {
            .menu-block {
                margin-left: 2rem;
            }
        }


        /* For iPhone 6 and 6 plus Portrait or Landscape View */

        @media (min-device-height: 667px) and (min-device-width: 375px) and (-webkit-min-device-pixel-ratio: 3) {
            .menu-block {
                margin-left: 2rem;
            }
        }
    </style>
</head>

<body>

    <!-- Header Section -->

    <header class="header" id="header">
        <nav class="navbar">
            <a href="<?= SITE_URL ?>" class="brand"><img class="img img-responsive" src="images/BloomingInn-Logo-Color-FINAL.png"></a>
            <div class="burger" id="burger">
                <span class="burger-line"></span>
                <span class="burger-line"></span>
                <span class="burger-line"></span>
            </div>
            <div class="menu" id="menu">
                <ul class="menu-inner">
                    <li class="menu-item"><a href="<?= SITE_URL ?>" class="menu-link">Home</a></li>
                    <li class="menu-item"><a href="<?= SITE_URL . 'listings' ?>" class="menu-link">Properties</a></li>
                    <li class="menu-item"><a href="<?= SITE_URL . 'nearby' ?>" class="menu-link">Things To Do</a></li>
                    <li class="menu-item"><a href="<?= SITE_URL . 'about' ?>" class="menu-link">About</a></li>
                    <li class="menu-item"><a href="<?= SITE_URL . 'contact' ?>" class="menu-link">Contact</a></li>
                </ul>
            </div>
            <div class="button_block">
                <a href="<?= SITE_URL . 'listings' ?>" class="menu-block">Book Now</a>
            </div>
        </nav>
    </header>


    <!-- Main Section -->

    <main class="main">