<?php



session_start();



defined('ENVIRONMENT') || define('ENVIRONMENT', 'prod');

date_default_timezone_set('Asia/Kolkata');

if (ENVIRONMENT == 'prod') {

    defined('SITE_URL') || define('SITE_URL', 'https://shelburne.mwsserver.co.in/');

    defined('USER_NAME') || define('USER_NAME', 'mwsserverco_shelburne');

    defined('PASSWORD') || define('PASSWORD', 'shelburne@123');

} else {

    defined('SITE_URL') || define('SITE_URL', 'http://localhost/akumal/');

    defined('USER_NAME') || define('USER_NAME', 'root');

    defined('PASSWORD') || define('PASSWORD', '');

}



defined('MAILER_TO_ADDRESS') || define('MAILER_TO_ADDRESS', 'richbinns@gmail.com');

defined('MAILER_TO_NAME') || define('MAILER_TO_NAME', 'Blooming Inn Shelburne Falls');

defined('HOST_NAME') || define('HOST_NAME', 'localhost');

defined('DATABASE') || define('DATABASE', 'mwsserverco_shelburne');

defined('ADMIN_URL') || define('ADMIN_URL', SITE_URL . 'management/');

defined('STATUS') || define('STATUS', ['0' => 'Inactive', '1' => 'Active']);

defined("MAX_GUEST_LIMIT") || define("MAX_GUEST_LIMIT", 10);

defined('ROOMS_BEDS_CONSTANT') || define('ROOMS_BEDS_CONSTANT', 10);



function redirect($url)

{

    echo '<script> window.location.href="' . $url . '"; </script>';

    exit;

}



function debug($data, $die = true)

{

    echo '<pre>';

    print_r($data);

    echo '</pre>';

    if ($die == true) {

        die;

    }

}



function isAdmin()

{

    if (isset($_SESSION['user'])) {

        return true;

    } else {

        return false;

    }

}



function checkAdminLogin()

{

    if (!isAdmin()) {

        setDisplayMsg('error', "You must log in first");

        redirect(ADMIN_URL . 'login');

    }

}



function display_messages()
{
    if (isset($_SESSION['message'])) {
        // foreach ($_SESSION['message'] as $mv) {
        echo '<div class="alert alert-' . ($_SESSION['message']['type'] == 'error' ? 'danger' : 'success') . ' alert-dismissible fade show">';
        echo '<strong>' . ($_SESSION['message']['type'] == 'error' ? 'Error' : 'Success') . '!</strong>';
        echo  ' ' . $_SESSION['message']['msg'];
        echo '<div class="error"><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>';
        echo '</div>';
        // }
        unset($_SESSION['message']);
    }
}

function setDisplayMsg($type, $msg)
{
    $_SESSION['message'] = ['type' => $type, 'msg' => $msg];
}







// connect to database

include 'db.php';



include 'pagination.php';





if (isset($_GET['logout'])) {

    if (isAdmin()) {

        $url = ADMIN_URL;

    } else {

        $url = ADMIN_URL . 'login';

    }

    session_destroy();

    unset($_SESSION['user']);

    redirect($url);

}

