<?php include 'header.php'; ?>

<?php
$order_by = '';
if (isset($_GET['order'])) {
  if ($_GET['order'] == 'az') {
    $order_by = 'ORDER BY pro_title ASC ';
  } else if ($_GET['order'] == 'za') {
    $order_by = 'ORDER BY pro_title DESC ';
  } else if ($_GET['order'] == 'rand') {
    $order_by = 'ORDER BY rand()';
  }
}
$sql = "SELECT * FROM property_list where is_active = 1 " . $order_by;
$db =  new Database();
$db->query($sql);
$all_properties = $db->getAll();
?>

<style>
  .bg-banner {

    background: url('images/0b196391-b759-4036-8cd4-d975bdb07dc8.jpeg');

    width: 100%;

    height: 600px;

    background-size: cover;

    background-repeat: no-repeat;

    background-position: center center;

  }





  .bg-banner h1 {

    color: #FFFFFF;

    font-family: "Quicksand", Sans-serif;

    font-size: 3.8vw;

    font-weight: 600;

    text-transform: capitalize;

    line-height: 1.2em;

    text-shadow: 2px 7px 8px rgba(0, 0, 0, 0.99);

  }



  .bg-banner p {

    text-align: center;

    color: #FFFFFF;

    font-family: "Quicksand", Sans-serif;

    font-size: 25px;

    font-weight: 600;

  }



  .section p.content {

    text-align: center;

    font-size: 18px;

    font-weight: 500;

    font-family: emoji;

  }





  .filter-box {

    display: inline-flex;

  }



  .filter-title {

    padding-right: 15px;

  }



  .filter-search {

    width: 150px;

    height: 50px;

  }



  .album .card {

    transition: box-shadow 1s ease;

  }



  .album .card:hover {

    box-shadow: 0px 0px 7px 4px lightblue;

    background: #00000005;

    opacity: 0.8;

    border: 1px solid #a3eddf;

  }



  .album .card:before {

    content: 'Private room in home';

    background: #1ab6fc9e;

    padding: 0px 10px;

    font-size: 16px;

    right: 15px;

    top: 15px;

    color: #fff;

    position: absolute;

    border-radius: 2px;

  }



  .album .card .card-title {

    text-align: left;

    font-size: 18px;

    color: #000;
    font-weight: 500;

    font-family: 'Mons', sans-serif;

  }



  .album .card .card-text {

    font-size: 14px;
    color: #000;
    text-align: left;

    font-family: sans-serif;

    font-weight: 400;

  }



  .album .card .card-icon {

    text-align: right;

    float: right;

    color: #000;
    font-size: 14px;

    padding: 0 4px;

    font-family: sans-serif;

    font-weight: 400;

  }



  .filter-title h2 {

    font-size: 18px;

    font-weight: 600;

    color: #90958f;

  }



  .sort-featured {

    background: #52c6fe;
    font-size: 14px;
    color: #fff;

  }
</style>

<section class="section banner banner-section bg-banner">

  <div class="position-relative overflow-hidden p-3 p-md-5 text-center ">

    <div class="col-md-12 p-lg-5 mx-auto my-5">

      <h1 class="display-4 ">Accommodation</h1>

      <p class="lead">Rooms</p>

    </div>

  </div>

</section>

<section class="section mt-5">

  <div class="container">

    <div class="row">

      <div class="col-lg-12 col-md-12 col-sm-12">

        <p class="lead content">All rooms at the Blooming Inn offer very comfortable beds with memory foam mattresses which can add to the overall comfort of the stay. Synthetic, non-allergenic pillows are available on request is also a nice touch, as it shows that the inn is accommodating to the needs of all guests. The availability of rooms with queen-size beds or twin beds also provides flexibility in accommodation options, which is always a plus. The inclusion of private baths with all rooms at the Blooming Inn adds to the overall convenience and privacy of the accommodations. Overall, these features make the Blooming Inn a great choice for anyone looking for a comfortable and flexible place to stay.</p>

      </div>

    </div>

  </div>

</section>

<section class="section mt-5 bg-light">

  <div class="container-fluid">

    <!-- <div class="search-bar">

      <div class="container">

        <div class="form-container">

          <form action="https://manage.bookingautomation.com/booking.php" novalidate="novalidate">

            <div class="row">

              <div class="col-sm-12 col-md-4 col-lg-4 search-bar-field">

                <div class="form-group">

                  <div class="input-group date">

                    <input class="form-control" id="ArrivalDate" name="checkin" placeholder="Arrival" min="< ?php echo date("Y-m-d"); ?>" onfocus="showDate(this)" onblur="hideDate(this)" style="cursor:pointer;background:#fff" type="text" value="">

                  </div>

                </div>

              </div>

              <div class="col-sm-12 col-md-4 col-lg-4 search-bar-field">

                <div class="form-group">

                  <div class="input-group date">

                    <input class="form-control valid" id="DepartureDate" name="checkout" min="< ?php echo date("Y-m-d"); ?>"  placeholder="Departure" onfocus="showDate(this)" onblur="hideDate(this)" style="cursor:pointer;background:#fff" type="text" value="">

                  </div>

                </div>

              </div>

              <div class="col-sm-12 col-md-3 col-lg-3 search-bar-field">

                <div class="form-group">

                  <select class="form-control" data-val="true" data-val-number="The field Guests must be a number." id="Guests" name="numadult">

                    <option selected="selected" value="">Any Guests</option>

                    <option value="1">1+ Guest</option>

                    <option value="2">2+ Guests</option>

                    <option value="3">3+ Guests</option>

                    <option value="4">4+ Guests</option>

                    <option value="5">5+ Guests</option>

                    <option value="6">6+ Guests</option>

                    <option value="7">7 Guests</option>

                  </select>

                </div>

              </div>

              <div class="col-sm-12 col-md-1 col-lg-1 search-bar-button">

                <div class="form-group">

                  <input type="hidden" name="lang" value="en">
                  <button type="submit" class="btn btn-default"><i class="fa fa-search"></i>Search</button>

                </div>

              </div>

            </div>

          </form>

        </div>

      </div>

    </div> -->

    <div class="album py-4 ">

      <div class="container">

        <div class="row">

          <div class="col-lg-12 col-md-12 col-sm-12">

            <div class="filter-box">

              <div class="filter-title">

                <h2><?= count($all_properties); ?> Properties</h2>

              </div>

              <div class="filter-search">

                <select class="form-control sort-featured" id="sorting_data" name="sort" onchange="orderProperties(this)">

                  <option value="za" <?= (($_GET['order'] == 'za') ? 'selected' : '') ?>>Z-A</option>

                  <option value="az" <?= (($_GET['order'] == 'az') ? 'selected' : '') ?>>A-Z</option>

                  <option value="rand" <?= (($_GET['order'] == 'rand') ? 'selected' : 'selected') ?>>Random</option>

                </select>

              </div>

            </div>

          </div>

        </div>

        <div class="row">
          <?php if (count($all_properties) > 0) { ?>

            <?php foreach ($all_properties as $pv) { ?>
              <div class="col-sm-12 col-md-6 col-lg-4">
                <a href="<?= SITE_URL . 'detail?slug=' . $pv['pro_slug']; ?>">

                  <div class="card mb-4 box-shadow">

                    <img class="card-img-top" data-src="holder.js/100px225?theme=thumb&amp;bg=55595c&amp;fg=eceeef&amp;text=Thumbnail" alt="Thumbnail [100%x225]" src="<?= 'images/properties/' . $pv['image_banner'] ?>" data-holder-rendered="true" style="height: 225px; width: 100%; display: block;">

                    <div class="card-body">

                      <h3 class="card-title"><?= $pv['pro_title'] ?></h3>

                      <div class="row">

                        <div class="col-md-8">

                          <p class="card-text"> <?= $pv['guest'] ?> Guests, <?= $pv['beds'] ?> Bedrooms, <?= $pv['bath'] ?> Bathrooms</p>

                        </div>

                        <div class="col-md-4">

                          <p class="card-text">

                            <span class="card-icon" data-toggle="tooltip" data-placement="top" title="Oceanfront, Ocean View, Near Ocean, Ocean, Beachfront, Beach View, Beach, Waterfront, Water View"><i class="fa fa-bars"></i></span>

                            <span class="card-icon" data-toggle="tooltip" data-placement="top" title="<?= implode('<br>', explode('##', $pv['rules'])) ?>"><i class="fa fa-wifi"></i></span>

                          </p>

                        </div>

                      </div>
                      <!-- 
                    <div class="d-flex justify-content-center align-items-center">

                      <div class="btn-group">

                        <a href="< ?= SITE_URL . 'detail?slug=' . $pv['pro_slug']; ?>" class=" text-link">More Info <i class="fa fa-angle-right"></i></a>

                      </div>

                    </div> -->

                    </div>

                  </div>

                </a>
              </div>
            <?php } ?>

          <?php } ?>
          

        </div>

      </div>

    </div>

</section>

<script>
  function orderProperties(_this) {
    let value = $(_this).val();
    if (value) {
      window.location.href = '<?= SITE_URL ?>listings?order=' + value;
    }
  }
</script>

<?php include 'footer.php'; ?>