<?php
include 'inc/config.php';
if (isset($_POST['submit_form'])) {
    $error = [];
    if (isset($_POST['fname'])) {
        $fname  =  $_POST['fname'];
        if (empty($fname)) {
            $error[] = 'Name Must Be Required!';
        }
        if (strlen($fname) > 50) {
            $error[] = 'Name Must Be Less Then Or Equal to 50 characters!';
        }
    }
    if (isset($_POST['phone'])) {
        $phone  =  $_POST['phone'];
        if (empty($phone)) {
            $error[] = 'Mobile Number Must Be Required!';
        }
        if (strlen($phone) > 20) {
            $error[] = 'Mobile Number Must Be Less Then Or Equal to 20 characters!';
        }
    }
    if (isset($_POST['msg'])) {
        $msg  =  $_POST['msg'];
        if (empty($msg)) {
            $error[] = 'Message Must Be Required!';
        }
        if (strlen($msg) > 250) {
            $error[] = 'Message Must Be Less Then Or Equal to 250 characters!';
        }
    }
    if (isset($_POST['email'])) {
        $email  =  $_POST['email'];
        if (empty($email)) {
            $error[] = 'Email Must Be Required!';
        }
        if (strlen($email) > 50) {
            $error[] = 'Email Address Must Be Less Then Or Equal to 50 characters!';
        }
    }
    if (count($error) > 0) {
        foreach ($error as $ev) {
            setDisplayMsg('error', $ev);
        }
        redirect(SITE_URL . 'contact');
    } else {
        $db =  new Database();
        $sql = "INSERT INTO contact_form(name, email, mobile, message,created_at,updated_at) VALUES (:name,:email,:mobile,:message,:cdate,:mdate)";
        $db->query($sql);
        $db->bind(':name', $fname);
        $db->bind(':email', $email);
        $db->bind(':mobile', $phone);
        $db->bind(':message', $msg);
        $db->bind(':cdate', date('Y-m-d h:i:s'));
        $db->bind(':mdate', date('Y-m-d h:i:s'));
        $results = $db->execute();
        if ($results > 0) {
            // Multiple recipients
            $to = MAILER_TO_ADDRESS; // note the comma

            // Subject
            $subject = 'New Enquiry From' . $fname . ' (' . $email . ')';

            // Message
            $message = '
                    <html>
                    <head>
                    <title>Contact Us Enquiry Form</title>
                    </head>
                    <body>
                    <p>Here are the birthdays upcoming in August!</p>
                    <table>
                        <tr>
                        <td><strong>Name</strong></td><td>' . $fname . '</td>
                        </tr>
                        <tr>
                        <td><strong>Email</strong></td><td>' . $email . '</td>
                        </tr>
                        <tr>
                        <td><strong>Mobile</strong></td><td>' . $phone . '</td>
                        </tr>
                        <tr>
                        <td><strong>Message</strong></td><td>' . $msg . '</td>
                        </tr>
                    </table>
                    </body>
                    </html>';

            // To send HTML mail, the Content-type header must be set
            $headers[] = 'MIME-Version: 1.0';
            $headers[] = 'Content-type: text/html; charset=iso-8859-1';

            // Additional headers
            $headers[] = 'To: ' . MAILER_TO_NAME . ' <' . MAILER_TO_ADDRESS . '>';
            $headers[] = 'From: ' . $fname . ' <' . $email . '>';
            // $headers[] = 'Cc: birthdayarchive@example.com';
            // $headers[] = 'Bcc: birthdaycheck@example.com';
            $users_header[] = 'MIME-Version: 1.0';
            $users_header[] = 'Content-type: text/html; charset=iso-8859-1';

            $users_header[] = 'To: ' .  $fname . ' <' . $email  . '>';
            $users_header[] = 'From: ' . MAILER_TO_NAME . ' <' . MAILER_TO_ADDRESS . '>';

            $user_message  = 'Thanks For contacting With us we will connect with you shortly!';

            // Mail it
            $res = mail($to, $subject, $message, implode("\r\n", $headers));

            $res = mail($email, 'Enquiry Submitted', $user_message, implode("\r\n", $users_header));
            if ($results) {
                setDisplayMsg('success', 'Thanks For contacting With us we will connect with you shortly!');
            } else {
                setDisplayMsg('error', 'There was Something an error, Please Try Again Later!');
            }
        } else {
            setDisplayMsg('error', 'There was Something an error, Please Try Again Later!');
        }
        redirect(SITE_URL . 'contact');
    }
}
