<link rel="stylesheet" type="text/css" href="<?= SITE_URL ?>public/admin/assets/vendor/fullcalendar/css/main.min.css">
<link rel="stylesheet" type="text/css" href="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.css">
<script src="<?= SITE_URL ?>public/admin/assets/vendor/fullcalendar/js/main.min.js"></script>
<script src="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.js"></script>

<div class="page-titles">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
        <li class="breadcrumb-item active"><a href="javascript:void(0)">Property Calender</a></li>
    </ol>
</div>
<fieldset style="margin: 25px 0px;">
    <div class="col-md-12 text-center">
        <button type="button" class="importButton btn btn-primary waves-effect ">Import Data</button>
    </div>
    <form id="form_validation" action="" method="POST" class="calform">
        <input type="hidden" name="calid" value="1">
        <div class="row clearfix">
            <div class="col-md-10">
                <div><strong>Calendar Url<label style="color: #c8202d;">*</label></strong></div>
                <div class="form-group form-float">
                    <div class="form-line">
                        <input type="url" required class="form-control" placeholder="Calendar Url" value="" name="calurl">
                    </div>
                </div>
            </div>
            <div class="col-md-2" style="margin: 18px 0px;">
                <button type="submit" name="cal_url" class="btn btn-primary">Save</button>
            </div>
        </div>
    </form>
</fieldset>
<div id='calendar'></div>
<script>
    var get_data = '<?php echo json_encode($calendar); ?>';
    document.addEventListener('DOMContentLoaded', function() {
        var calendarEl = document.getElementById('calendar');
        var calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,dayGridWeek,dayGridDay'
            },
            editable: true,
            eventLimit: true,
            selectable: true,
            selectHelper: true,
            views: {
                dayGridMonth: {
                    titleFormat: {
                        year: 'numeric',
                        month: '2-digit',
                        day: '2-digit'
                    },
                },
            },
            events: JSON.parse(get_data)
        });
        calendar.render();
    });

    $(document).on('click', ".importButton", function() {
        new swal({
            title: "Import Data",
            html: "<div class='card'><div class='card-body'><div class='row'><div class='col-md-12'>" +
                "<a href='<?= SITE_URL . 'public/admin/calendar_sample.csv' ?>' download><h4>Download sample file</h4></a>" +
                "</div>" +
                "<div class='col-md-12'>" +
                "<form action='<?= ADMIN_URL . 'property/import-calender' ?>' method='post' enctype='multipart/form-data'>" +
                "<div class='form-group'>" +
                "<label for='file' class='form-label'>Upload file :</label>" +
                "<input type='file' id='file' name='file' class='form-control' required  oninvalid='this.setCustomValidity(`Please Enter Calender CSV File`) oninput='this.setCustomValidity('')'/>" +
                "</div>" +
                "<div class='btn-group'>" +
                "<input type='submit' name='importSubmit' class='btn btn-primary' value='Upload' style='display: unset;'/>" +
                "</div>" +
                "</form>" +
                "</div>" +
                "</div>" +
                "</div>" +
                "</div>",
        });
    });

    $(document).on('submit', '.calform', function(e) {
        e.preventDefault();
        var form = $(this);
        $.ajax({
            type: "POST",
            url: '<?= ADMIN_URL . 'property/sync-cal-url' ?>',
            data: form.serialize(), // serializes the form's elements.
            dataType: 'json',
            success: function(data) {
                if (data['status'] == 'success') {
                    setTimeout(function() {
                        new swal(data['msg']);
                    }, 1000);
                } else {
                    setTimeout(function() {
                        new swal(data['msg']);
                    }, 1000);
                }
                setTimeout(function() {
                    location.reload();
                }, 2000);
            }
        });
    });
</script>