<?php
require_once APP_DIR . 'libs/View.php';
require_once APP_DIR . 'libs/Input.php';
require_once APP_DIR . 'libs/Database.php';
class RatesController
{
    private $_view;
    private $_db;

    public function __construct()
    {
        $this->_view  = new View();
        $this->_db = new Database();
    }

    public function index()
    {

        $sql = "SELECT * FROM " . PROPERTY_RATES . " WHERE 1 ";
        $this->_db->query($sql);
        $rates = $this->_db->getAll();

        $sql = "SELECT * FROM " . PROPERTY_BOOKING_DATES . " WHERE 1 ";
        $this->_db->query($sql);
        $booking_dates = $this->_db->getAll();

        $sql = "SELECT * FROM " . PROPERTY_LIST . " WHERE 1  AND id = 1";
        $this->_db->query($sql);
        $property_data = $this->_db->single();

        $startday = $endday = $totaldayslist1 = '';
        if (count($booking_dates) > 0) {
            foreach ($booking_dates as $val) {
                $start = $val['startdate'];
                $end = $val['enddate'];

                for ($i1 = $start; $i1 < $end; $i1 += 86400) {
                    $dateslistselect1[] = '"' . date('Y-m-d', $i1) . '"';
                }

                @$startd[] = '"' . date('Y-m-d', $start) . '"';
                @$endd[] = '"' . date('Y-m-d', $end) . '"';
            }
            $dateslistselect1 = array_filter($dateslistselect1);
            $totaldayslist1 = implode(", ", $dateslistselect1);

            $startd = array_filter($startd);
            $startday = implode(", ", $startd);

            $endd = array_filter($endd);
            $endday = implode(", ", $endd);
        }
        $this->_view->setVal('rates', $rates);
        $this->_view->setVal('property_data', $property_data);
        $this->_view->setVal('totaldayslist1', $totaldayslist1);
        $this->_view->setVal('startday', $startday);
        $this->_view->setVal('endday', $endday);

        $this->_view->setVal('favicon', '');
        $this->_view->setVal('site_logo', '');
        $this->_view->setVal('media_id', '');
        $this->_view->setVal('meta_title', '');
        $this->_view->setVal('meta_description', '');
        $this->_view->setVal('meta_keyword', '');
        $this->_view->renderFront(VIEW_DIR . 'rates');
    }

    public function getQuote()
    {
        if (!empty($_POST)) {

            $check_in  = $_POST['from'];
            $check_out = $_POST['to'];
            $sql = "SELECT * FROM " . PROPERTY_RATES . " WHERE 1 AND  ( fromdate  <= '" . $check_in . "'  OR  todate >=  '" . $check_out . "') ";
            $this->_db->query($sql);
            $rates = $this->_db->single();

            // dd($rates);

            $sql = "SELECT * FROM " . PROPERTY_LIST . " WHERE 1 AND id = 1";
            $this->_db->query($sql);
            $property_data = $this->_db->single();

            $datetime1 = new DateTime($check_in);
            $datetime2 = new DateTime($check_out);
            $difference = $datetime1->diff($datetime2);
            $days = $difference->d;

            if ($days == 7) {
                $gross_amount = $rates['weekly'];
            } else {
                $gross_amount =  ($rates['nightly'] * $days);
            }
            $service_fees = ($gross_amount * $property_data['service_fee'] / 100);
            $tax = ($gross_amount * $property_data['tax'] / 100);

            $final_amount =  $gross_amount + $service_fees + $tax;

            $this->_view->setVal('check_in', date('d, M Y', strtotime($check_in)));
            $this->_view->setVal('check_out',  date('d, M Y', strtotime($check_out)));

            $this->_view->setVal('check_in_field', $check_in);
            $this->_view->setVal('check_out_field', $check_out);
            $this->_view->setVal('days',  $days);
            $this->_view->setVal('property_data', $property_data);
            $this->_view->setVal('gross_amount', $gross_amount);
            $this->_view->setVal('final_amount', $final_amount);

            $this->_view->setVal('service_fees', $service_fees);
            $this->_view->setVal('tax', $tax);

            $this->_view->setVal('rates', $rates);
            $this->_view->setVal('favicon', '');
            $this->_view->setVal('site_logo', '');
            $this->_view->setVal('media_id', '');
            $this->_view->setVal('meta_title', '');
            $this->_view->setVal('meta_description', '');
            $this->_view->setVal('meta_keyword', '');
            $this->_view->renderFront(VIEW_DIR . 'booking_page');
        } else {
            redirect(SITE_URL . 'page-not-found');
        }
    }

    public function sendQuote()
    {

        $full_name = $_POST['fname'];
        $email = $_POST['email'];
        $phone = $_POST['phone'];
        $guest = $_POST['guest'];
        $address = $_POST['address'];
        $check_in = $_POST['checkin'];
        $check_out = $_POST['checkout'];

        if (empty($full_name)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill First Name']);
            exit;
        }
        if (empty($email)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill Email Address']);
            exit;
        }
        if (empty($phone)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill Mobile Number']);
            exit;
        }
        if (empty($guest)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill Guest Field']);
            exit;
        }
        if (empty($address)) {
            echo json_encode(['status' => 'error', 'msg' => 'Please Fill Address']);
            exit;
        }
        $data = [
            'name' => htmlspecialchars($full_name),
            'email' => htmlspecialchars($email),
            'phone' => htmlspecialchars($phone),
            'adults' => htmlspecialchars($guest),
            'address' => htmlspecialchars($address),
            'checkin' => $check_in,
            'checkout' => $check_out,
            'property_id' => 1,
            'added_date' =>  date('Y-m-d h:i:s'),
        ];

        $insert_bind_colum = '';
        $insert_colum_keys = array_keys($data);
        $insert_colum =  implode(',', $insert_colum_keys);
        foreach ($data as $uk => $uv) {
            if ($uk != end($insert_colum_keys)) {
                $separator = ',';
            } else {
                $separator = '';
            }
            $insert_bind_colum .= "'" . $uv . "'" . $separator;
        }
        $sql = " INSERT INTO " . PROPERTY_ENQUIRES . " ( " .  $insert_colum . ") VALUES (" . $insert_bind_colum . ")";

        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            dd( $msg);
            $results = 0;
        }

        $sql = "SELECT * FROM " . PROPERTY_LIST . " WHERE 1 AND id = 1";
        $this->_db->query($sql);
        $property_data = $this->_db->single();


        $sql = "SELECT * FROM " . SETTINGS . " WHERE 1 AND id = 1";
        $this->_db->query($sql);
        $settings = $this->_db->single();

        if ($results) {
            // Subject
            $subject = 'Booking Appointment Enquiry';
            // Message
           
            $message = '<html>
                        <head>
                        <title>Booking Appointment Enquiry</title>
                        </head>
                        <body>
                        <p>Booking Appointment Enquiry ' . $property_data['title'] . '</p>
                        <table>
                            <tr>
                            <td>Name</td><td>' . $full_name . '</td>
                            </tr>
                            <tr>
                            <td>Email</td><td>' . $email . '</td>
                            </tr>
                            <tr>
                            <td>Phone Number</td><td>' . $phone . '</td>
                            </tr>
                            <tr>
                            <td>Guest</td><td>' . $guest . '</td>
                            </tr>
                            <tr>
                            <td>Check In</td><td>' . date('d, M Y', strtotime($check_in)) . '</td>
                            </tr>
                            <tr>
                            <td>Check Out</td><td>' . date('d, M Y', strtotime($check_in)) . '</td>
                            </tr>
                        </table>
                        </body>
                        </html>';

            // To send HTML mail, the Content-type header must be set
            $headers[] = 'MIME-Version: 1.0';
            $headers[] = 'Content-type: text/html; charset=iso-8859-1';
            $headers[] = 'To: ' . $settings['mail_to_name'] . ' ' . $settings['mail_to'];
            $headers[] = 'From: ' . $settings['mail_from_name'] . ' ' . $settings['mail_from'];
             // Mail it
            mail(MAILER_TO_INFO, $subject, $message, implode("\r\n", $headers));

            $user_subject = 'Booking Appointment Response';
            $user_message = 'Thanks for contacting with us, we will reach you shortly.';
            $user_headers[] = 'MIME-Version: 1.0';
            $user_headers[] = 'Content-type: text/html; charset=iso-8859-1';
            $user_headers[] = 'To: ' . $full_name . ' ' . $email;
            $user_headers[] = 'From: ' . $settings['mail_from_name'] . ' ' . $settings['mail_from'];
            mail($email, $user_subject, $user_message, implode("\r\n", $user_headers));

            $type = 'success';
            $msg = 'Enquiry Send Successfully ';
        } else {
            $type   = "error";
            $msg = "Unable to send Enquiry!!";
        }

        echo json_encode(['status' => $type, 'msg' => $msg]);
        exit;
    }
}
