<div class="page-titles">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
        <li class="breadcrumb-item active"><a href="javascript:void(0)">Enquiries List</a></li>
    </ol>
</div>
<!-- row -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Enquiries List</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display table" style="min-width: 850px">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email </th>
                                <th>Mobile No</th>
                                <th>Hear Us</th>
                                <th>Message</th>
                                <th>Enquiry Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($enquiries_count > 0) { ?>
                                <?php foreach ($enquiries_list as $ev) { ?>
                                    <tr>
                                        <td><?php echo $ev['name']; ?></td>
                                        <td><?php echo $ev['email']; ?></td>
                                        <td><?php echo $ev['mobile']; ?></td>
                                        <td><?php echo $ev['hear_us']; ?></td>
                                        <td><?php echo $ev['message']; ?></td>
                                        <td><?php echo !empty($ev['created_at']) ? date('d,M Y h:s A', strtotime($ev['created_at'])) : ''; ?></td>
                                        <td>
                                            <a href="javascript:void(0);" onclick="deleteData(this)" data-href="<?= ADMIN_URL . 'enquiries/delete-enquiry/' . encryptData($ev['id']) ?>" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i> Delete</a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            <?php } else { ?>
                                <tr>
                                    <td colspan="7" class="text-center">No Records Found</td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>

                <?php if ($enquiries_count > 0) { ?>
                    <div class="col-lg-12">
                        <p class="mb-2 me-3">
                            <?= $enquiries_pagination->displayLinks(ADMIN_URL . 'enquiries'); ?>
                        </p>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" type="text/css" href="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.css">
<script src="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.js"></script>
<script>
    function deleteData(_this) {
        let url = $(_this).attr('data-href');
        new swal({
            title: 'Are you sure?',
            text: "It will permanently deleted !",
            type: 'danger',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            } else if (result.isDenied) {}
        })
    }
</script>