<div class="page-titles">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
        <li class="breadcrumb-item active"><a href="javascript:void(0)">Gallery List</a></li>
    </ol>
</div>
<!-- row -->
<style>
    .image_div {
        position: relative;
        top: -125px;
        left: 5px;
    }
</style>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form action="<?= ADMIN_URL  . 'property/save-gallery' ?>" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="mb-3 col-lg-12 col-md-12 col-sm-12">
                            <div class="col-lg-12 col-md-12 col-sm-12">
                                <img id="image_preview" onclick="readImage()" class="img img-responsive img-fluid" src="<?= SITE_URL ?>public/admin/assets/images/no-img-avatar.png">
                                <input type="file" id="image" class="form-control d-none" name="gallery[]" multiple>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12">
                                <label class="form-label" for="image">Select Multiple files here or click to upload.</label>
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <label class="form-label">
                                Photos must be at least 800 x 600 pixels in size.<br>
                                File size cannot exceed 6 MB<br>
                                Upload max 10 photos at a time<br>
                                Upload only Jpeg, jpg, png, gif images
                            </label>
                        </div>
                        <div class="mb-3 col-12">
                            <div class="col-sm-12 pt-3">
                                <input type="submit" class="btn btn-sm btn-primary me-2" name="property_galleries" value="Upload">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Gallery List</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php foreach ($gallery_list as $gv) { ?>
                        <div class="col-xl-2 col-lg-3 col-md-6 col-sm-12 mb-3">
                            <div class="image_box">
                                <img src="<?= UPLOAD_URL . 'gallery/' . $gv['image']; ?>" class="img img-responsive img-fluid">
                                <div class="image_div">
                                    <div>
                                        <a href="javascript:void(0);" onclick="deleteData(this)" data-href="<?= ADMIN_URL . 'property/delete-gallery/' . encryptData($gv['id']) ?>" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function readImage() {
        $('#image').click();
    }
</script>

<link rel="stylesheet" type="text/css" href="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.css">
<script src="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.js"></script>
<script>
    function deleteData(_this) {
        let url = $(_this).attr('data-href');
        new swal({
            title: 'Are you sure?',
            text: "It will permanently deleted !",
            type: 'danger',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            } else if (result.isDenied) {}
        })
    }
</script>