<div class="page-titles">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
        <li class="breadcrumb-item"><a href="javascript:void(0)">Slider List</a></li>
        <li class="breadcrumb-item active"><a href="javascript:void(0)"><?= $title; ?></a></li>
    </ol>
</div>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?= $title; ?></h4>
            </div>
            <div class="card-body">
                <form action="<?= ADMIN_URL . 'slider/save' ?>" method="post" enctype="multipart/form-data">
                    <?php if (isset($sliderData['id'])) { ?>
                        <?php if (!empty($sliderData['id'])) { ?>
                            <input type="hidden" name="id" value="<?= $sliderData['id'] ?>">
                        <?php } ?>
                    <?php } ?>
                    <div class="row">
                        <div class="mb-3 col-lg-2 col-md-2 col-sm-12">
                            <div class="avatar-upload d-flex align-items-center">
                                <div class="position-relative ">
                                    <div class="avatar-preview">
                                        <?php if (!empty($sliderData['image'])) { ?>
                                            <img id="image_preview" class="img img-responsive img-fluid" src="<?= SITE_URL ?>public/images/slider/<?= $sliderData['image']; ?>">
                                        <?php } else { ?>
                                            <img id="image_preview" class="img img-responsive img-fluid" src="<?= SITE_URL ?>public/admin/assets/images/no-img-avatar.png">
                                        <?php } ?>
                                    </div>
                                    <div class="change-btn d-flex align-items-center flex-wrap">
                                        <input type="file" class="form-control d-none" name="media" data-attr="image_preview" id="image" onchange="readURL(this);" accept=".png, .jpg, .jpeg">
                                        <label for="image" class="btn btn-primary light btn-sm ms-0">Select Image</label>
                                        <input type="hidden" name="media_old" value="<?php echo $sliderData['image'] ?? ''; ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3 col-lg-8 col-md-8 col-sm-12">
                            <label class="form-label">Slider Title</label>
                            <input type="text" class="form-control" placeholder="Slider Title" required="" value="<?= $sliderData['title'] ?? '' ?>" name="title">
                        </div>
                        <div class="mb-3 col-lg-2 col-md-2 col-sm-12">
                            <label class="form-label">Status</label>
                            <select class="default-select form-control wide" name="status" required="">
                                <option value="1" <?= (isset($sliderData['status']) ? (($sliderData['status'] == 1)  ? 'selected' : '') : '') ?>>Active</option>
                                <option value="0" <?= (isset($sliderData['status']) ? (($sliderData['status'] == 0)  ? 'selected' : '') : '') ?>>Inactive</option>
                            </select>
                        </div>

                        <div class="mb-3 col-12">
                            <div class="col-sm-12 pt-3">
                                <input type="submit" class="btn btn-sm btn-primary me-2" name="register_property" value="Submit">
                                <a href="<?= ADMIN_URL . 'slider' ?>" class="btn light btn-warning">Back to Listing</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                let web_id = $(input).attr('data-attr');
                $('#' + web_id).attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>