<?php
require_once APP_DIR . 'libs/View.php';
require_once APP_DIR . 'libs/Input.php';
require_once APP_DIR . 'libs/Session.php';
require_once APP_DIR . 'models/AuthModel.php';
require_once APP_DIR . 'libs/Database.php';
require_once APP_DIR . 'libs/Pagination.php';
require_once APP_DIR . 'libs/ICalendar.php';

class PropertyController
{

    private $_view;
    private $_db;

    public function __construct()
    {
        check_login('index');
        $this->_view  = new View();
        $this->_db = new Database();
    }

    /* Properties Data start */
    public function index()
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }
        $sql = "SELECT * FROM " . PROPERTY_TYPE . " WHERE 1 ";
        $this->_db->query($sql);
        $propertyType = $this->_db->getAll();
        $this->_view->setVal('propertyType', $propertyType);

        $sql = "SELECT * FROM " . PROPERTY_LIST . " WHERE 1 AND id = 1";
        $this->_db->query($sql);
        $property_data = $this->_db->single();
        $this->_view->setVal('property_data', $property_data);
        $this->_view->setVal('meta_title', 'Property Page');
        $this->_view->setVal('meta_description', 'Property Page');
        $this->_view->setVal('meta_keyword', 'Property Page');
        $this->_view->renderAdmin('property-data');
    }

    public function save()
    {
        $title = $_POST['title'];
        $id = $_POST['id'] ?? '';
        $type = $_POST['type'];
        $video = $_POST['video'];
        $bedroom = $_POST['bedroom'];
        $bathroom = $_POST['bathroom'];
        $guest = $_POST['guest'];
        $max_sleep = $_POST['max_sleep'];
        $desc = $_POST['desc'];
        $facebook = $_POST['facebook'];
        $twitter = $_POST['twitter'];
        $instagram = $_POST['instagram'];
        $youtube = $_POST['youtube'];
        $copyright = $_POST['copyright'];

        $data = [
            'title' => $title,
            'type' => $type,
            'video_id' => $video,
            'description' => $desc,
            'beds' => $bedroom,
            'bath' => $bathroom,
            'guest' => $guest,
            'max_stay' => $max_sleep,
            'facebook_link' => $facebook,
            'twitter_link' => $twitter,
            'instagram_link' => $instagram,
            'youtube_link' => $youtube,
            'copyright_text' => $copyright,
        ];


        if (!empty($id)) {
            $data['updated_on'] =  date('Y-m-d h:i:s');
            $update_coloum = '';
            $updated_coloms_keys = array_keys($data);
            foreach ($data as $uk => $uv) {
                if ($uk != end($updated_coloms_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $update_coloum .= $uk . " = '" . $uv . "'" . $separator;
            }

            $sql = "UPDATE " . PROPERTY_LIST . " SET " . $update_coloum . " WHERE id = " . $id;
            $mode = 'Updated';
        } else {
            $data['created_on'] =  date('Y-m-d h:i:s');
            $insert_bind_colom = '';
            $insert_colom_keys = array_keys($data);
            $insert_colom =  implode(',', $insert_colom_keys);
            foreach ($data as $uk => $uv) {
                if ($uk != end($insert_colom_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $insert_bind_colom .= "'" . $uv . "'" . $separator;
            }
            $sql = " INSERT INTO " . PROPERTY_LIST . " ( " .  $insert_colom . ") VALUES (" . $insert_bind_colom . ")";

            $mode = 'Saved';
        }

        $type   = "error";
        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {

            $type = 'success';
            $msg = 'Property Data Successfully ' . $mode;
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Property Data!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'property');
    }
    /* Properties Data end */

    /* Properties Types start */
    public function types($id = '')
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        if ($id > 0) {
            $id = decryptData($id);
            $sql = "SELECT * FROM " . PROPERTY_TYPE . " WHERE 1 AND id = " . $id;
            $this->_db->query($sql);
            $property_type_data_edit = $this->_db->single();
            $this->_view->setVal('property_type_data_edit',  $property_type_data_edit);
            $this->_view->setVal('label',  'Edit');
        } else {
            $this->_view->setVal('label',  'Add');
        }

        $live_data_list =  $live_data_pagination = [];
        $sql = "SELECT count(*) as count FROM " . PROPERTY_TYPE . " WHERE 1 ";
        $this->_db->query($sql);
        $live_data = $this->_db->single();
        $live_data_count = $live_data['count'];
        if ($live_data_count > 0) {
            $limit = isset($_GET['page_limit']) ?  $_GET['page_limit'] :  50;
            $page_num = isset($_GET['page_num']) ? $_GET['page_num'] : 1;
            $startAt = ($limit * ($page_num - 1));
            $sql = "SELECT * FROM " . PROPERTY_TYPE . " WHERE 1  LIMIT " .  $startAt . ',' . $limit;
            $this->_db->query($sql);
            $live_data_list = $this->_db->getAll();
            $live_data_pagination  = new Pagination($live_data_count, $page_num, $limit, $startAt);
        }

        $this->_view->setVal('start_counter',  $startAt);
        $this->_view->setVal('property_type_data',  $live_data);
        $this->_view->setVal('property_type_count',  $live_data_count);
        $this->_view->setVal('property_type_list',  $live_data_list);
        $this->_view->setVal('property_type_pagination',  $live_data_pagination);
        $this->_view->setVal('meta_title', 'Property Type Page');
        $this->_view->setVal('meta_description', 'Property Type Page');
        $this->_view->setVal('meta_keyword', 'Property Type Page');
        $this->_view->renderAdmin('property-type');
    }


    public function saveTypes()
    {

        $title = $_POST['title'];
        $status = $_POST['status'];
        $id = $_POST['id'] ?? '';

        $data = [
            'name' => $title,
            'status' => $status,
        ];


        if (!empty($id)) {
            $data['updated'] =  date('Y-m-d h:i:s');
            $update_coloum = '';
            $updated_coloms_keys = array_keys($data);
            foreach ($data as $uk => $uv) {
                if ($uk != end($updated_coloms_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $update_coloum .= $uk . " = '" . $uv . "'" . $separator;
            }

            $sql = "UPDATE " . PROPERTY_TYPE . " SET " . $update_coloum . " WHERE id = " . $id;
            $mode = 'Updated';
        } else {
            $sql = "SELECT count(*) as count FROM " . PROPERTY_TYPE . " WHERE 1 AND name = '" . $title . "'";
            $this->_db->query($sql);
            $rec = $this->_db->single();

            if ($rec['count'] > 0) {
                $type   = "error";
                $msg = "Property Type Already Exist !!";
                set_session_alert($type, $msg);
                redirect(ADMIN_URL . 'property/types');
            }
            $data['added'] =  date('Y-m-d h:i:s');
            $insert_bind_colom = '';
            $insert_colom_keys = array_keys($data);
            $insert_colom =  implode(',', $insert_colom_keys);
            foreach ($data as $uk => $uv) {
                if ($uk != end($insert_colom_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $insert_bind_colom .= "'" . $uv . "'" . $separator;
            }
            $sql = " INSERT INTO " . PROPERTY_TYPE . " ( " .  $insert_colom . ") VALUES (" . $insert_bind_colom . ")";
            $mode = 'Saved';
        }

        $type = "error";
        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {

            $type = 'success';
            $msg = 'Property Type Successfully ' . $mode;
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Property Type!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'property/types');
    }


    public function deleteTypes($id)
    {
        $id = decryptData($id);
        $retVal = false;
        if ($id > 0) {
            $sql = "SELECT * FROM " . PROPERTY_TYPE . " WHERE 1  AND id  = " . $id;
            $this->_db->query($sql);
            $res = $this->_db->single();
            if (isset($res)) {
                $sql = "DELETE FROM " . PROPERTY_TYPE . " WHERE 1  AND id = " . $id;
                $this->_db->query($sql);
                $retVal = $this->_db->execute();
                if ($retVal) {
                    $type = 'success';
                    $msg = 'Property Type Successfully Deleted';
                } else {
                    $type = 'error';
                    $msg = 'Error In deleting Property Type data';
                }
            } else {
                $type = 'error';
                $msg = 'Error In deleting Property Type data';
            }
        } else {
            $type = 'error';
            $msg = 'Error In deleting Property Type data';
        }
        set_session_alert($type, $msg);
        redirect(ADMIN_URL . 'property/types');
    }
    /* Properties Types end */

    /* Properties Attractions start */
    public function attractions()
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        $limit = isset($_GET['page_limit']) ?  $_GET['page_limit'] :  50;
        $page_num = isset($_GET['page_num']) ? $_GET['page_num'] : 1;
        $startAt = ($limit * ($page_num - 1));
        $live_data_list =  $live_data_pagination = [];
        $sql = "SELECT count(*) as count FROM " . ATTRACTIONS . " WHERE 1 ";
        $this->_db->query($sql);
        $live_data = $this->_db->single();
        $live_data_count = $live_data['count'];
        if ($live_data_count > 0) {
            $page_num = isset($_GET['page_num']) ? $_GET['page_num'] : 1;
            $startAt = ($limit * ($page_num - 1));
            $sql = "SELECT * FROM " . ATTRACTIONS . " WHERE 1  LIMIT " .  $startAt . ',' . $limit;
            $this->_db->query($sql);
            $live_data_list = $this->_db->getAll();
            $live_data_pagination  = new Pagination($live_data_count, $page_num, $limit, $startAt);
        }

        $this->_view->setVal('start_counter',  $startAt);
        $this->_view->setVal('attraction_data',  $live_data);
        $this->_view->setVal('attraction_count',  $live_data_count);
        $this->_view->setVal('attraction_list',  $live_data_list);
        $this->_view->setVal('attraction_pagination',  $live_data_pagination);
        $this->_view->setVal('meta_title', 'Attraction List Page');
        $this->_view->setVal('meta_description', 'Attraction List Page');
        $this->_view->setVal('meta_keyword', 'Attraction List Page');
        $this->_view->renderAdmin('attractions/attractions-list');
    }

    public function manageAttractions($id = null)
    {
        $user_id = SESSION::get('uId');

        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        if (!empty($id)) {
            $id  = decryptData($id);
            $edit_id = $id;
            if ($edit_id > 0) {
                $sql = "SELECT * FROM " . ATTRACTIONS . " WHERE 1  AND id  = " . $id;
                $this->_db->query($sql);
                $res = $this->_db->single();
                $this->_view->setVal('attractionData', $res);
                $label = 'Edit Attraction';
            } else {
                set_session_alert('error', 'Invalid Data');
                redirect(ADMIN_URL . 'property/attractions');
            }
        } else {
            $label = 'Add Attraction';
        }

        $this->_view->setVal('title', $label);
        $this->_view->setVal('meta_title',   $label);
        $this->_view->setVal('meta_description',   $label);
        $this->_view->setVal('meta_keyword',  $label);
        $this->_view->renderAdmin('attractions/attractions-data');
    }

    public function saveAttractions()
    {

        $title = $_POST['title'];
        $desc = $_POST['desc'];
        $url = $_POST['url'];
        $status = $_POST['status'];
        $id = $_POST['id'] ?? '';
        $folder_data = UPLOAD_ROOT . 'attractions/';

        $filename = $_FILES["media"]["name"];
        $temp_name = $_FILES["media"]["tmp_name"];
        $old_file = $_POST['media_old'] ?? null;
        $new_file_name = rand(100, 99999999) . $filename;
        $folder = $folder_data . $new_file_name;
        if (!empty($old_file)) {
            if (!empty($temp_name)) {
                if (move_uploaded_file($temp_name, $folder)) {
                    unlink($folder_data . $old_file);
                    $file_name = $new_file_name;
                } else {
                    $file_name = $old_file;
                }
            } else {
                $file_name = $old_file;
            }
        } else {
            if (move_uploaded_file($temp_name, $folder)) {
                $file_name = $new_file_name;
            } else {
                $file_name = null;
            }
        }


        $data = [
            'title' => htmlspecialchars($title),
            'description' => htmlspecialchars($desc),
            'url' => htmlspecialchars($url),
            'image' => $file_name,
            'status' => $status,
        ];
        if (!empty($id)) {
            $data['updated_at'] =  date('Y-m-d h:i:s');
            $update_colum = '';
            $updated_colum_keys = array_keys($data);
            foreach ($data as $uk => $uv) {
                if ($uk != end($updated_colum_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $update_colum .= $uk . " = '" . $uv . "'" . $separator;
            }

            $sql = "UPDATE " . ATTRACTIONS . " SET " . $update_colum . " WHERE id = " . $id;
            $mode = 'Updated';
            $url = 'manage-attractions/' . encryptData($id);
        } else {
            $data['created_at'] =  date('Y-m-d h:i:s');
            $url = 'manage-attractions';
            $insert_bind_colum = '';
            $insert_colum_keys = array_keys($data);
            $insert_colum =  implode(',', $insert_colum_keys);
            foreach ($data as $uk => $uv) {
                if ($uk != end($insert_colum_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $insert_bind_colum .= "'" . $uv . "'" . $separator;
            }
            $sql = " INSERT INTO " . ATTRACTIONS . " ( " .  $insert_colum . ") VALUES (" . $insert_bind_colum . ")";
            $mode = 'Saved';
        }

        $type = "error";
        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {
            $type = 'success';
            $msg = 'Attractions Data Successfully ' . $mode;
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Attractions Data!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'property/' . $url);
    }

    public function deleteAttractions($id)
    {
        $id = decryptData($id);
        $retVal = false;
        if ($id > 0) {
            $sql = "SELECT * FROM " . ATTRACTIONS . " WHERE 1  AND id  = " . $id;
            $this->_db->query($sql);
            $res = $this->_db->single();
            if (isset($res)) {
                $sql = "DELETE FROM " . ATTRACTIONS . " WHERE 1  AND id = " . $id;
                $this->_db->query($sql);
                $retVal = $this->_db->execute();
                if ($retVal) {
                    if (!empty($res['image'])) {
                        unlink(UPLOAD_ROOT . 'attractions/' . $res['image']);
                    }
                    $type = 'success';
                    $msg = 'Attractions Data Successfully Deleted';
                } else {
                    $type = 'error';
                    $msg = 'Error In deleting Attractions Data';
                }
            } else {
                $type = 'error';
                $msg = 'Error In deleting Attractions Data';
            }
        } else {
            $type = 'error';
            $msg = 'Error In deleting Attractions Data';
        }
        set_session_alert($type, $msg);
        redirect(ADMIN_URL . 'property/attractions');
    }
    /* Properties Attractions end */

    /* Properties Amenities start */
    public function amenities()
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        $limit = isset($_GET['page_limit']) ?  $_GET['page_limit'] :  50;
        $page_num = isset($_GET['page_num']) ? $_GET['page_num'] : 1;
        $startAt = ($limit * ($page_num - 1));
        $live_data_list =  $live_data_pagination = [];
        $sql = "SELECT count(*) as count FROM " . PROPERTY_AMENITIES . " WHERE 1 ";
        $this->_db->query($sql);
        $live_data = $this->_db->single();
        $live_data_count = $live_data['count'];
        if ($live_data_count > 0) {
            $page_num = isset($_GET['page_num']) ? $_GET['page_num'] : 1;
            $startAt = ($limit * ($page_num - 1));
            $sql = "SELECT * FROM " . PROPERTY_AMENITIES . " WHERE 1  LIMIT " .  $startAt . ',' . $limit;
            $this->_db->query($sql);
            $live_data_list = $this->_db->getAll();
            $live_data_pagination  = new Pagination($live_data_count, $page_num, $limit, $startAt);
        }

        $this->_view->setVal('start_counter',  $startAt);
        $this->_view->setVal('amenities_data',  $live_data);
        $this->_view->setVal('amenities_count',  $live_data_count);
        $this->_view->setVal('amenities_list',  $live_data_list);
        $this->_view->setVal('amenities_pagination',  $live_data_pagination);
        $this->_view->setVal('meta_title', 'Amenities Page');
        $this->_view->setVal('meta_description', 'Amenities Page');
        $this->_view->setVal('meta_keyword', 'Amenities Page');
        $this->_view->renderAdmin('amenities/amenities-list');
    }

    public function manageAmenities($id = null)
    {
        $user_id = SESSION::get('uId');

        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        if (!empty($id)) {
            $id = decryptData($id);
            $edit_id = $id;
            if ($edit_id > 0) {
                $sql = "SELECT * FROM " . PROPERTY_AMENITIES . " WHERE 1  AND id  = " . $id;
                $this->_db->query($sql);
                $res = $this->_db->single();
                $this->_view->setVal('amenitiesData', $res);
                $label = 'Edit Amenities';
            } else {
                set_session_alert('error', 'Invalid Data');
                redirect(ADMIN_URL . 'property/amenities');
            }
        } else {
            $label = 'Add Amenities';
        }

        $this->_view->setVal('title', $label);
        $this->_view->setVal('meta_title',   $label);
        $this->_view->setVal('meta_description',   $label);
        $this->_view->setVal('meta_keyword',  $label);
        $this->_view->renderAdmin('amenities/amenities-data');
    }

    public function saveAmenities()
    {
        $title = $_POST['title'];
        $desc = $_POST['amenities'];
        $status = $_POST['status'];
        $id = $_POST['id'] ?? '';
        $amenities_count  = explode(',', $desc);
        $multiple = ($amenities_count > 1 ? 1 : 0);
        $data = [
            'amenityname' => htmlspecialchars($title),
            'amenities' => htmlspecialchars($desc),
            'status' => $status,
            'multiple' => $multiple,
        ];
        if (!empty($id)) {
            $data['updated_date'] =  date('Y-m-d h:i:s');
            $update_colum = '';
            $updated_colum_keys = array_keys($data);
            foreach ($data as $uk => $uv) {
                if ($uk != end($updated_colum_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $update_colum .= $uk . " = '" . $uv . "'" . $separator;
            }

            $sql = "UPDATE " . PROPERTY_AMENITIES . " SET " . $update_colum . " WHERE id = " . $id;
            $mode = 'Updated';
            $url = 'manage-amenities/' . encryptData($id);
        } else {
            $data['added_date'] =  date('Y-m-d h:i:s');
            $url = 'manage-amenities';
            $insert_bind_colum = '';
            $insert_colum_keys = array_keys($data);
            $insert_colum =  implode(',', $insert_colum_keys);
            foreach ($data as $uk => $uv) {
                if ($uk != end($insert_colum_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $insert_bind_colum .= "'" . $uv . "'" . $separator;
            }
            $sql = " INSERT INTO " . PROPERTY_AMENITIES . " ( " .  $insert_colum . ") VALUES (" . $insert_bind_colum . ")";
            $mode = 'Saved';
        }

        $type = "error";
        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {
            $type = 'success';
            $msg = 'Amenities Data Successfully ' . $mode;
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Amenities Data!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'property/' . $url);
    }

    public function deleteAmenities($id)
    {
        $id = decryptData($id);
        $retVal = false;
        if ($id > 0) {
            $sql = "SELECT * FROM " . PROPERTY_AMENITIES . " WHERE 1  AND id  = " . $id;
            $this->_db->query($sql);
            $res = $this->_db->single();
            if (isset($res)) {
                $sql = "DELETE FROM " . PROPERTY_AMENITIES . " WHERE 1  AND id = " . $id;
                $this->_db->query($sql);
                $retVal = $this->_db->execute();
                if ($retVal) {
                    $type = 'success';
                    $msg = 'Amenities Data Successfully Deleted';
                } else {
                    $type = 'error';
                    $msg = 'Error In deleting Amenities Data';
                }
            } else {
                $type = 'error';
                $msg = 'Error In deleting Amenities Data';
            }
        } else {
            $type = 'error';
            $msg = 'Error In deleting Amenities Data';
        }
        set_session_alert($type, $msg);
        redirect(ADMIN_URL . 'property/amenities');
    }
    /* Properties Amenities end */


    /* Properties Reviews start */
    public function reviews()
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        $limit = isset($_GET['page_limit']) ?  $_GET['page_limit'] :  50;
        $page_num = isset($_GET['page_num']) ? $_GET['page_num'] : 1;
        $startAt = ($limit * ($page_num - 1));
        $live_data_list =  $live_data_pagination = [];
        $sql = "SELECT count(*) as count FROM " . PROPERTY_REVIEWS . " WHERE 1";
        $this->_db->query($sql);
        $live_data = $this->_db->single();
        $live_data_count = $live_data['count'];
        if ($live_data_count > 0) {
            $page_num = isset($_GET['page_num']) ? $_GET['page_num'] : 1;
            $startAt = ($limit * ($page_num - 1));
            $sql = "SELECT * FROM " . PROPERTY_REVIEWS . " WHERE 1  ORDER BY id DESC LIMIT " .  $startAt . ',' . $limit;
            $this->_db->query($sql);
            $live_data_list = $this->_db->getAll();
            $live_data_pagination  = new Pagination($live_data_count, $page_num, $limit, $startAt);
        }

        $this->_view->setVal('start_counter',  $startAt);
        $this->_view->setVal('reviews_data',  $live_data);
        $this->_view->setVal('reviews_count',  $live_data_count);
        $this->_view->setVal('reviews_list',  $live_data_list);
        $this->_view->setVal('reviews_pagination',  $live_data_pagination);
        $this->_view->setVal('meta_title', 'Reviews Page');
        $this->_view->setVal('meta_description', 'Reviews Page');
        $this->_view->setVal('meta_keyword', 'Reviews Page');
        $this->_view->renderAdmin('reviews/reviews-list');
    }

    public function manageReviews($id = null)
    {
        $user_id = SESSION::get('uId');

        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        if (!empty($id)) {
            $id = decryptData($id);
            $edit_id = $id;
            if ($edit_id > 0) {
                $sql = "SELECT * FROM " . PROPERTY_REVIEWS . " WHERE 1 AND id  = " . $id;
                $this->_db->query($sql);
                $res = $this->_db->single();
                $this->_view->setVal('reviewData', $res);
                $label = 'Edit Reviews';
            } else {
                set_session_alert('error', 'Invalid Data');
                redirect(ADMIN_URL . 'property/reviews');
            }
        } else {
            $label = 'Add Reviews';
        }

        $this->_view->setVal('title', $label);
        $this->_view->setVal('meta_title',   $label);
        $this->_view->setVal('meta_description',   $label);
        $this->_view->setVal('meta_keyword',  $label);
        $this->_view->renderAdmin('reviews/reviews-data');
    }

    public function saveReviews()
    {
        $name = $_POST['name'];
        $email = $_POST['email'];
        $title = $_POST['title'];
        $desc = $_POST['desc'];
        $stay_date = $_POST['stay_date'];
        $status = $_POST['status'];
        $star = $_POST['star'];
        $id = $_POST['id'] ?? '';
        $data = [
            'name' => htmlspecialchars($name),
            'email' => htmlspecialchars($email),
            'title' => htmlspecialchars($title),
            'description' => htmlspecialchars($desc),
            'staydate' => date('Y-m-d h:i:s', strtotime($stay_date)),
            'status' => $status,
            'star' => $star,
        ];
        if (!empty($id)) {
            $data['updated_date'] =  date('Y-m-d h:i:s');
            $update_colum = '';
            $updated_colum_keys = array_keys($data);
            foreach ($data as $uk => $uv) {
                if ($uk != end($updated_colum_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $update_colum .= $uk . " = '" . $uv . "'" . $separator;
            }

            $sql = "UPDATE " . PROPERTY_REVIEWS . " SET " . $update_colum . " WHERE id = " . $id;
            $mode = 'Updated';
            $url = 'manage-reviews/' . encryptData($id);
        } else {
            $data['added_date'] =  date('Y-m-d h:i:s');
            $url = 'manage-reviews';
            $insert_bind_colum = '';
            $insert_colum_keys = array_keys($data);
            $insert_colum =  implode(',', $insert_colum_keys);
            foreach ($data as $uk => $uv) {
                if ($uk != end($insert_colum_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $insert_bind_colum .= "'" . $uv . "'" . $separator;
            }
            $sql = " INSERT INTO " . PROPERTY_REVIEWS . " ( " .  $insert_colum . ") VALUES (" . $insert_bind_colum . ")";
            $mode = 'Saved';
        }

        $type = "error";
        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {
            $type = 'success';
            $msg = 'Reviews Data Successfully ' . $mode;
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Reviews Data!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'property/' . $url);
    }

    public function deleteReviews($id)
    {
        $id = decryptData($id);
        $retVal = false;
        if ($id > 0) {
            $sql = "SELECT * FROM " . PROPERTY_REVIEWS . " WHERE 1  AND id  = " . $id;
            $this->_db->query($sql);
            $res = $this->_db->single();
            if (isset($res)) {
                $sql = "DELETE FROM " . PROPERTY_REVIEWS . " WHERE 1  AND id = " . $id;
                $this->_db->query($sql);
                $retVal = $this->_db->execute();
                if ($retVal) {
                    $type = 'success';
                    $msg = 'Reviews Data Successfully Deleted';
                } else {
                    $type = 'error';
                    $msg = 'Error In deleting Reviews Data';
                }
            } else {
                $type = 'error';
                $msg = 'Error In deleting Reviews Data';
            }
        } else {
            $type = 'error';
            $msg = 'Error In deleting Reviews Data';
        }
        set_session_alert($type, $msg);
        redirect(ADMIN_URL . 'property/reviews');
    }
    /* Properties Reviews end */


    /* Properties Gallery start */
    public function gallery()
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        $sql = "SELECT * FROM " . PROPERTY_GALLERY_LIST . " WHERE 1  ORDER BY id DESC";
        $this->_db->query($sql);
        $live_data_list = $this->_db->getAll();
        $this->_view->setVal('gallery_list',  $live_data_list);
        $this->_view->setVal('meta_title', 'Gallery Page');
        $this->_view->setVal('meta_description', 'Gallery Page');
        $this->_view->setVal('meta_keyword', 'Gallery Page');
        $this->_view->renderAdmin('gallery');
    }

    public function saveGallery()
    {
        $directory_path = UPLOAD_ROOT . 'gallery/';
        //Declaring Path for uploaded images
        if (count($_FILES['gallery']['name']) <= 10) {
            for ($i = 0; $i < count($_FILES['gallery']['name']); $i++) {
                //loop to get individual element from the arrayx

                $validExtensions = array("jpeg", "jpg", "png");
                //Extensions which are allowed
                $ext = explode('.', basename($_FILES['gallery']['name'][$i]));
                //explode file name from dot(.) 
                $file_extension = end($ext);
                //store extensions in the variable
                $files_name = md5(uniqid()) . "_image" . "." . $ext[count($ext) - 1];
                $target_path = $directory_path . $files_name;
                //set the target path with a new name of image
                //increment the number of uploaded images according to the files in array  
                if (in_array($file_extension, $validExtensions)) {
                    if (($_FILES["gallery"]["size"][$i] < 6291456)) {
                        //if file was not moved.
                        if (move_uploaded_file($_FILES['gallery']['tmp_name'][$i], $target_path)) {
                            //if file moved to uploads folder
                            $sql = "INSERT INTO " . PROPERTY_GALLERY_LIST . "(image,created_at) VALUES ('$files_name','" . date('Y-m-d h:i:s') . "')";
                            $this->_db->query($sql);
                            $result_gallery = $this->_db->execute();
                            if ($result_gallery) {
                                $type[]  = "success";
                                $msg[] = "Property Gallery Added Successfully.!!";
                            } else {
                                $type[]  = "error";
                                $msg[] = "Unable to upload Gallery.!!";
                            }
                        } else {
                            $type[]  = "error";
                            $msg[] = "Unable to upload Gallery.!!";
                        }
                    } else {
                        $type[]  = "error";
                        $msg[] = $_FILES['gallery']['name'][$i] . " Image must be less then 6mb!!";
                    }
                } else {
                    $type[]  = "error";
                    $msg[] = $_FILES['gallery']['name'][$i] . " Image must be jpeg, jpg, png in format!!";
                }
            }
        } else {
            $type[]  = "error";
            $msg[] = "Maximum 10 Images should be uploaded.";
        }

        foreach ($msg as $k => $v) {
            set_session_alert($type[$k], $v);
        }

        redirect(ADMIN_URL . 'property/gallery');
    }

    public function deleteGallery($id)
    {
        $id = decryptData($id);
        if ($id > 0) {
            $sql = "SELECT * FROM " . PROPERTY_GALLERY_LIST . " WHERE id = " . $id;
            $this->_db->query($sql);
            $result_gallery = $this->_db->single();

            if (isset($result_gallery)) {
                $sql = "DELETE FROM " . PROPERTY_GALLERY_LIST . " WHERE id = " . $id;
                $this->_db->query($sql);
                $result =   $this->_db->execute();
                if ($result) {
                    $directory_path = UPLOAD_ROOT . 'gallery/';
                    if (!empty($result_gallery['pgl_image'])) {
                        unlink($directory_path . $result_gallery['pgl_image']);
                    }
                    $type = "success";
                    $msg = "Property Gallery Deleted Successfully!";
                } else {
                    $type = "error";
                    $msg = "Unable to Delete Property Gallery !";
                }
            } else {
                $type = "error";
                $msg = "Unable to Delete Property Gallery !";
            }
        } else {
            $type = "error";
            $msg = "Unable to Delete Property Gallery!";
        }

        set_session_alert($type, $msg);
        redirect(ADMIN_URL . 'property/gallery');
    }
    /* Properties Gallery end */


    /* Properties Calender start */
    public function calender()
    {

        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }
        $sql = "SELECT * FROM " . PROPERTY_BOOKING_DATES . " WHERE 1 ";
        $this->_db->query($sql);
        $data_calendar = $this->_db->getAll();
        $calendar = [];
        foreach ($data_calendar as $val) {
            $calendar[] = array(
                'id'     => intval($val['id']),
                'title' => $val['title'],
                'description' => trim($val['description']),
                'start' => date_format(date_create(date("Y-m-d", $val['startdate'])), "Y-m-d H:i:s"),
                'end'     => date_format(date_create(date("Y-m-d", strtotime('+1 day', $val['enddate']))), "Y-m-d H:i:s"),
                'color' => $val['color'],
            );
        }

        $this->_view->setVal('calendar',  $calendar);
        $this->_view->setVal('meta_title', 'Calender Page');
        $this->_view->setVal('meta_description', 'Calender Page');
        $this->_view->setVal('meta_keyword', 'Calender Page');
        $this->_view->renderAdmin('property-calender');
    }

    public function importCalender()
    {
        $insertCount = $updateCount = $rowCount = $notAddCount = 0;
        if (is_uploaded_file($_FILES['file']['tmp_name'])) {
            $csvFile = $_FILES['file']['tmp_name'];
            $file = fopen($csvFile, "r");
            $csvData = [];
            while (!feof($file)) {
                $data =  fgetcsv($file);
                if (!empty($data)) {
                    $csvData[] = $data;
                }
            }
            fclose($file);
            unset($csvData[0]);

            if (!empty($csvData)) {
                foreach ($csvData as $row) {
                    $rowCount++;
                    $sql = "INSERT INTO " . PROPERTY_BOOKING_DATES . "(startdate, enddate, type, calid, title, added_date)
                            VALUES ('" . strtotime($row[0]) . "', '" . strtotime($row[1]) . "', 'insert', '0', 'Added by CSV', '" . date("Y-m-d") . "')";
                    $this->_db->query($sql);
                    $results = $this->_db->execute();
                    $insertCount++;
                }
            }
            if ($insertCount) {
                $type  = "success";
                $notAddCount = ($rowCount - ($insertCount + $updateCount));
                $msg = 'Calendar imported successfully. Total Rows (' . $rowCount . ') | Inserted (' . $insertCount . ') | Not Inserted (' . $notAddCount . ')';
            } else {
                $type  =  "error";
                $msg =  "Error on file upload, please try again.";
            }
        } else {
            $type  =  "error";
            $msg =  "Please Select File to upload";
        }
        set_session_alert($type, $msg);
        redirect(ADMIN_URL . 'property/calender');
    }

    public function syncCalUrl()
    {
        $up['calurl'] = $_POST['calurl'];
        $up['type'] = "ical";
        $up['calid'] = $_POST['calid'];

        $sql = "SELECT * FROM " . CAL_URLS . " WHERE 1 AND 1 AND calid = " . $_POST['calid'];
        $this->_db->query($sql);
        $property_data = $this->_db->single();
        if (!empty($property_data)) {
            $sql = "UPDATE " . CAL_URLS . " SET calurl = '" . $_POST['calurl'] . "' , updated_date = '" . date("Y-m-d") . "' WHERE 1 AND calid = " . $_POST['calid'];
            $this->_db->query($sql);
            $results = $this->_db->execute();
            if ($results) {
                $result_data['status'] = 'success';
            } else {
                $result_data['status'] = 'error';
            }
        } else {
            $sql = "INSERT INTO " . CAL_URLS . "(calurl, type,calid, added_date) VALUES ('" . $_POST['calurl'] . "', 'ical', '" . $_POST['calid'] . "', '" . date("Y-m-d") . "')";
            $this->_db->query($sql);
            $results = $this->_db->execute();
            if ($results) {
                $result_data['status'] = 'success';
            } else {
                $result_data['status'] = 'error';
            }
        }

        if ($result_data['status'] == "success") {
            $calid = $_POST['calid'];
            try {
                $ical_url = $_POST['calurl'];
                $ctx = stream_context_create(
                    array(
                        'http' => array(
                            'method' => 'GET',
                            'header' => 'User-Agent: Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko'
                        )
                    )
                );
                $gettextstr = @file_get_contents($ical_url, false, $ctx);
                $calender =  new iCalendar();
                $result = $calender->parsestr($gettextstr);
            } catch (Exception $e) {
                echo 'Caught exception: ',  $e->getMessage(), "\n";
            }

            if (isset($result['VEVENT'])) {
                $counttt = count($result['VEVENT']);
            } else {
                $res['status'] = 'error';
                $res['msg'] = 'Empty Records';
            }

            if (!empty($result['VEVENT'])) {

                $sql = "DELETE FROM " . PROPERTY_BOOKING_DATES . " WHERE 1 AND calid = " . $_POST['calid'];
                $this->_db->query($sql);
                $results = $this->_db->execute();

                foreach ($result['VEVENT'] as $vEVENT) {
                    if (isset($vEVENT['DTSTART;VALUE=DATE'])) {
                        $sql = "INSERT INTO " . PROPERTY_BOOKING_DATES . "(startdate, enddate,added_date, type,calid) VALUES ('" . $vEVENT['DTSTART;VALUE=DATE'] . "', '" . $vEVENT['DTEND;VALUE=DATE'] . "','" . date('Y-m-d') . "','ical','" . $calid . "')";
                    } else {
                        $sql = "INSERT INTO " . PROPERTY_BOOKING_DATES . "(startdate, enddate,added_date, type,calid) VALUES ('" . $vEVENT['DTSTART'] . "', '" . $vEVENT['DTEND'] . "','" . date('Y-m-d') . "','ical','" . $calid . "')";
                    }
                    $this->_db->query($sql);
                    $results = $this->_db->execute();
                }
                $res['status'] = 'sucess';
                $res['msg'] =  $counttt . " records imported successfully.";
            } else {
                $res['status'] = 'error';
                $res['msg'] = 'Please Provide a Valid Calendar Link.';
            }
        } else {
            $res['status'] = 'error';
            $res['msg'] = 'Something went wrong';
        }
        echo json_encode($res);
        exit;
    }
    /* Properties Calender end */

    /* Properties Rates start */

    public function rates($id = '')
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        if ($id > 0) {
            $id = decryptData($id);
            $sql = "SELECT * FROM " . PROPERTY_RATES . " WHERE 1 AND id = " . $id;
            $this->_db->query($sql);
            $property_rates_edit = $this->_db->single();
            $this->_view->setVal('property_rates_edit',  $property_rates_edit);
            $this->_view->setVal('label',  'Edit');
        } else {
            $this->_view->setVal('label',  'Add');
        }

        $sql = "SELECT id, rate_note,check_in_time,check_out_time, admin_fee, cleaning_fee, refundable_damage_deposit_fee, damage_waiver_fee, pet_fee, extra_person_fee, tax, service_fee, change_over, pool_heating_fee FROM " . PROPERTY_LIST . " WHERE 1 AND id = 1";
        $this->_db->query($sql);
        $property_data = $this->_db->single();
        $this->_view->setVal('property_data', $property_data);


        $rates_data_list =  $rates_data_pagination = [];
        $sql = "SELECT count(*) as count FROM " . PROPERTY_RATES . " WHERE 1 ";
        $this->_db->query($sql);
        $rates_data = $this->_db->single();
        $rates_data_count = $rates_data['count'];
        $limit = isset($_GET['page_limit']) ?  $_GET['page_limit'] :  50;
        $page_num = isset($_GET['page_num']) ? $_GET['page_num'] : 1;
        $startAt = ($limit * ($page_num - 1));
        if ($rates_data_count > 0) {
            $sql = "SELECT * FROM " . PROPERTY_RATES . " WHERE 1  LIMIT " .  $startAt . ',' . $limit;
            $this->_db->query($sql);
            $rates_data_list = $this->_db->getAll();
            $rates_data_pagination  = new Pagination($rates_data_count, $page_num, $limit, $startAt);
        }

        $this->_view->setVal('start_counter',  $startAt);
        $this->_view->setVal('rates_data',  $rates_data);
        $this->_view->setVal('property_rates_count',  $rates_data_count);
        $this->_view->setVal('property_rates_list',  $rates_data_list);
        $this->_view->setVal('property_rates_pagination',  $rates_data_pagination);
        $this->_view->setVal('meta_title', 'Rates Page');
        $this->_view->setVal('meta_description', 'Rates Page');
        $this->_view->setVal('meta_keyword', 'Rates Page');
        $this->_view->renderAdmin('rates-data');
    }

    public function importRates()
    {

        $insertCount = $updateCount = $rowCount = $notAddCount = 0;
        if (is_uploaded_file($_FILES['file']['tmp_name'])) {
            $csvFile = $_FILES['file']['tmp_name'];
            $file = fopen($csvFile, "r");
            $csvData = [];
            while (!feof($file)) {
                $data = fgetcsv($file);
                if (!empty($data)) {
                    $csvData[] =   $data;
                }
            }
            fclose($file);

            unset($csvData[0]);

            if (!empty($csvData)) {
                foreach ($csvData as $row) {
                    $rowCount++;
                    $sql = "INSERT INTO " . PROPERTY_RATES . "(seasonname,fromdate, todate, nightly, weekly, added_date)
                            VALUES ('" . $row[0] . "', '" . date('Y-m-d', strtotime($row[1])) . "', '" . date('Y-m-d', strtotime($row[2]))  . "', '" . $row[3] . "', '" . $row[4] . "', '" . date("Y-m-d") . "')";
                    $this->_db->query($sql);
                    $results = $this->_db->execute();
                    $insertCount++;
                }
            }
            if ($insertCount) {
                $type  = "success";
                $notAddCount = ($rowCount - ($insertCount + $updateCount));
                $msg = 'Calendar imported successfully. Total Rows (' . $rowCount . ') | Inserted (' . $insertCount . ') | Not Inserted (' . $notAddCount . ')';
            } else {
                $type  =  "error";
                $msg =  "Error on file upload, please try again.";
            }
        } else {
            $type  =  "error";
            $msg =  "Please Select File to upload";
        }
        set_session_alert($type, $msg);
        redirect(ADMIN_URL . 'property/rates');
    }

    public function saveRates()
    {
        $id = $_POST['id'] ?? '';
        $name = $_POST['name'];
        $from = $_POST['from'];
        $to = $_POST['to'];
        $persons = $_POST['person'];
        $stay = $_POST['stay_night'];
        $weekend = $_POST['weekend'];
        $monthly = $_POST['monthly'];
        $night = $_POST['night'];
        $week = $_POST['week'];

        $data = [
            'seasonname' => htmlspecialchars($name),
            'fromdate' => date('Y-m-d', strtotime($from)),
            'todate' => date('Y-m-d', strtotime($to)),
            'minimumstay' => htmlspecialchars($stay),
            'minimumpersons' => htmlspecialchars($persons),
            'weekend' => htmlspecialchars($weekend),
            'monthly' => htmlspecialchars($monthly),
            'nightly' => htmlspecialchars($night),
            'weekly' => htmlspecialchars($week),
        ];
        if (!empty($id)) {
            $data['updated_date'] =  date('Y-m-d h:i:s');
            $update_colum = '';
            $updated_colum_keys = array_keys($data);
            foreach ($data as $uk => $uv) {
                if ($uk != end($updated_colum_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $update_colum .= $uk . " = '" . $uv . "'" . $separator;
            }
            $sql = "UPDATE " . PROPERTY_RATES . " SET " . $update_colum . " WHERE id = " . $id;
            $mode = 'Updated';
            $url =  '/' . encryptData($id);
        } else {
            $data['added_date'] =  date('Y-m-d h:i:s');
            $url = '';
            $insert_bind_colum = '';
            $insert_colum_keys = array_keys($data);
            $insert_colum =  implode(',', $insert_colum_keys);
            foreach ($data as $uk => $uv) {
                if ($uk != end($insert_colum_keys)) {
                    $separator = ',';
                } else {
                    $separator = '';
                }
                $insert_bind_colum .= "'" . $uv . "'" . $separator;
            }
            $sql = " INSERT INTO " . PROPERTY_RATES . " ( " .  $insert_colum . ") VALUES (" . $insert_bind_colum . ")";
            $mode = 'Saved';
        }

        $type = "error";
        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {
            $type = 'success';
            $msg = 'Rates Data Successfully ' . $mode;
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Rates Data!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'property/rates' . $url);
    }

    public function saveAdditionalRates()
    {

        $note = $_POST['note'];
        $check_in = $_POST['check_in_time'];
        $check_out = $_POST['check_out_time'];
        $admin_fee = $_POST['admin_fee'];
        $cleaning_fee = $_POST['cleaning_fee'];
        $refundable_damage_deposit_fee = $_POST['refundable_damage_deposit_fee'];
        $damage_waiver_fee = $_POST['damage_waiver_fee'];
        $pet_fee = $_POST['pet_fee'];
        $extra_person_fee = $_POST['extra_person_fee'];
        $tax = $_POST['tax'];
        $service_fee = $_POST['service_fee'];
        $change_over = $_POST['change_over'];
        $pool_heating_fee = $_POST['pool_heating_fee'];

        $data = [
            'check_in_time' => $check_in,
            'check_out_time' => $check_out,
            'admin_fee' => $admin_fee,
            'cleaning_fee' => $cleaning_fee,
            'refundable_damage_deposit_fee' => $refundable_damage_deposit_fee,
            'damage_waiver_fee' => $damage_waiver_fee,
            'pet_fee' => $pet_fee,
            'extra_person_fee' => $extra_person_fee,
            'tax' => $tax,
            'service_fee' => $service_fee,
            'change_over' => $change_over,
            'pool_heating_fee' => $pool_heating_fee,
            'rate_note' => $note,
        ];

        $data['updated_on'] =  date('Y-m-d h:i:s');
        $update_coloum = '';
        $updated_coloms_keys = array_keys($data);
        foreach ($data as $uk => $uv) {
            if ($uk != end($updated_coloms_keys)) {
                $separator = ',';
            } else {
                $separator = '';
            }
            $update_coloum .= $uk . " = '" . $uv . "'" . $separator;
        }

        $sql = "UPDATE " . PROPERTY_LIST . " SET " . $update_coloum . " WHERE id = 1";
        $mode = 'Updated';
        $type   = "error";
        try {
            $this->_db->query($sql);
            $results = $this->_db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }

        if ($results) {

            $type = 'success';
            $msg = 'Additional Rates Successfully ' . $mode;
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Additional Rates!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'property/rates');
    }

    public function deleteRates($id)
    {
        $id = decryptData($id);
        $retVal = false;
        if ($id > 0) {
            $sql = "SELECT * FROM " . PROPERTY_RATES . " WHERE 1  AND id  = " . $id;
            $this->_db->query($sql);
            $res = $this->_db->single();
            if (isset($res)) {
                $sql = "DELETE FROM " . PROPERTY_RATES . " WHERE 1  AND id = " . $id;
                $this->_db->query($sql);
                $retVal = $this->_db->execute();
                if ($retVal) {
                    $type = 'success';
                    $msg = 'Rates Data Successfully Deleted';
                } else {
                    $type = 'error';
                    $msg = 'Error In deleting Rates Data';
                }
            } else {
                $type = 'error';
                $msg = 'Error In deleting Rates Data';
            }
        } else {
            $type = 'error';
            $msg = 'Error In deleting Rates Data';
        }
        set_session_alert($type, $msg);
        redirect(ADMIN_URL . 'property/rates');
    }
    /* Properties Rates end */


    public function enquiries()
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }

        $enquiries_list =  $enquiries_data_pagination = [];
        $sql = "SELECT count(*) as count FROM " . PROPERTY_ENQUIRES . " WHERE 1 ";
        $this->_db->query($sql);
        $enquiries_data = $this->_db->single();
        $enquiries_data_count = $enquiries_data['count'];
        $limit = isset($_GET['page_limit']) ?  $_GET['page_limit'] :  50;
        $page_num = isset($_GET['page_num']) ? $_GET['page_num'] : 1;
        $startAt = ($limit * ($page_num - 1));
        if ($enquiries_data_count > 0) {
            $sql = "SELECT * FROM " . PROPERTY_ENQUIRES . " WHERE 1  LIMIT " .  $startAt . ',' . $limit;
            $this->_db->query($sql);
            $enquiries_list = $this->_db->getAll();
            $enquiries_data_pagination  = new Pagination($enquiries_data_count, $page_num, $limit, $startAt);
        }

        $this->_view->setVal('enquiries_count',  $enquiries_data_count);
        $this->_view->setVal('enquiries_list',  $enquiries_list);

        $this->_view->setVal('enquiries_pagination',  $enquiries_data_pagination);

        $this->_view->setVal('meta_title', 'Enquiries Page');

        $this->_view->setVal('meta_description', 'Enquiries Page');

        $this->_view->setVal('meta_keyword', 'Enquiries Page');
        $this->_view->renderAdmin('property-enquiries-list');
    }
}
