<?php



class Pagination

{



    private $_page_num;

    private $_records_per_page;

    private $_lower_limit;

    private $_total_records;

    private $_total_pages;

    private $_adjacent = 2;

    private $_start_counter;



    public function __construct($total_records, $page_num = 1, $rpp = 10, $start = 1)

    {

        $this->_start_counter = $start + 1;

        if (!(isset($page_num))) {



            $this->_page_num = 1;

        } else {



            $this->_page_num = $page_num;

        }

        $this->_records_per_page = ($rpp <> "" && is_numeric($rpp)) ? $rpp : 10;

        $this->_total_records = intval($total_records);



        //Calculate the last page based on total number of rows and rows per page.



        $this->_total_pages = ceil($this->_total_records / $this->_records_per_page);

        $this->setPageNum();

    }



    private function setPageNum()

    {



        if ($this->_page_num < 1) {



            $this->_page_num = 1;

        } elseif ($this->_page_num > $this->_total_pages) {



            $this->_page_num = $this->_total_pages;

        }



        $this->_page_num = intval($this->_page_num);



        $this->_lower_limit = ($this->_page_num - 1) * $this->_records_per_page;



        // incase lower limits goes to below zero

        $this->_lower_limit = ($this->_lower_limit < 0) ? 0 : $this->_lower_limit;

    }



    public function showTotalRecord()

    {

        echo 'Showing ' . $this->_start_counter . ' to ' . $this->_records_per_page . ' of ' . $this->_total_records;

    }





    public function displayLinks($page_name)

    {



        if ($this->_total_pages > 0) {



            echo '<div class="d-flex align-items-center justify-content-end flex-wrap">';

            echo '<nav aria-label="Page navigation example mb-2">';

            echo '<ul class="pagination mb-2 mb-sm-0">';

            if ($this->_page_num > 1) {

                echo '<li class="page-item"><a class="page-link"  href="' . $page_name . '?page_num=1">First</a></li>';

                // echo '<li class="page-item"><a class="page-link"  href="' . $page_name . '?page_num=' . ($this->_page_num - 1) . '"><i class="fa fa-arrow-left"></i></a></li>';

            }

            if ($this->_total_pages < 7 + ($this->_adjacent * 2)) {

                for ($i = 1; $i <= $this->_total_pages; $i++) {

                    if ($i == $this->_page_num) {

                        echo '<li class="active page-item"><a class="page-link" href="javascript:void(0);">' . $i . '</a></li>';

                    } else {

                        echo '<li class="page-item"><a class="page-link"  href="' . $page_name . '?page_num=' . $i . '">' . $i . '</a></li>';

                    }

                }

            } else if ($this->_total_pages > 5 + ($this->_adjacent * 2)) {

                if ($this->_page_num < 1 + ($this->_adjacent * 2)) {

                    for ($i = 1; $i <= 4 + ($this->_adjacent * 2); $i++) {

                        if ($i == $this->_page_num) {

                            echo '<li class="active page-item"><a class="page-link" href="javascript:void(0);">' . $i . '</a></li>';

                        } else {

                            echo '<li class="page-item"><a class="page-link"  href="' . $page_name . '?page_num=' . $i . '">' . $i . '</a></li>';

                        }

                    }

                    echo '<li class="page-item"><span>...</span></li>';

                } elseif ($this->_total_pages - ($this->_adjacent * 2) > $this->_page_num && $this->_page_num > ($this->_adjacent * 2)) {

                    echo '<li class="page-item"><a class="page-link"  href="' . $page_name . '?page_num=1">1</a></li>';

                    echo '<li class="page-item"><a class="page-link" href="' . $page_name . '?page_num=2">2</a></li>';

                    echo '<li class="page-item"><span>...</span></li>';

                    for ($i = $this->_page_num - $this->_adjacent; $i <= ($this->_page_num + $this->_adjacent); $i++) {

                        if ($i == $this->_page_num) {

                            echo '<li class="active page-item"><a class="page-link"  href="javascript:void(0);">' . $i . '</a></li>';

                        } else {

                            echo '<li class="page-item"><a class="page-link" href="' . $page_name . '?page_num=' . $i . '">' . $i . '</a></li>';

                        }

                    }

                } else {

                    echo '<li class="page-item"><a class="page-link"  href="' . $page_name . '?page_num=1">1</a></li>';

                    echo '<li class="page-item"><a class="page-link"  href="' . $page_name . '?page_num=2">2</a></li>';

                    echo '<li class="page-item"><span>...</span></li>';

                    for ($i = $this->_total_pages - (2 + ($this->_adjacent * 2)); $i <= $this->_total_pages; $i++) {

                        if ($i == $this->_page_num) {

                            echo '<li class="active page-item"><a class="page-link"  href="javascript:void(0);">' . $i . '</a></li>';

                        } else {

                            echo '<li class="page-item"><a class="page-link" href="' . $page_name . '?page_num=' . $i . '">' . $i . '</a></li>';

                        }

                    }

                }

            }

            // if (($this->_page_num + 1) <= $this->_total_pages) {

            //     echo '<li class="page-item"><a class="page-link"  href="' . $page_name . '?page_num=' . ($this->_page_num + 1) . '"><i class="fa fa-arrow-right"></i></a></li>';

            // }

            if ($this->_page_num != $this->_total_pages) {

                echo '<li class="page-item"><a class="page-link"  href="' . $page_name . '?page_num=' . ($this->_total_pages) . '">Last</a></li>';

            }

            echo '</div>';

            echo '</div>';

            echo '</div>';

        }

    }



    public function displayAjaxLinks($class_name = 'paging_numbers')

    {

        if ($this->_total_pages > 0) {

            if ($this->_page_num > 1) {

                echo '<li><a href="javascript:void(0);" data-val="' . ($this->_page_num - 1) . '" class="' . $class_name . '"><i class="fa fa-arrow-left"></i></a></li>';

            }

            if ($this->_total_pages < 7 + ($this->_adjacent * 2)) {

                for ($i = 1; $i <= $this->_total_pages; $i++) {

                    $sel_class = ($i == $this->_page_num) ? ' active non' : '';

                    echo '<li><a href="javascript:void(0);" data-val="' . ($i) . '" class="' . $class_name . $sel_class . '">' . $i . '</a></li>';

                }

            } else if ($this->_total_pages > 5 + ($this->_adjacent * 2)) {

                if ($this->_page_num < 1 + ($this->_adjacent * 2)) {

                    for ($i = 1; $i <= 4 + ($this->_adjacent * 2); $i++) {

                        $sel_class = ($i == $this->_page_num) ? ' active non' : '';

                        echo '<li><a href="javascript:void(0);" data-val="' . ($i) . '" class="' . $class_name . $sel_class . '">' . $i . '</a></li>';

                    }

                    echo "<li><span>...</span></li>";

                } elseif ($this->_total_pages - ($this->_adjacent * 2) > $this->_page_num && $this->_page_num > ($this->_adjacent * 2)) {

                    echo '<li><a href="javascript:void(0);" data-val="' . (1) . '" class="' . $class_name . '">1</a></li>';

                    echo '<li><a href="javascript:void(0);" data-val="' . (2) . '" class="' . $class_name . '">2</a></li>';

                    echo "<li><span>...</span></li>";

                    for ($i = $this->_page_num - $this->_adjacent; $i <= ($this->_page_num + $this->_adjacent); $i++) {

                        $sel_class = ($i == $this->_page_num) ? ' active non' : '';

                        echo '<li><a href="javascript:void(0);" data-val="' . ($i) . '" class="' . $class_name . $sel_class . '">' . $i . '</a></li>';

                    }

                } else {

                    echo '<li><a href="javascript:void(0);" data-val="' . (1) . '" class="' . $class_name . '">1</a></li>';

                    echo '<li><a href="javascript:void(0);" data-val="' . (2) . '" class="' . $class_name . '">2</a></li>';

                    echo "<li><span>...</span></li>";

                    for ($i = $this->_total_pages - (2 + ($this->_adjacent * 2)); $i <= $this->_total_pages; $i++) {

                        $sel_class = ($i == $this->_page_num) ? ' active non' : '';

                        echo '<li><a href="javascript:void(0);" data-val="' . ($i) . '" class="' . $class_name . $sel_class . '">' . $i . '</a></li>';

                    }

                }

            }

            if (($this->_page_num + 1) <= $this->_total_pages) {

                echo '<li><a href="javascript:void(0);" data-val="' . ($this->_page_num + 1) . '" class="' . $class_name . '"><i class="fa fa-arrow-right"></i></a></li>';

            }

            if ($this->_page_num != $this->_total_pages) {

                echo '<li><a href="javascript:void(0);" data-val="' . ($this->_total_pages) . '" class="' . $class_name . '">Last</a></li>';

            }

        }

    }





    public function startCounter()

    {

        return $this->_start_counter;

    }



    public function totalPages()

    {

        return $this->_total_pages;

    }



    public function getLowerLimit()

    {

        return $this->_lower_limit;

    }



    public function getPageNumber()

    {

        return $this->_page_num;

    }



    public function totalRecords()

    {

        return $this->_total_records;

    }



    public function setTotalRecords($count)

    {

        return $this->_total_records = $count;

    }



    public function recordsPerPage()

    {

        return $this->_records_per_page;

    }

}

