<div class="page-titles">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
        <li class="breadcrumb-item active"><a href="javascript:void(0)">Slider List</a></li>
    </ol>
</div>
<!-- row -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Slider List</h4>
                <h4><a href="<?= ADMIN_URL . 'slider/manage' ?>" class="btn btn-success">Add Slider</a></h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display table" style="min-width: 850px">
                        <thead>
                            <tr>
                                <td>#</td>
                                <th>Image</th>
                                <th>Title </th>
                                <th>Status</th>
                                <th>Added Date</th>
                                <th>Updated Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($slider_data_count > 0) { ?>
                                <?php foreach ($slider_data_list as $ev) { ?>
                                    <tr>
                                        <td><?= ++$start_counter; ?></td>
                                        <td><?php echo !empty($ev['image']) ? '<img src="' . UPLOAD_URL . 'slider/' . $ev['image'] . '" class="img img-fluid img-responsive" style="height:100px;width:100px;">' : ''; ?></td>
                                        <td><?php echo $ev['title']; ?></td>
                                        <td><?php echo ($ev['status'] == 1 ? 'Active' : 'Inactive'); ?></td>
                                        <td><?php echo !empty($ev['created_at']) ? date('d,M Y h:s A', strtotime($ev['created_at'])) : ''; ?></td>
                                        <td><?php echo !empty($ev['updated_at']) ? date('d,M Y h:s A', strtotime($ev['updated_at'])) : ''; ?></td>
                                        <td>
                                            <a href="<?= ADMIN_URL . 'slider/manage/' . encryptData($ev['id']) ?>" class="btn btn-success btn-sm"><i class="fa fa-pencil"></i> Edit</a>
                                            <a href="javascript:void(0);" onclick="deleteData(this)" data-href="<?= ADMIN_URL . 'slider/delete/' . encryptData($ev['id']) ?>" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i> Delete</a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            <?php } else { ?>
                                <tr>
                                    <td colspan="7" class="text-center">No Records Found</td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>

                <?php if ($slider_data_count > 0) { ?>
                    <div class="col-lg-12">
                        <p class="mb-2 me-3">
                            <?= $slider_data_pagination->displayLinks(ADMIN_URL . 'slider'); ?>
                        </p>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" type="text/css" href="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.css">
<script src="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.js"></script>
<script>
    function deleteData(_this) {
        let url = $(_this).attr('data-href');
        new swal({
            title: 'Are you sure?',
            text: "It will permanently deleted !",
            type: 'danger',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            } else if (result.isDenied) {}
        })
    }
</script>