<link rel="stylesheet" type="text/css" href="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.css">
<script src="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.js"></script>
<div class="hero_carosel owl-carousel owl-theme">
    <?php foreach ($slider_list as $sv) { ?>
        <div class="item">
            <div class="hero-img">
                <img src="<?= SITE_URL . 'public/images/slider/' . $sv['image'] ?>" alt="<?= $sv['title'] ?>">
            </div>
            <div class="desc">
                <h2><?= $sv['title'] ?></h2>
            </div>
        </div>
    <?php } ?>
</div>


<div id="features-block" class="container-fluid text-center">
    <div class="feature-div">
        <div class="features-box">
            <div class="logo-small">
                <i class="fa fa-home" aria-hidden="true"></i>
            </div>
            <div class="text-small">
                <h4><?= $property_type[$property_data['type']] ?? '' ?></h4>
            </div>
        </div>
    </div>

    <div class="feature-div">
        <div class="features-box">
            <div class="logo-small">
                <i aria-hidden="true" class="fa fa-bed"></i>
            </div>
            <div class="text-small">
                <h4><?= $property_data['beds'] ?? '' ?> Bedrooms</h4>
            </div>
        </div>
    </div>

    <div class="feature-div">
        <div class="features-box">
            <div class="logo-small">
                <i class="fa fa-bath" aria-hidden="true"></i>
            </div>
            <div class="text-small">
                <h4><?= $property_data['bath'] ?? '' ?> Bathrooms</h4>
            </div>
        </div>
    </div>

    <div class="feature-div">
        <div class="features-box">
            <div class="logo-small">
                <i class="fa fa-users" aria-hidden="true"></i>
            </div>
            <div class="text-small">
                <h4><?= $property_data['guest'] ?? '' ?> Guests</h4>
            </div>
        </div>
    </div>

    <div class="feature-div">
        <div class="features-box">
            <div class="logo-small">
                <i class="fa fa-moon-o" aria-hidden="true"></i>
            </div>
            <div class="text-small">
                <h4><?= $property_data['max_stay'] ?? '' ?> Night</h4>
            </div>
        </div>
    </div>
</div>

<div id="about" class=" text-center">
    <div class="container">
        <h3>
            About <?= $property_data['title'] ?? '' ?>
        </h3>
        <div class="text-left">
            <?= !empty($property_data['description']) ? html_entity_decode($property_data['description']) : '' ?>
        </div>
    </div>
</div>

<div id="about-us" class="container-fluid ">
    <div class="row">

        <div class="col-lg-6 col-md-6 col-sm-12">
            <div class="image-box">
                <img src="<?= SITE_URL . 'public/images/about_us/' . $page_data['image']; ?>" alt="" class="img img-responsive img-fluid">

            </div>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-12">
            <div class="about-us-content">
                <h3><?= $page_data['heading'] ?? '' ?></h3>
                <p><em>Great Location, Quiet, Beautiful and Comfortable Retreat</em></p>
                <?php if (!empty($page_data['description'])) { ?>
                    <div id="more-data">
                        <?= html_entity_decode($page_data['description']) ?>
                    </div>
                    <a href="javascript:void(0);" class="btn-gradient-bg" id="read-more">Read More</a>
                <?php } ?>
            </div>
        </div>
        <?php if (!empty($page_data['description_extra'])) { ?>
            <div id="less-more-data" style="display: none;">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <?= html_entity_decode($page_data['description_extra']) ?>
                </div>
                <a href="javascript:void(0);" class="btn-gradient-bg" id="read-less" style="display: none;">Read less</a>
            </div>
        <?php } ?>
    </div>
</div>


<div id="youtube-video" class="mt-5">
    <div class="container">
        <iframe width="100%" height="500" src="https://www.youtube.com/embed/<?= $property_data['video_id'] ?? '' ?>" title="" frameBorder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowFullScreen></iframe>
    </div>
</div>


<div id="amenities" class="container-fluid text-center">

    <h2>Amenities</h2>

    <div class="row">

        <div class="col-lg-3 col-md-4 col-sm-6">

            <div class="logo-small">

                <img src="<?= SITE_URL ?>public/assets/images/amenities/icon-beach-front.svg" class="img img-responsive ">

            </div>

            <div class="text-small">

                <h4>BEACH FRONT</h4>

            </div>

        </div>

        <div class="col-lg-3 col-md-4 col-sm-6">

            <div class="logo-small">

                <img src="<?= SITE_URL ?>public/assets/images/amenities/icon-golf.svg" class="img img-responsive">

            </div>

            <div class="text-small">

                <h4>GOLF SIMULATOR</h4>

            </div>

        </div>

        <div class="col-lg-3 col-md-4 col-sm-6">

            <div class="logo-small">

                <img src="<?= SITE_URL ?>public/assets/images/amenities/icon-gym.svg" class="img img-responsive">

            </div>

            <div class="text-small">

                <h4>GYM</h4>

            </div>

        </div>

        <div class="col-lg-3 col-md-4 col-sm-6">

            <div class="logo-small">

                <img src="<?= SITE_URL ?>public/assets/images/amenities/icon-infinity-pool.svg" class="img img-responsive">

            </div>

            <div class="text-small">

                <h4>INFINITY POOL</h4>

            </div>

        </div>

        <div class="col-lg-3 col-md-4 col-sm-6">

            <div class="logo-small">

                <img src="<?= SITE_URL ?>public/assets/images/amenities/icon-jacuzzi.svg" class="img img-responsive">

            </div>

            <div class="text-small">

                <h4>JACUZZI</h4>

            </div>

        </div>

        <div class="col-lg-3 col-md-4 col-sm-6">

            <div class="logo-small">

                <img src="<?= SITE_URL ?>public/assets/images/amenities/icon-movie-theatre.svg" class="img img-responsive">

            </div>

            <div class="text-small">

                <h4>MOVIE THEATRE</h4>

            </div>

        </div>

        <div class="col-lg-3 col-md-4 col-sm-6">

            <div class="logo-small">

                <img src="<?= SITE_URL ?>public/assets/images/amenities/icon-professional-staff.svg" class="img img-responsive">

            </div>

            <div class="text-small">

                <h4>PROFESSIONAL STAFF</h4>

            </div>

        </div>

        <div class="col-lg-3 col-md-4 col-sm-6">

            <div class="logo-small">

                <img src="<?= SITE_URL ?>public/assets/images/amenities/icon-tennis-court.svg" class="img img-responsive">

            </div>

            <div class="text-small">

                <h4>TENNIS COURT</h4>

            </div>

        </div>

    </div>

</div>


<div id="gallery" class=" text-center">
    <div class="container">
        <h2>Gallery</h2>

        <div class="row">

            <div class="carousel-wrap">

                <div class="owl-carousel" id="gallery-carousel">
                    <?php foreach ($gallery_list as $gv) { ?>
                        <div class="item"><img src="<?= SITE_URL . 'public/images/gallery/' . $gv['image'] ?>" class="img img-responsive img-fluid"></div>
                    <?php } ?>
                </div>

            </div>

        </div>
        <div class="padding-bottom-50">
            <a href="<?= SITE_URL . 'gallery'; ?>" class="btn-gradient-bg">Learn More</a>
        </div>
    </div>
</div>

<div id="contact-form">
    <div class="contact-row">
        <div id="inquiry-form" class="card">
            <div class="et_pb_module_inner">
                <div class="dcgd_gravity_divi_wrapper clearfix">
                    <h3 class="dcgd_title text-center">Contact</h3>
                    <form method="post" enctype="multipart/form-data" id="contact_form">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="first" class="form-label">First Name</label>
                                <input type="text" class="form-control" value="" id="first" name="first" placeholder="First Name">
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="Last" class="form-label">Last Name</label>
                                <input type="text" class="form-control" id="Last" value="" name="last" placeholder="Last Name">
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="email" class="form-label">Email Address</label>
                                <input type="email" class="form-control" id="email" value="" name="email" placeholder="Email Address">
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="phone" class="form-label">Phone Number</label>
                                <input type="tel" class="form-control" value="" id="phone" name="phone" placeholder="Phone Number">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="hear_us" class="form-label">How did you hear about us?</label>
                                <input type="text" class="form-control" name="hear_us" value="" id="hear_us" placeholder="Hear Us">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="message" class="form-label">Message</label>
                                <textarea type="text" class="form-control" name="message" id="message" value="" placeholder="Message"></textarea>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <button type="submit" class="btn btn-sm btn-success form-control">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).on('click', '#read-more', function() {
        $(this).hide();
        $('#less-more-data').show();
        $('#read-less').show();
    });

    $(document).on('click', '#read-less', function() {
        $(this).hide();
        $('#less-more-data').hide();
        $('#read-more').show();
    });


    $(document).on('submit', '#contact_form', function(e) {
        e.preventDefault();
        var form = $(this);
        $.ajax({
            type: "POST",
            url: '<?= SITE_URL . 'index/send-enquiry' ?>',
            data: form.serialize(), // serializes the form's elements.
            dataType: 'json',
            success: function(data) {
                if (data['status'] == 'success') {
                    setTimeout(function() {
                        new swal(data['msg']);
                    }, 1000);
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    setTimeout(function() {
                        new swal(data['msg']);
                    }, 1000);
                }

            }
        });
    });
</script>