<?php
require_once APP_DIR . 'libs/View.php';
require_once APP_DIR . 'libs/Input.php';
require_once APP_DIR . 'libs/Session.php';
require_once APP_DIR . 'models/AuthModel.php';
require_once APP_DIR . 'libs/Database.php';

class AboutUsController
{

    private $_view;
    private $_db;

    public function __construct()
    {
        check_login('index');
        $this->_view  = new View();
        $this->_db = new Database();
    }

    public function index()
    {

        $user_id = SESSION::get('uId');

        if (!empty($user_id)) {

            $authObj = new AuthModel();

            $login_user_data = $authObj->getUserDetails($user_id);

            $this->_view->setVal('login_user_data', $login_user_data);
        }


        $this->_db->query("SELECT * FROM " . PAGE_DATA . " WHERE id = 1");

        $res =  $this->_db->single();

        $this->_view->setVal('about_us',  $res);


        $this->_view->setVal('title', 'About Us Page');

        $this->_view->setVal('meta_title', 'About Us Page');

        $this->_view->setVal('meta_description', 'About Us Page');

        $this->_view->setVal('meta_keyword', 'About Us Page');

        $this->_view->renderAdmin('about-us');
    }

    public function save()
    {

        $id = $_POST['id'] ?? '';
        $title = $_POST['title'];
        $description = $_POST['description'];
        $description_extra = $_POST['extra_description'];
        $folder_data = UPLOAD_ROOT . 'about_us/';

        $filename = $_FILES["image"]["name"];
        $temp_name = $_FILES["image"]["tmp_name"];
        $old_file = $_POST['image_old'] ?? '';
        $folder = $folder_data . $filename;

        if (!empty($old_file)) {
            if (!empty($temp_name)) {
                if (move_uploaded_file($temp_name, $folder)) {
                    unlink($folder_data . $old_file);
                    $file_name = $filename;
                } else {
                    $file_name = $old_file;
                }
            } else {
                $file_name = $old_file;
            }
        } else {
            if (move_uploaded_file($temp_name, $folder)) {
                $file_name = $filename;
            } else {
                $file_name = null;
            }
        }

        $data = [
            'heading' => htmlspecialchars($title),
            'description' => htmlspecialchars($description),
            'description_extra' => htmlspecialchars($description_extra),
            'image' => $file_name,
        ];


        $data['updated_at'] =  date('Y-m-d h:i:s');
        $update_colum = '';
        $updated_colum_keys = array_keys($data);
        foreach ($data as $uk => $uv) {
            if ($uk != end($updated_colum_keys)) {
                $separator = ',';
            } else {
                $separator = '';
            }
            $update_colum .= $uk . " = '" . $uv . "'" . $separator;
        }

        $sql = "UPDATE " . PAGE_DATA . " SET " . $update_colum . " WHERE id = " . $id;
        $mode = 'Updated';

        $type   = "error";
        try {
            $db =  new Database();
            $db->query($sql);
            $results = $db->execute();
        } catch (Exception $e) {
            $msg  = $e->getMessage();
            $results = 0;
        }
        if ($results) {

            $type = 'success';
            $msg = 'Broker Data Successfully ' . $mode;
        } else {
            $type   = "error";
            $msg = "Unable to " . $mode . " Broker Data!!";
        }

        set_session_alert($type, $msg);

        redirect(ADMIN_URL . 'about-us');
    }
}
