<?php

require_once APP_DIR . 'libs/View.php';

require_once APP_DIR . 'libs/Input.php';

require_once APP_DIR . 'libs/Session.php';

require_once APP_DIR . 'models/AuthModel.php';
require_once APP_DIR . 'libs/Database.php';


class IndexController

{

    private $_view;
    private $_db;

    public function __construct()
    {
        check_login('index');
        $this->_view  = new View();
        $this->_db = new Database();
    }



    public function index()
    {
        $user_id = SESSION::get('uId');
        if (!empty($user_id)) {
            $authObj = new AuthModel();
            $login_user_data = $authObj->getUserDetails($user_id);
            $this->_view->setVal('login_user_data', $login_user_data);
        }
        $this->_db->query("SELECT * FROM " . CONTACT_FORM . " WHERE 1 LIMIT 15");
        $res =  $this->_db->getAll();
        $this->_view->setVal('enquiry_res', $res);
        $this->_db->query("SELECT * FROM " . PROPERTY_ENQUIRES . " WHERE 1 LIMIT 15");
        $enq =  $this->_db->getAll();
        $this->_view->setVal('pro_enquiry_res', $enq);
        $this->_view->setVal('meta_title', 'Dashboard Page');
        $this->_view->setVal('meta_description', 'Dashboard Page');
        $this->_view->setVal('meta_keyword', 'Dashboard Page');
        $this->_view->renderAdmin('index');
    }
}
