<style>
    .card {
        height: auto;
    }
</style>
<div class="page-titles">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
        <li class="breadcrumb-item active"><a href="javascript:void(0)">Property Type</a></li>
    </ol>
</div>
<!-- row -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?= $label ?> Property Type Data</h4>
            </div>
            <div class="card-body">
                <form action="<?= ADMIN_URL . 'property/save-types' ?>" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <?php if (isset($property_type_data_edit['id'])) { ?>
                            <?php if (!empty($property_type_data_edit['id'])) { ?>
                                <input type="hidden" name="id" value="<?= $property_type_data_edit['id'] ?>">
                            <?php } ?>
                        <?php } ?>
                        <div class="mb-3 col-lg-8 col-md-8 col-sm-12">
                            <label class="form-label">Property Type Title</label>
                            <input type="text" class="form-control" placeholder="Title" required="" value="<?= $property_type_data_edit['name'] ?? '' ?>" name="title">
                        </div>
                        <div class="mb-3 col-lg-2 col-md-2 col-sm-12">
                            <label class="form-label">Status</label>
                            <select class="default-select form-control wide" name="status" required="">
                                <option value="1" <?= (isset($property_type_data_edit['status']) ? (($property_type_data_edit['status'] == 1)  ? 'selected' : '') : '') ?>>Active</option>
                                <option value="0" <?= (isset($property_type_data_edit['status']) ? (($property_type_data_edit['status'] == 0)  ? 'selected' : '') : '') ?>>Inactive</option>
                            </select>
                        </div>

                        <div class="col-sm-2 mb-3 pt-4">
                            <input type="submit" class="btn btn-sm btn-primary me-2" name="register_property" value="Submit">
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Property Type List</h4>
            </div>
            <div class="card-body">


                <div class="table-responsive">
                    <table class="display table" style="min-width: 850px">
                        <thead>
                            <tr>
                                <td>#</td>
                                <th>Title </th>
                                <th>Status</th>
                                <th>Created Date</th>
                                <th>Updated Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($property_type_count > 0) { ?>
                                <?php foreach ($property_type_list as $ev) { ?>
                                    <tr>
                                        <td><?= ++$start_counter; ?></td>
                                        <td><?php echo $ev['name']; ?></td>
                                        <td><?php echo ($ev['status'] == 1 ? 'Active' : 'Inactive'); ?></td>
                                        <td><?php echo !empty($ev['added']) ? date('d,M Y', strtotime($ev['added'])) : ''; ?></td>
                                        <td><?php echo !empty($ev['updated']) ? date('d,M Y', strtotime($ev['updated'])) : ''; ?></td>
                                        <td>
                                            <a href="<?= ADMIN_URL . 'property/types/' . encryptData($ev['id']) ?>" class="btn btn-success btn-sm"><i class="fa fa-pencil"></i> Edit</a>
                                            <a href="javascript:void(0);" onclick="deleteData(this)" data-href="<?= ADMIN_URL . 'property/deleteTypes/' . encryptData($ev['id']) ?>" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i> Delete</a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            <?php } else { ?>
                                <tr>
                                    <td colspan="6" class="text-center">No Records Found</td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>

                <?php if ($property_type_count > 0) { ?>
                    <div class="col-lg-12">
                        <p class="mb-2 me-3">
                            <?= $property_type_pagination->displayLinks(ADMIN_URL . 'property/types'); ?>
                        </p>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" type="text/css" href="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.css">
<script src="<?= SITE_URL ?>public/admin/assets/vendor/sweetalert2/dist/sweetalert2.min.js"></script>
<script>
    function deleteData(_this) {
        let url = $(_this).attr('data-href');
        new swal({
            title: 'Are you sure?',
            text: "It will permanently deleted !",
            type: 'danger',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            } else if (result.isDenied) {}
        })
    }
</script>