<style>
    td.day.disabled {
        background-color: #ddd !important;
    }
</style>
<div class="page-titles">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
        <li class="breadcrumb-item active"><a href="javascript:void(0)">Review Data</a></li>
    </ol>
</div>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Review Data</h4>
            </div>
            <div class="card-body">
                <form action="<?= ADMIN_URL . 'property/save-reviews' ?>" method="post" enctype="multipart/form-data">
                    <?php if (isset($reviewData['id'])) { ?>
                        <?php if (!empty($reviewData['id'])) { ?>
                            <input type="hidden" name="id" value="<?= $reviewData['id'] ?>">
                        <?php } ?>
                    <?php } ?>
                    <div class="row">
                        <div class="mb-3 col-lg-4 col-md-4 col-sm-12">
                            <label class="form-label">Name</label>
                            <input type="text" class="form-control" placeholder="Name" required="" value="<?= $reviewData['name'] ?? '' ?>" name="name">
                        </div>
                        <div class="mb-3 col-lg-4 col-md-4 col-sm-12">
                            <label class="form-label">Email</label>
                            <input type="text" class="form-control" placeholder="Email" value="<?= $reviewData['email'] ?? '' ?>" name="email">
                        </div>
                        <div class="mb-3 col-lg-4 col-md-4 col-sm-12">
                            <label class="form-label">Title</label>
                            <input type="text" class="form-control" placeholder="title" required="" value="<?= $reviewData['title'] ?? '' ?>" name="title">
                        </div>
                        <div class="mb-3 col-lg-4 col-md-4 col-sm-12">
                            <div class="form-group">
                                <label class="form-label">Stay date</label>
                                <div class='input-group date' id='startDate'>
                                    <input type="text" class="form-control start_date" placeholder="Stay date" required="" value="<?= $reviewData['staydate'] ?? '' ?>" name="stay_date">
                                    <span class="input-group-addon input-group-text">
                                        <span class="fa fa-calendar"></span>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3 col-lg-4 col-md-4 col-sm-12">
                            <label class="form-label">Status</label>
                            <select class="form-control form-select" name="status">
                                <option value="">Select</option>
                                <option value="1" <?= (isset($reviewData['status']) ? (($reviewData['status'] == 1)  ? 'selected' : '') : '') ?>>Active</option>
                                <option value="0" <?= (isset($reviewData['status']) ? (($reviewData['status'] == 0)  ? 'selected' : '') : '') ?>>Inactive</option>
                            </select>
                        </div>
                        <div class="mb-3 col-lg-4 col-md-4 col-sm-12">
                            <label class="form-label">Star</label>
                            <select class="form-control form-select" name="star">
                                <option value="">Select</option>
                                <?php foreach (range(1, 5) as $v) { ?>
                                    <option value="<?= $v ?>" <?= (isset($reviewData['star']) ? (($reviewData['star'] == $v)  ? 'selected' : '') : '') ?>><?= $v ?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="mb-3 col-lg-12 col-md-12 col-sm-12">
                            <label class="form-label">Description</label>
                            <textarea name="desc" class="form-control" rows="5" placeholder="Description" id="desc" required=""><?= $reviewData['description'] ?? '' ?></textarea>
                        </div>

                        <div class="mb-3 col-12">
                            <div class="col-sm-12 pt-3">
                                <input type="submit" class="btn btn-sm btn-primary me-2" name="register_property" value="Submit">
                                <a href="<?= ADMIN_URL . 'property/reviews' ?>" class="btn light btn-warning">Back to Listing</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        // var date = new Date();
        // date.setDate(date.getDate());

        $('#startDate').datepicker({
            format: 'yyyy-mm-dd',
            // startDate: date,
            todayHighlight: 'TRUE',
            autoclose: true,
        }).on('changeDate', function(ev) {
            $('.start_date').val($('#startDate').data().datepicker.getFormattedDate('yyyy-mm-dd'));
        });
    });
</script>