<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Contracts\Session\Session;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    public function index(Request $request)
    {
        $first_name  =  $request->fname;
        $last_name  =  $request->lname;
        $email  =  $request->email;
        $number  =  $request->number;

        if (empty($first_name)) {
            echo json_encode(['sts' => false, 'msg' => 'Please Enter the First Name.', 'type' => 'error']);
            die;
        }

        if (empty($last_name)) {
            echo json_encode(['sts' => false, 'msg' => 'Please Enter the Last Name.', 'type' => 'error']);
            die;
        }

        if (empty($email)) {
            echo json_encode(['sts' => false, 'msg' => 'Please Enter the Email Address.', 'type' => 'error']);
            die;
        }

        if (empty($number)) {
            echo json_encode(['sts' => false, 'msg' => 'Please Enter the Mobile Number.', 'type' => 'error']);
            die;
        }
        
        $data =  USER::where('email', $email)->first();

        if (!empty($data)) {
            echo json_encode(['sts' => false, 'msg' => 'User Already Exist.', 'type' => 'error']);
            die;
        }

        $otp  =  rand(111111, 999999);
        $sent_time  =  date('Y-m-d h:i:s');

        $full_name = $first_name . ' ' . $last_name;
        $sinup_now = new User;
        $sinup_now->name = $full_name;
        $sinup_now->email = $email;
        $sinup_now->user_type = 1;
        $sinup_now->otp = $otp;
        $sinup_now->number = $number;
        $sinup_now->otp_send_time = $sent_time;
        $sinup_now->otp_attempts = 1;
        $res = $sinup_now->save();

        if ($res) {
            session(['email' =>  $email]);
            session(['otp' =>  $otp]);
            session(['otp_sent_time' => $sent_time]);
            session(['otp_attempts' =>  1]);

            // session('email', $email);
            // session('otp', $otp);
            // session('otp_sent_time', $sent_time);
            // session('otp_attempts', 1);

            $subject = "Viraaj Digital Otp ";
            $msg = "Your Otp for login in Viraaj Digital is : " . $otp;
            $mail_data = ['name' =>  $full_name, 'email' => $email, 'mail_subject' => $subject, 'subject' => $subject, 'msg' => $msg];

            $send_success = Mail::send('emails.register_mail', $mail_data, function ($message) use ($mail_data) {
                $message->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
                $message->sender(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
                $message->to($mail_data['email'], $mail_data['name']);
                $message->subject($mail_data['mail_subject']);
            });

            $verification_data =  ['name' =>  $full_name, 'email' => $email, 'sent_time' => $sent_time];
            echo json_encode(['sts' => true, 'msg' => 'Otp Sent Successfully.', 'data' => json_encode($verification_data), 'type' => 'success']);
            die;
        } else {
            echo json_encode(['sts' => true, 'msg' => 'Some Thing Went Wrong, Please try Again later', 'type' => 'error']);
            die;
        }
    }


    public function verifyOtp(Request $request)
    {
        $otp = $request->otp;
        $email = $request->email_add;
        $data =  USER::where('email', $email)->first();
        if (!empty($data)) {
            if (count($otp) == 6) {
                $user_otp =  implode('', $otp);
                if ($data['otp'] == $user_otp) {
                    $actual_time  =  date("Y-m-d h:i:s", strtotime(date("Y-m-d h:i:s")));
                    $verify_time  =  date("Y-m-d h:i:s", strtotime($data['otp_send_time'] . '+2 minutes'));

                    if (strtotime($actual_time) <= strtotime($verify_time)) {
                        event(new Registered($data));
                        Auth::login($data);
                        $result = USER::where('email', $email)->update(['otp_verify_time' => $actual_time]);
                        $subject = "Welcome to Viraaj Digital ";
                        $msg = "You may login to our website using this link ";
                        $full_name =  $data['name'];

                        $mail_data = ['name' =>  $full_name, 'email' => $email, 'mail_subject' => $subject, 'subject' => $subject, 'msg' => $msg];
                        $send_success = Mail::send('emails.welcome', $mail_data, function ($message) use ($mail_data) {
                            $message->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
                            $message->sender(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
                            $message->to($mail_data['email'], $mail_data['name']);
                            $message->subject($mail_data['mail_subject']);
                        });

                        echo json_encode(['sts' => true, 'msg' => 'Login Successfully', 'type' => 'success']);
                        die;
                        // return redirect(RouteServiceProvider::HOME);
                    } else {
                        echo json_encode(['sts' => false, 'msg' => 'Your OTP is expired , please resend otp to verify', 'type' => 'error']);
                        die;
                    }
                } else {
                    echo json_encode(['sts' => false, 'msg' => 'Please Enter Correct otp.', 'type' => 'error']);
                    die;
                }
            } else {
                echo json_encode(['sts' => false, 'msg' => 'Some Thing Went Wrong, Please try Again later.', 'type' => 'error']);
                die;
            }
        } else {
            echo json_encode(['sts' => false, 'msg' => 'No Record Found.', 'type' => 'error']);
            die;
        }
    }


    public function resendOtp()
    {
        $email =  session('email');
        $otp_attempts =  session('otp_attempts');
        ++$otp_attempts;
        $data =  USER::where('email', $email)->first();
        $new_otp  =  rand(111111, 999999);
        $sent_time  =  date('Y-m-d h:i:s');

        if (!empty($data)) {
            if ($otp_attempts <= 3) {
                $result = USER::where('email', $email)->update(['otp' => $new_otp, 'otp_send_time' => $sent_time, 'otp_attempts' => $otp_attempts]);
                if ($result) {
                    $full_name =  $data['name'];
                    session(['otp_sent_time' => $sent_time]);
                    session(['otp' => $new_otp]);
                    $subject = "Viraaj Digital Otp ";
                    $msg = "Your Otp for login in Viraaj Digital is : " . $new_otp;
                    $mail_data = ['name' =>  $full_name, 'email' => $email, 'mail_subject' => $subject, 'subject' => $subject, 'msg' => $msg];
                    $send_success = Mail::send('emails.resend_otp_mail.blade', $mail_data, function ($message) use ($mail_data) {
                        $message->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
                        $message->sender(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
                        $message->to($mail_data['email'], $mail_data['name']);
                        $message->subject($mail_data['mail_subject']);
                    });
                    $verification_data =  ['name' =>  $full_name, 'email' => $email, 'sent_time' => $sent_time];
                    echo json_encode(['sts' => true, 'msg' => 'Otp Sent Successfully.', 'data' => $verification_data, 'type' => 'success']);
                    die;
                } else {
                    echo json_encode(['sts' => false, 'msg' => 'Unable to resend otp.', 'type' => 'error']);
                    die;
                }
            } else {
                echo json_encode(['sts' => false, 'msg' => 'You have reached maximum attempts to resend otp limit 3. please contact our administrator.', 'type' => 'error']);
                die;
            }
        } else {
            echo json_encode(['sts' => false, 'msg' => 'Invalid Data', 'type' => 'error']);
            die;
        }
    }
}
