<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sub_categories', function (Blueprint $table) {
            $table->id();
            $table->string('sub_catname')->nullable();
            $table->string('cat_id')->nullable();
            $table->string('page_type')->nullable();
            $table->string('page_url')->nullable();
            $table->string('metatitle')->nullable();
            $table->string('canonicallink')->nullable();
            $table->text('metedes');
            $table->string('heading')->nullable();
            $table->string('image')->nullable();
            $table->text('short_des');
            $table->text('long_des');
            $table->string('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sub_categories');
    }
}
