 <meta charset="utf-8">
 <meta name="viewport" content="width=device-width, initial-scale=1">
 <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
 <style>
     .sm\:max-w-md {
         max-width: 60% !important;
     }

     .singup h2 {
         text-align: center;
         font-size: 23px;
         font-weight: 800;
         margin-bottom: 30px;
     }

     .leftDiv {
         background-color: #36c6d3;
         color: white;
         width: 100% !important;
         height: 100%;
         float: left;
         vertical-align: middle;
         text-align: center;
         padding-top: 80px;
     }

     .btn-default {
         color: #fff;
         background-color: red !important;
         border-radius: 20px !important;
         color: #36c6d3;
         width: 53%;
         height: 40px
     }

     .help-block-others {
         color: red;
     }

     .has-error input {
         border-color: red;
     }

     .intl-tel-input {
         width: 100%;
     }
 </style>
 <x-guest-layout>
     <x-auth-card>
         <x-slot name="logo">
             <a href="/">
                 <img src="{{ url('/') }}/home/images/logo-w.png" style="width:200px;">
             </a>
         </x-slot>
         <div class="container">
             <div class="row">
                 <div class="col-md-4">
                     <div class="leftDiv">
                         <h2><b>One Of Us?</b></h2>
                         <p>If you already have an account, just sign in.<br> We've missed you!</p>
                         <a type="submit" class="btn btn-default" href="{{ route('login') }}"><strong>Sign
                                 In</strong></a>
                     </div>
                 </div>
                 <div class="col-md-8 singup">
                     <h2>Create Account</h2>
                     <x-auth-validation-errors class="mb-4" :errors="$errors" />
                     <div id="basic-form">
                         <h3>Basic Information</h3>
                         <form method="POST" onsubmit="return false;" id="auth_form">
                             @csrf

                             <!-- Name -->
                             <div class="class row">
                                 <div class="col-md-6">
                                     <div class="form-group">
                                         <x-input id="fname" class="block mt-1 w-full" type="text" name="fname"
                                             :value="old('fname')" required autofocus placeholder="First Name*" />
                                     </div>
                                 </div>
                                 <div class="col-md-6">
                                     <div class="form-group">
                                         <x-input id="lname" class="block mt-1 w-full" type="text" name="lname"
                                             :value="old('lname')" required autofocus placeholder="Last Name*" />
                                     </div>
                                 </div>
                             </div>

                             <div class="class row mt-4">
                                 <div class="col-md-6">
                                     <div class="form-group">
                                         <x-input id="email" class="block mt-1 w-full" type="email" name="email"
                                             :value="old('email')" required placeholder="Email*" />
                                     </div>
                                 </div>
                                 <div class="col-md-6">
                                     <div class="form-group">
                                         <x-input id="number" type="tel" class="block mt-1 w-full" name="number"
                                             :value="old('number')" required autofocus placeholder="Mobile Number*" />
                                     </div>
                                 </div>
                             </div>

                             {{-- <div class="mt-4">
                                        <x-input id="address" class="block mt-1 w-full" type="text" name="address"
                                            :value="old('address')" required placeholder="Shipping Address*" />
                                    </div>
                                    <!-- Password -->
                                    <div class="mt-4">
                                        <x-input id="password" class="block mt-1 w-full" type="password" name="password" required
                                            autocomplete="new-password" placeholder="****" />
                                    </div>
                                    <div class="mt-4">
                                        <x-input id="password_confirmation" class="block mt-1 w-full" type="password"
                                            name="password_confirmation" required placeholder="Confirm Password*" />
                                    </div> --}}

                             <div class="flex items-center justify-end mt-4">
                                 <a class="underline text-sm text-gray-600 hover:text-gray-900"
                                     href="{{ route('login') }}">
                                     {{ __('Already registered?') }}
                                 </a>

                                 <x-button class="ml-4">
                                     {{ __('Register') }}
                                 </x-button>
                             </div>
                         </form>
                     </div>
                     <div id="otp-form" style="display: none">
                         <form method="POST" id="otp_form" onsubmit="return false;">
                             @csrf
                             {{-- <div class="class row mt-4">
                                 <div class="col-md-6">
                                     <div class="form-group">
                                         <x-input id="text" type="tel" class="block mt-1 w-full" name="otp"
                                             aria-label="OTO" :value="old('otp')" required autofocus
                                             placeholder="Enter Otp*" />
                                     </div>
                                 </div>
                             </div>
                             <div class="flex items-center justify-end mt-4">
                                 <button type="submit" name="otp_form">Submit</button>
                             </div> --}}


                             <div class="height-100 d-flex justify-content-center align-items-center">
                                 <div class="position-relative">
                                     <div class="card p-2 text-center">
                                         <h6>Please enter the one time password <br> to verify your account </h6>
                                         <div>
                                             <span>A OTP code has been sent to Email </span>
                                             <small>
                                                 <span id="email_address"></span>
                                             </small>
                                         </div>
                                         <input type="hidden" value="" name="email_add" id="email_add">
                                         <div id="otp" class="inputs d-flex flex-row justify-content-center mt-2">
                                             <input class="m-2 text-center form-control rounded" type="text"
                                                 id="first" maxlength="1" name="otp[]" />
                                             <input class="m-2 text-center form-control rounded" type="text"
                                                 id="second" maxlength="1" name="otp[]" />
                                             <input class="m-2 text-center form-control rounded" type="text"
                                                 id="third" maxlength="1" name="otp[]" />
                                             <input class="m-2 text-center form-control rounded" type="text"
                                                 id="fourth" maxlength="1" name="otp[]" />
                                             <input class="m-2 text-center form-control rounded" type="text"
                                                 id="fifth" maxlength="1" name="otp[]" />
                                             <input class="m-2 text-center form-control rounded" type="text"
                                                 id="sixth" maxlength="1" name="otp[]" />
                                         </div>
                                         <div id="otp_verify_div">Expires In = <span id="timer"></span></div>

                                         <div id="resend_otp_div" style="display: none"></div>
                                         <div class="mt-4"> <button type="submit" id="otp_validate_btton"
                                                 class="btn btn-danger px-4 validate">Validate</button> </div>
                                     </div>
                                 </div>
                             </div>
                         </form>


                     </div>
                 </div>
             </div>
         </div>
     </x-auth-card>
     <!-- Validation Errors -->

 </x-guest-layout>

 <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
 <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.js"></script>
 <link href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.14/css/intlTelInput.css" rel="stylesheet" />
 <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.14/js/utils.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.14/js/intlTelInput.js"></script>

 <script>
     let phoneNumberField = $('#number');
     let isPhoneNumberFieldExist = phoneNumberField.length;
     if (isPhoneNumberFieldExist) {
         phoneNumberField.intlTelInput({
             initialCountry: "in",
         });
     }

     $(function() {
         $('#auth_form').validate({
             ignore: '',
             rules: {
                 fname: {
                     required: true,
                     minlength: 2,
                     maxlength: 100,
                 },
                 lname: {
                     required: true,
                     minlength: 2,
                     maxlength: 100,
                 },
                 email: {
                     email: true,
                     required: true,
                     minlength: 5,
                     maxlength: 50,
                 },
                 number: {
                     required: true,
                     minlength: 6,
                     maxlength: 15,
                 },
             },
             errorElement: "div",
             errorClass: "help-block-others text-left",
             errorPlacement: function(error, element) {
                 element.parent().after(error);
             },
             highlight: function(element) {

                 jQuery(element).parent().addClass("has-error");
             },
             unhighlight: function(element) {

                 jQuery(element).parent().removeClass("has-error");
             },
             invalidHandler: function(form, validator) {
                 if (!validator.numberOfInvalids())
                     return;
             },
             submitHandler: function(form) {
                 var dataString = $("#auth_form").serialize();
                 $.ajax({
                     type: "POST",
                     url: "auth",
                     data: dataString,
                     dataType: 'json',
                     success: function(response) {
                         Swal.fire({
                             text: response.msg,
                             icon: response.type
                         });
                         if (response.sts == true) {
                             let user_data = JSON.parse(response.data);
                             $('#email_address').html(user_data.email);
                             $('#email_add').val(user_data.email);
                             timer(120);
                             $('#basic-form').hide();
                             $('#otp-form').show();
                         } else {
                             $('#basic-form').show();
                             $('#otp-form').hide();
                         }
                     },
                 });
                 return false;
             }
         });


         $('#otp_form').validate({
             ignore: '',
             rules: {
                 'otp[]': {
                     required: true,
                 },
             },
             errorElement: "div",
             errorClass: "help-block-others text-left",
             errorPlacement: function(error, element) {
                 element.parent().after(error);
             },
             highlight: function(element) {

                 jQuery(element).parent().addClass("has-error");
             },
             unhighlight: function(element) {

                 jQuery(element).parent().removeClass("has-error");
             },
             invalidHandler: function(form, validator) {
                 if (!validator.numberOfInvalids())
                     return;
             },
             submitHandler: function(form) {
                 var dataString = $("#otp_form").serialize();
                 $.ajax({
                     type: "POST",
                     url: "auth/verify-otp",
                     data: dataString,
                     dataType: 'json',
                     success: function(response) {
                         Swal.fire({
                             text: response.msg,
                             icon: response.type
                         });
                         if (response.sts == true) {
                             window.location.href = '';
                         } else {
                             $('#otp_verify_div').hide();
                             $('#resend_otp_div').show();
                             $('#otp_validate_btton').attr('disabled', 'disabled');
                             $('#resend_otp_div').html(
                                 '<a href="javascript:void(0);" onclick="resendOtp()" class="link-offset-2 link-underline link-underline-opacity-100">Resend OTP</a>'
                             )
                         }
                     },
                 });
                 return false;

             }
         });
     });


     document.addEventListener("DOMContentLoaded", function(event) {
         function OTPInput() {
             const inputs = document.querySelectorAll('#otp > *[id]');
             for (let i = 0; i < inputs.length; i++) {
                 inputs[i].addEventListener('keydown', function(event) {
                     if (event.key === "Backspace") {
                         inputs[i].value = '';
                         if (i !== 0) inputs[i - 1].focus();
                     } else {
                         if (i === inputs.length - 1 && inputs[i].value !== '') {
                             return true;
                         } else if (event.keyCode > 47 && event.keyCode < 58) {
                             inputs[i].value = event.key;
                             if (i !== inputs.length - 1) inputs[i + 1].focus();
                             event.preventDefault();
                         } else if (event.keyCode > 64 && event.keyCode < 91) {
                             inputs[i].value = String.fromCharCode(event.keyCode);
                             if (i !== inputs.length - 1) inputs[i + 1].focus();
                             event.preventDefault();
                         }
                     }
                 });
             }
         }
         OTPInput();
     });


     let timerOn = true;

     function timer(remaining) {
         var m = Math.floor(remaining / 60);
         var s = remaining % 60;

         m = m < 10 ? '0' + m : m;
         s = s < 10 ? '0' + s : s;
         $('#timer').html(m + ':' + s);
         remaining -= 1;

         if (remaining >= 0 && timerOn) {
             setTimeout(function() {
                 timer(remaining);
             }, 1000);
             return;
         }

         if (!timerOn) {
             // Do validate stuff here
             return;
         }
         $('#otp_verify_div').hide();
         $('#resend_otp_div').show();
         $('#otp_validate_btton').attr('disabled', 'disabled');
         $('#resend_otp_div').html(
             '<a href="javascript:void(0);" onclick="resendOtp()" class="link-offset-2 link-underline link-underline-opacity-100">Resend OTP</a>'
         )
     }

     function resendOtp() {
         $.ajax({
             type: "POST",
             url: "auth/resend-otp",
             data: {
                 "_token": "{{ csrf_token() }}",
             },
             dataType: 'json',
             success: function(response) {
                 Swal.fire({
                     text: response.msg,
                     icon: response.type
                 });
                 if (response.sts == true) {
                     timer(120);
                     $('#otp_validate_btton').removeAttr("disabled");
                     $('#otp_verify_div').show();
                     $('#resend_otp_div').hide();
                 } else {
                    //  window.location.href = "";
                 }
             },
         });
         return false;
     }
 </script>
