@extends('layouts.main')


@section('main-section')
    @foreach ($categoryy as $row)
        @push('title')
            <title>{{ $row->metatitle }}</title>
        @endpush
        @push('description')
            <meta name="description" content="{{ $row->metedes }}">
        @endpush
        @push('canonical')
            <link rel="canonical" href="{{ url('/') }}/main-service/{{ $row->page_url }}">
        @endpush

        <!-- rts service banner area start -->
        <div class="rts-service-banner-area rts-section-gap">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="title-service-page-area-top text-center pt--20">
                            <h1 class="title split-collab">
                                <span>{{ $row->catagory_name }}</span>
                            </h1>

                        </div>
                    </div>
                </div>
            </div>
            <div class="rts-product-area">
                <div class="container">
                    <div
                        class="row service-relative align-items-center section-separator-top-bg-white single-product-list pt--15 pb--15  pb_sm--30 pt_md--80 pt_sm--50">
                        <div class="col-lg-6 col-md-6">
                            <div class="large-thumbnail">
                                <a href="#" class="thumbnail">
                                    <img src="{{ url('/') }}/product/{{ $row->image }}" width="100%" height="400"
                                        alt="{{ $row->catagory_name }}">
                                </a>

                            </div>
                        </div>
                        <div class="col-lg-5 col-md-6">
                            <div class="portfolio-content-wrapper-list">

                                <p class="disc">
                                    {!! $row->short_des !!}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="product-area-start-case-studies home-seven-case rts-section-gap">
                <div class="container">
                    <div class="row">
                        <div class="title-style-one-center">
                            <span class="pre skew-up" style="opacity: 1;">
                                <div class="word-line" style="display: block; text-align: center; width: 100%;">
                                </div>
                            </span>
                            <h2 class="title skew-up" style="opacity: 1;">
                                <div class="word-line" style="display: block; text-align: center; width: 100%;">
                                    <div class="word"
                                        style="display: inline-block; translate: none; rotate: none; scale: none; transform: translate(0px, 0%);">
                                        Our </div>
                                    <div class="word"
                                        style="display: inline-block; translate: none; rotate: none; scale: none; transform: translate(0px, 0%);">
                                        {{ $row->catagory_name }} Service</div>
                                </div>
                            </h2>
                        </div>
                    </div>
                    <div class="row g-48 mt--0 justify-content-sm-center justify-content-md-start">
                        @foreach ($sub_category as $main)
                            <div class="col-lg-4 col-md-6 col-sm-10">
                                <div class="siongle-portfolio-box-style">
                                    <a href="{{ url('/') }}/services/{{ $main->page_url }}" class="thumbnail">
                                        <img src="{{ url('/') }}/product/{{ $main->image }}"
                                            alt="{{ $main->catagory_name }}">
                                    </a>
                                    <div class="inner-content">
                                        <div class="left-content">
                                            <span class="pre">{{ $main->sub_catname }}</span>
                                            <a href="{{ url('/') }}/services/{{ $main->page_url }}">
                                                <h3 class="title animated fadeIn"> </h3>
                                            </a>
                                            <p>{!! $main->short_des !!}</p>
                                        </div>
                                        <div class="right">
                                            <a href="{{ url('/') }}/services/{{ $main->page_url }}">
                                                <i class="fa fa-chevron-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <!-- banner shape service end -->
        </div>
        <!-- subscription area end -->
    @endforeach
@endsection
