@extends('layouts.main')


@section('main-section')
    <title>Cart</title>
    <style>
        .bg-grey {
            background-color: #fbf9f9;
        }

        hr {
            margin-bottom: 0px;
        }

        .card-registration.card-registration-2 h1 {
            font-size: 18px;
            line-height: 10px;
        }

        .cart_product_title {
            width: 60%;
        }

        .cart_product_validity {
            width: 15ch;
        }

        .cart_product_price {
            width: 25%;
        }

        .cart_product_action {
            width: 10%;
            text-align: right
        }
    </style>


    <section class="h-100 h-custom" style="background-color: #eee;">
        <div class="container py-5 h-100">
            <div class="row d-flex justify-content-center align-items-center h-100">
                <div class="col">
                    <div class="card">
                        <div class="card-body p-4">
                            <div class="row">

                                @if (session()->has('message'))
                                    <div class="alert alert-success">
                                        <button style="20px" type="button" class="close" data-dismiss="alert"
                                            aria-hidden="true">X</button>
                                        {{ session()->get('message') }}
                                    </div>
                                @endif

                                <div class="col-lg-7">
                                    <p class="mb-3">
                                        <a href="{{ url('/') }}" class="text-body">
                                            <i class="fa fa-arrow-left me-2"></i>Continue shopping
                                        </a>
                                    </p>
                                    <hr>
                                    <div class="d-flex justify-content-between align-items-center mb-4">
                                        <div class="text-left">
                                            <span>Shopping cart</span>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="flex-row cart_product_title">
                                                Product Info
                                            </div>
                                            <div class="flex-row cart_product_validity">
                                                Validity
                                            </div>
                                            <div class="flex-row cart_product_price">
                                                Price
                                            </div>
                                            <div class="flex-row cart_product_action">

                                            </div>
                                        </div>
                                    </div>
                                    @php $totalprice = 0; @endphp
                                    @foreach ($cart as $row)
                                        <div class="row">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <div class="flex-row cart_product_title">
                                                    <p class="text-black">
                                                        <?php
                                                        if (!empty($row->product_title)) {
                                                            echo '<strong>Plan Name: </strong>' . $row->product_title;
                                                        }
                                                        if (!empty($row->product_category)) {
                                                            echo '<br> <strong>Category: </strong>' . $row->product_category;
                                                        }
                                                        if (!empty($row->mrp)) {
                                                            echo '<br> <strong>As Per Rate: </strong>' . $row->mrp;
                                                        }
                                                        ?>
                                                    </p>
                                                </div>
                                                <div class="flex-row cart_product_validity">
                                                    <p class="fw-normal mb-0">{{ $row->validity }} </p>
                                                </div>
                                                <div class="flex-row cart_product_price">
                                                    <p class="fw-normal mb-0">₹ {{ $row->price }} </p>
                                                </div>
                                                <div class="flex-row cart_product_action">
                                                    <a href="{{ url('/') }}/remove_cart/{{ Crypt::encrypt($row->id) }}"
                                                        style="color: red;"><i class="fa fa-trash"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                        @php $totalprice = $totalprice + $row->price; @endphp
                                    @endforeach
                                </div>
                                <div class="col-lg-5">
                                    <div class="card  rounded-3" style="background:#ddd;">
                                        <div class="card-body">
                                            <span>You have {{ count($cart) }} items in your cart</span>
                                            <hr class="my-4">
                                            <div class="d-flex justify-content-between">
                                                <p class="mb-2 text-dark">Subtotal</p>
                                                <p class="mb-2 text-dark">₹ {{ $totalprice }}.00</p>
                                            </div>
                                            <div class="form-outline form-dark mb-4">
                                                <form class="mt-4 form-inline" id="apply_coupon">
                                                    <div class="row">
                                                        <div class="col-md-8">
                                                            <input type="text" id="coupon_code"
                                                                class="form-control form-control-lg"
                                                                placeholder="Enter Coupon Code" />
                                                        </div>
                                                        <div class="col-md-4">
                                                            <button type="submit" class="rts-btn btn-primary">Apply
                                                                Coupon</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="d-flex justify-content-between mb-4">
                                                <p class="mb-2 text-dark">Total (Excl. taxes)</p>
                                                <p class="mb-2 text-dark">₹ {{ $totalprice }}</p>
                                            </div>
                                            <div class="d-flex justify-content-between mb-4"
                                                style="display: none !important;">
                                                <p class="mb-2 text-dark">Coupon Discount</p>
                                                <p class="mb-2 text-dark coupon-discount"></p>
                                            </div>
                                            <div class="d-flex justify-content-between">
                                                <span class="text-dark discounted_value" data-total-price="">₹ {{ $totalprice }}</span>
                                                <?php if(count($cart)){ ?>
                                                <div class="btn-group">
                                                    {{-- href="{{ url('/') }}/cash_order" --}}
                                                    <button type="button" class="rts-btn btn-danger pay_cod me-2">
                                                        COD
                                                    </button>
                                                    <button type="button" class="rts-btn btn-info pay_now">
                                                        Checkout <i class="fa fa-arrow-right ms-2"></i>
                                                    </button>
                                                </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-between">
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        $('#apply_coupon').on('submit', function() {
            let value = $('#coupon_code').val();
            if (value) {
                $.ajax({
                    type: 'POST',
                    url: "{{ url('/').'/apply_coupon' }} ",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        'value': value,
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.sts == true) {

                            Swal.fire({
                                icon: response.type,
                                title: response.msg,
                                timer: 1500
                            });
                        } else {
                            Swal.fire({
                                icon: response.type,
                                text: response.msg,
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                    }
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    text: 'Please Enter Coupon Code!',
                });
            }
            return false;
        });
    </script>
@endsection
