<!DOCTYPE html>
<html lang="en">
  <head>
  <base href="/public">
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Show All Invoice</title>
    <!-- plugins:css -->
    @include('admin.link');
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js" integrity="sha512-GsLlZN/3F2ErC5ifS5QtgpiJtWd43JWSuIgh7mbzZ8zBps+dvLusV+eNQATqgA/HdeKFVgA5v3S/cIrLF7QnIg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        function generatePDF() {
          const element = document.getElementById("invoice");

          html2pdf()
          .from(element)
          .save();
        }
    </script>
    <style>
      #inputblack{
        color:#000;
      }
      #invoice {
    padding: 0px;
}

.invoice {
    position: relative;
    background-color: #FFF;
    min-height: 680px;
    padding: 15px
}

.invoice header {
    padding: 10px 0;
    margin-bottom: 20px;
    border-bottom: 1px solid #0d6efd
}

.invoice .company-details {
    text-align: right
}

.invoice .company-details .name {
    margin-top: 0;
    margin-bottom: 0
}

.invoice .contacts {
    margin-bottom: 20px
}

.invoice .invoice-to {
    text-align: left
}

.invoice .invoice-to .to {
    margin-top: 0;
    margin-bottom: 0
}

.invoice .invoice-details {
    text-align: right
}

.invoice .invoice-details .invoice-id {
    margin-top: 0;
    color: #0d6efd
}

.invoice main {
    padding-bottom: 50px
}

.invoice main .thanks {
    margin-top: -100px;
    font-size: 2em;
    margin-bottom: 50px
}

.invoice main .notices {
    padding-left: 6px;
    border-left: 6px solid #0d6efd;
    background: #e7f2ff;
    padding: 10px;
}

.invoice main .notices .notice {
    font-size: 1.2em
}

.invoice table {
    width: 100%;
    border-collapse: collapse;
    border-spacing: 0;
    margin-bottom: 20px
}

.invoice table td,
.invoice table th {
    padding: 15px;
    background: #eee;
    border-bottom: 1px solid #fff
}

.invoice table th {
    white-space: nowrap;
    font-weight: 400;
    font-size: 16px
}

.invoice table td h3 {
    margin: 0;
    font-weight: 400;
    color: #0d6efd;
    font-size: 1.2em
}

.invoice table .qty,
.invoice table .total,
.invoice table .unit {
    text-align: right;
    font-size: 1.2em
}

.invoice table .no {
    color: #fff;
    font-size: 1.6em;
    background: #0d6efd
}

.invoice table .unit {
    background: #ddd
}

.invoice table .total {
    background: #0d6efd;
    color: #fff
}

.invoice table tbody tr:last-child td {
    border: none
}

.invoice table tfoot td {
    background: 0 0;
    border-bottom: none;
    white-space: nowrap;
    text-align: right;
    padding: 10px 20px;
    font-size: 1.2em;
    border-top: 1px solid #aaa
}

.invoice table tfoot tr:first-child td {
    border-top: none
}
.card {
    position: relative;
    display: flex;
    flex-direction: column;
    min-width: 0;
    word-wrap: break-word;
    background-color: #fff;
    background-clip: border-box;
    border: 0px solid rgba(0, 0, 0, 0);
    border-radius: .25rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 2px 6px 0 rgb(218 218 253 / 65%), 0 2px 6px 0 rgb(206 206 238 / 54%);
}

.invoice table tfoot tr:last-child td {
    color: #0d6efd;
    font-size: 1.4em;
    border-top: 1px solid #0d6efd
}

.invoice table tfoot tr td:first-child {
    border: none
}

.invoice footer {
    width: 100%;
    text-align: center;
    color: #777;
    border-top: 1px solid #aaa;
    padding: 8px 0
}

@media print {
    .invoice {
        font-size: 11px !important;
        overflow: hidden !important
    }
    .invoice footer {
        position: absolute;
        bottom: 10px;
        page-break-after: always
    }
    .invoice>div:last-child {
        page-break-before: always
    }
}

.invoice main .notices {
    padding-left: 6px;
    border-left: 6px solid #0d6efd;
    background: #e7f2ff;
    padding: 10px;
}
      </style>

  </head>
  <body>
    <div class="container-scroller">
     @include('admin.nav');
      <div class="container-fluid page-body-wrapper">
      @include('admin.top_nav');
        <div class="main-panel">
          <div class="content-wrapper">
            <div class="row">
            @if(session()->has('delete'))
               <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">X</button>
                {{session()->get('delete')}}
               </div>
        @endif       
<div class="col-md-12 mt-3" id="invoice">
  <div class="row">
                <div class="">
                  <div class="">
                 
                    <div class="container">
    <div class="card">
        <div class="card-body">
            <div id="invoice">
                <div class="toolbar hidden-print">
                    <div class="text-end">
                        <button type="button" class="btn btn-dark"><i class="fa fa-print"></i> Print</button>
                        <button onclick="generatePDF()" type="button" class="btn btn-danger"><i class="fa fa-file-pdf-o"></i> Export as PDF</button>
                    </div>
                    <hr>
                </div>
                <div class="invoice overflow-auto">
                    <div style="min-width: 600px">
                        <header>
                            <div class="row">
                                <div class="col">
                                    <a href="javascript:;">
    												<img src="{{url('/')}}/admin/assets/images/logo.png" width="40%" alt="">
												</a>
                                </div>
                                <div class="col company-details">
                                    <h2 class="name">
                                        <a target="_blank" href="javascript:;">
									Viraaj Digital
									</a>
                                    </h2>
                                    <div style="color:#000;">Plot no.48, Ground Floor, Sector-2A, Kopar Khairane, Navi Mumbai, Pin - 400709 Maharashtra (India)</div>
                                    <div style="color:#000;">+91 9594349228</div>
                                    <div style="color:#000;"> info@viraajdigital.com</div>
                                </div>
                            </div>
                        </header>
                    
                        @foreach($show_in as $row)
                        <main>
                          
                            <div class="row contacts">

                            @foreach($user as $uss)
                            @if($uss->id == $row->user_id)
                         
                                <div class="col invoice-to">
                                    <div class="text-gray-light">INVOICE TO:</div>
                                    <h2 class="to" style="color:#000;">{{$uss->name}}</h2>
                                    <div class="address" style="color:#000;">{{$uss->address}}</div>
                                    <div class="email" style="color:#000;"><a href="mailto:{{$uss->email}}">{{$uss->email}}</a>
                                    </div>
                                </div>
                                @endif
                                @endforeach
                              
                                <div class="col invoice-details">
                                    <h1 class="invoice-id">INVOICE #{{$row->invoice_id}}</h1>
                                    <div class="date" style="color:#000;">Date of Invoice: {{$row->issue_data}}</div>
                                    <div class="date" style="color:#000;">Due Date: {{$row->due_data}}</div>
                                </div>
                                
                               
                            </div>
                            <table>
                                <thead>
                                    <tr>
                                        <th style="color:#000;">#</th>
                                        <th class="text-left" style="color:#000;">DESCRIPTION</th>
                                        <th class="text-right" style="color:#000;"></th>
                                        <th class="text-right" style="color:#000;"></th>
                                        <th class="text-right" style="color:#000;">TOTAL</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $totalprice=0;?>
                                @foreach($user as $uss)
                                @foreach($order as $or)
                                @if($or->user_id == $uss->id)
                                @if($uss->id == $row->user_id)

                             
 
                                    <tr>
                                        <td class="no">0{{$loop->index+1}}</td>
                                        <td class="text-left" style="color:#000;">
                                            {{$or->product_title}}</td>
                                        <td class=""></td>
                                        <td class=""></td>
                                        <td class="total">₹ {{ number_format($or->price * (1 + (0.01 *18))) }}.00 </td>
                                    </tr>
                                    <?php $totalprice=$totalprice + $or->price * (1 + (0.01 *18))?>
                                    @endif   
                                    @endif
                                    @endforeach
                                @endforeach
                                </tbody>

                                <tfoot>
                                    
                                    
                                    <tr>
                                        <td colspan="2"></td>
                                        <td colspan="2" style="color:#000;">TAX 18%</td>
                                        <td>₹ {{$totalprice}}</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2"></td>
                                        <td colspan="2" style="color:#000;">GRAND TOTAL</td>
                                        <td>₹ {{$totalprice}}</td>
                                    </tr>
                                </tfoot>
                            </table>
                            <div class="thanks" style="color:#000;">Thank you!</div>
                            <div class="notices">
                                <div style="color:#000;">NOTICE:</div>
                                <div class="notice" style="color:#000;">A finance charge of 1.5% will be made on unpaid balances after 30 days.</div>
                            </div>
                        </main>
                        @endforeach
                        <footer>Invoice was created on a computer and is valid without the signature and seal.</footer>
                    </div>
                    <!--DO NOT DELETE THIS div. IT is responsible for showing footer always at the bottom-->
                    <div></div>
                </div>
            </div>
        </div>
    </div>
</div>

                  </div>
                </div>
                </div>
                </div>
            </div>
            </div>
            </div>
      </div>
    </div>
    @include('admin.script');
  </body>
</html>