<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\AdminController;
use App\Http\Controllers\HomeController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/', [HomeController::class,'home']);

Route::get('/about-us', function () {
    return view('about-us');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

Route::post('/enquire_now',[HomeController::class, 'enquire_now']);

Route::get('/services/{page_url}',[HomeController::class, 'services']);

Route::get('/pages/{page_url}',[HomeController::class, 'pages']);

Route ::get('/products/{page_url}',[HomeController::class, 'products']);

Route::get('/main-service/{page_url}',[HomeController::class, 'mainservice']);

route::get('/singup', [HomeController::class, 'singup']);
route::get('/account',[HomeController::class, 'account']);

Route::post('/enquire_contact',[HomeController::class, 'enquire_contact']);

Route::get('/redirect', [AdminController::class,'redirect']);

Route::get('/view_catagory',[AdminController::class, 'view_catagory']);
Route::get('/show_catagory',[AdminController::class, 'show_catagory']);
route::get('/view_subcategory',[AdminController::class, 'view_subcategory']);
route::get('/update_subcat/{id}', [AdminController::class, 'update_subcat']);
Route::post('/add_catagory',[AdminController::class, 'add_catagory']);
route::post('/add_subcatagory', [AdminController::class, 'add_subcatagory']);
Route::get('/delete_catagory/{id}',[AdminController::class, 'delete_catagory']);
route::get('/delete_sub_catagory/{id}',[AdminController::class, 'delete_sub_catagory']);
Route::get('/view_product',[AdminController::class, 'view_product']);

Route::get('/view_package',[AdminController::class, 'view_package']);




route::get('/delete_product/{id}',[AdminController::class, 'delete_product']);
route::get('/delete_pages/{id}', [AdminController::class, 'delete_pages']);
route::get('/view_banner',[AdminController::class, 'view_banner']);
route::post('/add_banner',[AdminController::class, 'add_banner']);
route::post('/add_test',[AdminController::class, 'add_test']);
route::post('/add_brand',[AdminController::class, 'add_brand']);
route::get('/view_product',[AdminController::class, 'view_product']);
route::post('/add_deatils/{id}', [AdminController::class, 'add_deatils']);
route::get('/add_product', [AdminController::class, 'add_product']);
route::get('/add_package', [AdminController::class, 'add_package']);

route::post('/add_packages', [AdminController::class, 'add_packages']);


route::post('/add_products',[AdminController::class, 'add_products']);

route::post('/add_pages_con',[AdminController::class, 'add_pages_con']);

route::post('/add_layouts',[AdminController::class, 'add_layouts']);


route::post('/update_pro/{id}',[AdminController::class, 'update_pro']);

route::post('/update_pack/{id}',[AdminController::class, 'update_pack']);

route::get('/update_package/{id}',[AdminController::class, 'update_package']);




route::get('/update_pages/{id}', [AdminController::class, 'update_pages']);
route::post('/update_con/{id}', [AdminController::class, 'update_con']);
route::get('/update_catagory/{id}', [AdminController::class, 'update_catagory']);
route::get('/update_layoutt/{id}', [AdminController::class, 'update_layoutt']);
route::post('/update_layo/{id}', [AdminController::class, 'update_layo']);
route::post('/update_cat/{id}', [AdminController::class, 'update_cat']);
route::get('/update_product/{id}',[AdminController::class, 'update_product']);
route::post('update_subcategory/{id}', [AdminController::class, 'update_subcategory']);
Route::post('/add_product',[AdminController::class, 'add_product']);
Route::get('/show_product',[AdminController::class, 'show_product']);
Route::get('/delete_p/{id}',[AdminController::class, 'delete_p']);
Route::get('/delete_package/{id}',[AdminController::class, 'delete_package']);

route::get('/delete_note/{id}', [AdminController::class, 'delete_note']);

route::get('/view_notes', [AdminController::class, 'view_notes']);
route::get('/add_notes', [AdminController::class, 'add_notes']);
Route::get('/get-orders', [AdminController::class, 'getOrders'])->name('getOrders');

route::get('/add_database', [AdminController::class, 'add_database']);
route::get('/delete_database/{id}', [AdminController::class, 'delete_database']);

route::get('/view_database', [AdminController::class, 'view_database']);
route::post('/add_note', [AdminController::class, 'add_note']);
route::post('/add_data_base', [AdminController::class, 'add_data_base']);

Route::get('delete_layout/{id}', [AdminController::class, 'delete_layout']);
route::get('/delete_banner/{id}',[AdminController::class, 'delete_banner']);
route::get('/delete_text/{id}',[AdminController::class, 'delete_text']);
route::get('/delete_enquiry/{id}', [AdminController::class, 'delete_enquiry']);
route::get('/view_enquiry', [AdminController::class, 'view_enquiry']);
route::get('/delete_brand/{id}',[AdminController::class, 'delete_brand']);
route::post('/update_bannerr/{id}',[AdminController:: class, 'update_bannerr']);

route::post('/update_testt/{id}',[AdminController:: class, 'update_testt']);


route::post('/update_brandd/{id}',[AdminController:: class, 'update_brandd']);

route::get('/update_banner/{id}',[AdminController::class, 'update_banner']);
route::get('/update_text/{id}',[AdminController::class, 'update_text']);

route::get('/update_brand/{id}',[AdminController::class, 'update_brand']);


Route::get('/update_pr/{id}', [AdminController::class, 'update_pr']);
Route::post('/update_product/{id}', [AdminController::class, 'update_product']);
route::post('/update_sub/{id}', [AdminController::class, 'update_sub']);
route::get('/sub_category', [AdminController::class, 'sub_category']);
Route::get('/edit_sub/{id}', [AdminController::class, 'edit_sub']);
route::get('/delete_sub/{id}', [AdminController::class, 'delete_sub']);
route::get('/contact', [AdminController::class, 'contact']);
route::post('/add_banner', [AdminController::class, 'add_banner']);
Route::get('/view_banner', [AdminController::class, 'view_banner']);
Route::get('/view_test', [AdminController::class, 'view_test']);
Route::get('/view_brand', [AdminController::class, 'view_brand']);

Route ::get('/view_deatils', [AdminController::class, 'view_deatils']);
Route ::get('/view_lauout', [AdminController::class, 'view_lauout']);
route::get('/add_layout', [AdminController::class, 'add_layout']);
route::get('/view_contant', [AdminController::class, 'view_contant']);
route::get('/add_contant', [AdminController::class, 'add_contant']);
route::post('/add_cart/{id}', [AdminController::class, 'add_cart']);
route::get('/customize_invoice', [AdminController::class, 'customize_invoice']);
route::post('/add_pack/{id}', [AdminController::class, 'add_pack']);
route::post('/add_invoide', [AdminController::class, 'add_invoide']);
route::get('/invoice_view', [AdminController::class, 'invoice_view']);

route::get('/sendmail', [AdminController::class, 'sendmail']); 
route::get('/downlodes_database', [AdminController::class, 'downlodes_database']);
route::get('/view_user_email', [AdminController::class, 'view_user_email']);
route::get('/add_user_email', [AdminController::class, 'add_user_email']);

route::get('/product_notes', [AdminController::class, 'product_notes']);

route::post('/add_email_user', [AdminController::class, 'add_email_user']);
route::get('/delete_email_user/{id}', [AdminController::class, 'delete_email_user']);

route::get('/send_invoice/{id}', [AdminController::class, 'send_invoice']);
route::get('/remove_cart/{id}', [AdminController::class, 'remove_cart']);
route::get('/show_cart', [AdminController::class, 'show_cart']);

route::get('/cash_order', [AdminController::class, 'cash_order']);
route::post('/sinup_now', [AdminController::class, 'sinup_now']);
route::get('/profile', [AdminController::class, 'profile']);
route::get('/myorder', [AdminController::class, 'myorder']);
route::get('/transaction-history', [AdminController::class, 'transaction_history']);
route::get('/check_order/{id}', [AdminController::class, 'check_order']);
route::post('/updateprofile/{id}', [AdminController::class, 'updateprofile']);
require __DIR__.'/auth.php';
