<?php

/**
 * Initialize child theme style
 */
function blankslate_child_enqueue_styles() {
  // Enqueue parent theme style
  wp_enqueue_style(
          'blankslate-parent-style',
          get_template_directory_uri() . '/style.css'
  );

  // Enqueue child theme style
  wp_enqueue_style(
          'blankslate-child-style',
          get_stylesheet_directory_uri() . '/style.css',
          array('blankslate-parent-style')
  );
}

add_action('wp_enqueue_scripts', 'blankslate_child_enqueue_styles');

// custom function section
// Posted On
function posted_on() {
  printf(__('<span class="sep">Posted </span><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s" pubdate>%4$s</time></a> by <span class="byline author vcard">%5$s</span>', ''),
          esc_url(get_permalink()),
          esc_attr(get_the_time()),
          esc_attr(get_the_date('c')),
          esc_html(get_the_date()),
          esc_attr(get_the_author())
  );
}

function post_navigation() {
  echo '<div class="navigation">';
  echo '	<div class="next-posts">' . get_next_posts_link('&laquo; Older Entries') . '</div>';
  echo '	<div class="prev-posts">' . get_previous_posts_link('Newer Entries &raquo;') . '</div>';
  echo '</div>';
}
