<?php
/**
 *
  Template Name: Faq Delhi Template
 *
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Paper_Plane
 * @since PaperPlane 1.0
 */
$page_id = get_the_ID();
$parent_page_id = wp_get_post_parent_id($page_id);

$location = get_the_terms($parent_page_id, 'locations');
$location_id = '';
foreach ($location as $value) {
  $location_id = $value->term_id;
}

$GLOBALS['location'] = $location;
$GLOBALS['location_id'] = $location_id;

$position = 1;
$destination_obj = get_destination_by_taxanomy('locations', $GLOBALS['location'][0]->term_id);
$hotel_name = '';
if ($destination_obj->have_posts()) {

  while ($destination_obj->have_posts()) {

    $destination_obj->the_post();
    $hotel_name = get_post_meta(get_the_id(), 'name', true);
  }
}
wp_reset_postdata();
$itemList = [];
$itemList[0]['@type'] = 'ListItem';
$itemList[0]['position'] = $position;
$itemList[0]['item']['@id'] = site_url() . '/';
$itemList[0]['item']['name'] = 'Home';

$itemList[1]['@type'] = 'ListItem';
$itemList[1]['position'] = $position + 1;
$itemList[1]['item']['@id'] = site_url() . '/' . 'the-lalit-' . $GLOBALS['location'][0]->slug . '/';
$itemList[1]['item']['name'] = $hotel_name;

$itemList[2]['@type'] = 'ListItem';
$itemList[2]['position'] = $position + 2;
$itemList[2]['item']['@id'] = site_url() . $_SERVER['REQUEST_URI'];
$itemList[2]['item']['name'] = get_the_title(get_the_id());
?>
<!DOCTYPE html>
<html lang="en-IN">
    <head>
        <?php wp_head(); ?>
        <?php get_template_part('includes/css', 'js'); ?>
        <script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "BreadcrumbList",
            "itemListElement": <?php echo json_encode($itemList); ?>
            }
        </script>
        <link rel="stylesheet" href="<?= get_stylesheet_directory_uri().'/custom.css' ?>">
    </head>
    <body <?php body_class('global-page'); ?>>
        <div class="main-wrap">
            <?php get_header(); ?>
            <?php while (have_posts()) : the_post(); ?>
              <div class="content-section">
                  <div class="container align-center small-banner-sec js_fade" style="background-image: url('/wp-content/themes/lalit/images/faq.jpg'); opacity: 1;background-size: cover;">
                      <div class="row">
                          <div class="banner-content">
                              <h1 class="main-title text-shadow">Frequently Asked Questions</h1>
                          </div>
                      </div>
                  </div>
                  <div class="page-con">
                      <?php //the_content(); ?>
                      <div class="container section-space intro-text align-center">
                          <div class="row">
                              <div class="seperator"></div>
                              <h1 class="sec-title">Frequently Asked Questions</h1>
                              <div class="col col10 align-content-center ">
                                  <!--<p>How can we help you?</p>-->
                              </div>
                          </div>
                          <div class="container">
                              <div class="faq_7" unique-script-id="w-w-dm-id">
                                  <div class="responsive-container-block">
                                      <div class="responsive-cell-block wk-tab-12 wk-mobile-12 wk-desk-12 wk-ipadp-12 faq-dropdown-bg" id="imiw">
                                          <?php echo get_the_content();?>
<!--                                          <div class="container" id="iwk5t">
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          1.	What makes The LaLiT New Delhi one of the best 5-star luxury hotels in
                                                          Delhi?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT New Delhi stands as a premier 5-star luxury hotel, redefining
                                                              elegance, sophistication, and world-class hospitality. Nestled in the heart of
                                                              India’s capital, this architectural masterpiece offers a seamless blend of
                                                              timeless grandeur and contemporary opulence. Featuring lavishly designed
                                                              accommodations, award-winning gourmet dining, an indulgent luxury spa,
                                                              and cutting-edge business facilities, The LaLiT ensures an unparalleled
                                                              experience for both leisure seekers and corporate travelers. Whether you&#39;re
                                                              here to explore Delhi’s rich cultural heritage or to attend high-powered business
                                                              engagements, this iconic luxury hotel promises an extraordinary stay, infused
                                                              with personalized service and refined elegance.
                                                          </p> 
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          2.	Where is The LaLiT New Delhi located?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>This 5-star hotel in Delhi is conveniently located in Connaught Place, one of
                                                              the city&#39;s most prestigious and vibrant areas. It offers easy access to key
                                                              attractions like India Gate, Rashtrapati Bhavan, Red Fort, and major
                                                              business hubs, making it an ideal stay for tourists and corporate guests.
                                                          </p>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          3.	What types of rooms and suites are available at The LaLiT New Delhi?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT New Delhi offers a variety of luxury accommodations, including:
                                                          </p>
                                                          <ul> 
                                                              <li>Luxury Rooms – Elegant and spacious with modern amenities.</li>
                                                              <li>Executive Suites – Featuring a separate living area for added comfort.</li>
                                                              <li>The LaLiT Legacy Suite (Presidential Suite) – The ultimate in opulence
                                                                  with panoramic city views, exclusive services, and personalized luxury.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          4.	What dining options are available at this 5-star hotel in Delhi?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The hotel boasts some of the best fine dining restaurants in Delhi, including:
                                                          </p>
                                                          <ul>
                                                              <li>24/7 Restaurant – Global cuisine available round the clock.</li>
                                                              <li>Baluchi – An authentic Indian culinary experience.</li>
                                                              <li>OKO – A Pan-Asian restaurant offering delicacies from Japan, Thailand,
                                                                  and China.</li>
                                                              <li>The Grill Room – Specializing in premium cuts and gourmet delights.</li>
                                                              <li>24/7 Bar &amp; Le Petit Café – Offering signature cocktails, wines, and freshly
                                                                  baked treats.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          5.	What luxury wellness and spa facilities does the hotel offer?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The Spiceology Spa at The LaLiT New Delhi offers a 5-star wellness
                                                              experience, including:
                                                          </p>
                                                          <ul>
                                                              <li>Ayurvedic and aromatherapy treatments.</li>
                                                              <li>Deep tissue and Swedish massages for relaxation.</li>
                                                              <li>Luxury facials, detoxifying body wraps, and beauty treatments.</li>
                                                              <li>Facials, body wraps, and skin rejuvenation therapies.</li>
                                                              <li>A well-equipped fitness center and an outdoor swimming pool for
                                                                  health-conscious guests.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          6.	What business and event facilities are available at the hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              As one of the best hotels for business travelers, The LaLiT New Delhi
                                                              provides:
                                                          </p>
                                                          <ul>
                                                              <li>Spacious conference rooms and banquet halls with modern
                                                                  technology.</li>
                                                              <li>Boardrooms and business lounges for corporate meetings.</li>
                                                              <li>Event planning services for weddings, exhibitions, and grand
                                                                  celebrations.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          7.	What are the best attractions near The LaLiT New Delhi?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Staying at this 5-star luxury hotel in Delhi provides easy access to top
                                                              attractions, including:
                                                          </p>
                                                          <ul>
                                                              <li>India Gate (4 km | 10-minute drive | Taxi, Private Car, Tuk-Tuk)</li>
                                                              <li>Rashtrapati Bhavan (Presidential Residence) (5 km | 12-minute drive |
                                                                  Taxi, Private Car)</li>
                                                              <li>Connaught Place – Shopping &amp; Nightlife Hub (1.5 km | 5-minute drive
                                                                  | Walk, Taxi, Tuk-Tuk)</li>
                                                              <li>Lotus Temple (14 km | 25-minute drive | Taxi, Private Car)</li>
                                                              <li>Akshardham Temple (11 km | 20-minute drive | Taxi, Private Car)</li>
                                                              <li>Red Fort (6.5 km | 15-minute drive | Taxi, Private Car)</li>
                                                              <li>Jama Masjid (5.5 km | 12-minute drive | Taxi, Private Car, Tuk-Tuk)</li>
                                                              <li>Chandni Chowk – Street Food &amp; Heritage Shopping (6 km | 15-minute
                                                                  drive | Taxi, Tuk-Tuk, Cycle Rickshaw)</li>
                                                              <li>Qutub Minar (16 km | 30-minute drive | Taxi, Private Car)</li>
                                                              <li>Humayun’s Tomb (8 km | 18-minute drive | Taxi, Private Car)</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          8.	Does The LaLiT New Delhi offer airport transfers and concierge services?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Yes, the hotel provides luxury airport transfers in chauffeur-driven cars. The
                                                              24-hour concierge service assists with travel arrangements, sightseeing tours,
                                                              and personalized itineraries to ensure guests experience the best of Delhi.
                                                          </p>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          9.	Is The LaLiT New Delhi suitable for a romantic getaway or honeymoon?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Absolutely! The best 5-star hotel for couples in Delhi, The LaLiT offers:
                                                          </p>
                                                          <ul>
                                                              <li>Romantic suites with breathtaking city views.</li>
                                                              <li>Private candlelight dining experiences.</li>
                                                              <li>Spa packages for couples.</li>
                                                              <li>Special honeymoon packages with luxury inclusions.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          10.	How can I book a stay at this luxury hotel in Delhi?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests can book directly through The LaLiT New Delhi’s official website for
                                                              exclusive offers, or via leading travel platforms. Special benefits include:
                                                          </p>
                                                          <ul>
                                                              <li>Best available rates with early booking discounts.</li>
                                                              <li>Personalized services for enhanced stay experience.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>-->
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!--content-section-->
            <?php endwhile; ?>
            <?php get_footer(); ?>
        </div><!-- main-wrap -->
        <script type="text/javascript">
          jQuery(document).ready(function () {
              jQuery(".video-thumb").on('touchstart click', function () {
                  var data = jQuery(this).next(".video-block").attr("data");
                  jQuery(this).next(".video-block").attr("src", data);
                  jQuery(this).css("display", "none");
                  jQuery(this).next(".video-block").css("display", "block");

              });
          });
        </script>
        <script>
          jQuery(document).ready(function () {
              jQuery('.faq-question-container').on('click', function () {
                  jQuery(this).parent().toggleClass('active', 1000, 'easeOutSine');
              })
          });
        </script>
    <!--<script src="https://www.thelalit.com/faq.js"></script>-->
    </body>

</html>