<?php
/**
 *
  Template Name: Faq Goa Template
 *
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Paper_Plane
 * @since PaperPlane 1.0
 */
$page_id = get_the_ID();
$parent_page_id = wp_get_post_parent_id($page_id);

$location = get_the_terms($parent_page_id, 'locations');
$location_id = '';
foreach ($location as $value) {
  $location_id = $value->term_id;
}

$GLOBALS['location'] = $location;
$GLOBALS['location_id'] = $location_id;

$position = 1;
$destination_obj = get_destination_by_taxanomy('locations', $GLOBALS['location'][0]->term_id);
$hotel_name = '';
if ($destination_obj->have_posts()) {

  while ($destination_obj->have_posts()) {

    $destination_obj->the_post();
    $hotel_name = get_post_meta(get_the_id(), 'name', true);
  }
}
wp_reset_postdata();
$itemList = [];
$itemList[0]['@type'] = 'ListItem';
$itemList[0]['position'] = $position;
$itemList[0]['item']['@id'] = site_url() . '/';
$itemList[0]['item']['name'] = 'Home';

$itemList[1]['@type'] = 'ListItem';
$itemList[1]['position'] = $position + 1;
$itemList[1]['item']['@id'] = site_url() . '/' . 'the-lalit-' . $GLOBALS['location'][0]->slug . '/';
$itemList[1]['item']['name'] = $hotel_name;

$itemList[2]['@type'] = 'ListItem';
$itemList[2]['position'] = $position + 2;
$itemList[2]['item']['@id'] = site_url() . $_SERVER['REQUEST_URI'];
$itemList[2]['item']['name'] = get_the_title(get_the_id());
?>
<!DOCTYPE html>
<html lang="en-IN">
    <head>
        <?php wp_head(); ?>
        <?php get_template_part('includes/css', 'js'); ?>
        <script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "BreadcrumbList",
            "itemListElement": <?php echo json_encode($itemList); ?>
            }
        </script>
        <link rel="stylesheet" href="<?= get_stylesheet_directory_uri().'/custom.css' ?>">
    </head>
    <body <?php body_class('global-page'); ?>>
        <div class="main-wrap">
            <?php get_header(); ?>
            <?php while (have_posts()) : the_post(); ?>
              <div class="content-section">
                  <div class="container align-center small-banner-sec js_fade" style="background-image: url('/wp-content/themes/lalit/images/faq.jpg'); opacity: 1;background-size: cover;">
                      <div class="row">
                          <div class="banner-content">
                              <h1 class="main-title text-shadow">Frequently Asked Questions</h1>
                          </div>
                      </div>
                  </div>
                  <div class="page-con">
                      <?php //the_content(); ?>
                      <div class="container section-space intro-text align-center">
                          <div class="row">
                              <div class="seperator"></div>
                              <h1 class="sec-title">Frequently Asked Questions</h1>
                              <div class="col col10 align-content-center ">
                                  <!--<p>How can we help you?</p>-->
                              </div>
                          </div>
                          <div class="container">
                              <div class="faq_7" unique-script-id="w-w-dm-id">
                                  <div class="responsive-container-block">
                                      <div class="responsive-cell-block wk-tab-12 wk-mobile-12 wk-desk-12 wk-ipadp-12 faq-dropdown-bg" id="imiw">
                                          <?php echo get_the_content();?>
<!--                                          <div class="container" id="iwk5t">
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          1.	Why is The LaLiT Golf &amp; Spa Resort Goa considered one of the best
                                                          5-star luxury hotels in Goa?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              As a leading 5-star luxury hotel, The LaLiT Golf &amp; Spa Resort Goa
                                                              combines world-class amenities, breathtaking beachfront views, and
                                                              signature hospitality. With opulent suites, a private golf course,
                                                              gourmet dining, and a renowned spa, the resort offers an unmatched
                                                              luxury experience for travelers.
                                                          </p> 
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          2.	Where is this 5-star hotel located in Goa?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>The LaLiT Golf &amp; Spa Resort Goa is located on Rajbaga Beach,
                                                              Canacona, South Goa, offering a tranquil yet luxurious escape from
                                                              the busy tourist areas while remaining close to Goa’s key attractions.
                                                          </p>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          3.	How far is the hotel from Goa International Airport?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              This luxury hotel in Goa is approximately:
                                                          </p>
                                                          <ul> 
                                                              <li>63 km (90-minute drive) from Goa International Airport
                                                                  (Dabolim).</li>
                                                              <li>90 km (2-hour drive) from Mopa Airport (North Goa).
                                                                  The hotel offers private luxury airport transfers for a seamless
                                                                  arrival experience.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          4.	What are the accommodation options at this luxury hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Golf &amp; Spa Resort Goa offers some of the best luxury
                                                              accommodations in Goa, including:
                                                          </p>
                                                          <ul>
                                                              <li>Garden View Suites – Overlooking lush tropical gardens.</li>
                                                              <li>Sea View Suites – Offering panoramic views of the Arabian
                                                                  Sea.</li>
                                                              <li>Luxury Villas – Private and spacious, ideal for an exclusive
                                                                  getaway.</li>
                                                              <li>Presidential Villa – The epitome of elegance with premium
                                                                  amenities.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          5.	What makes The LaLiT one of the best hotels for LGBTQ+ travelers?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Golf &amp; Spa Resort Goa is one of the best LGBTQ+
                                                              inclusive luxury hotels, ensuring a safe, welcoming, and celebratory
                                                              atmosphere for all guests. The hotel actively supports diversity and
                                                              hosts LGBTQ+ events, making it a top choice for an inclusive luxury
                                                              vacation.
                                                          </p>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          6.	What wellness and spa services do this 5-star hotel offer?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The award-winning Spiceology Spa offers a range of luxury wellness
                                                              treatments, including:
                                                          </p>
                                                          <ul>
                                                              <li>Ayurvedic and aromatherapy massages for deep relaxation.</li>
                                                              <li>Luxury facials and skin treatments for rejuvenation.</li>
                                                              <li>Yoga and meditation sessions with expert trainers.</li>
                                                              <li>Signature spa therapies are tailored for a holistic wellness
                                                                  experience.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          7.	What dining options are available at this 5-star luxury hotel in Goa?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests can indulge in the best fine dining experiences, featuring:
                                                          </p>
                                                          <ul>
                                                              <li>Canacona – All-day dining with Goan, Indian, and international
                                                                  cuisine.</li>
                                                              <li>Sirocco – A specialty restaurant serving fresh seafood and
                                                                  Mediterranean flavors.</li>
                                                              <li>Corta’s – A beachside eatery offering authentic Goan
                                                                  delicacies.</li>
                                                              <li>Gazebo – A poolside bar with handcrafted cocktails and
                                                                  gourmet snacks.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          8.	What are the best activities available at this 5-star hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests at The LaLiT Golf &amp; Spa Resort Goa can enjoy a mix of luxury
                                                              relaxation and adventure, including:
                                                          </p>
                                                          <ul>
                                                              <li>A private 9-hole championship golf course.</li>
                                                              <li>Water sports like kayaking, jet skiing, and parasailing.</li>
                                                              <li>Beach yoga and guided meditation sessions.</li>
                                                              <li>Private yacht cruises and heritage excursions.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          9.	Does the hotel offer luxury wedding and event services?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Yes, The LaLiT Golf &amp; Spa Resort Goa is one of the best hotels for
                                                              destination weddings and luxury events, offering:
                                                          </p>
                                                          <ul>
                                                              <li>Stunning beachfront wedding venues.</li>
                                                              <li>Grand banquet halls and open-air event spaces.</li>
                                                              <li>Personalized event planning and gourmet catering.</li>
                                                              <li>Exclusive honeymoon packages for newlyweds.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          10.	How can I book my stay at this 5-star luxury hotel in Goa?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Book directly through The LaLiT Golf &amp; Spa Resort Goa’s official
                                                              website for the best offers, including:
                                                          </p>
                                                          <ul>
                                                              <li>Early booking discounts on suites and villas.</li>
                                                              <li>Personalized concierge services for a bespoke experience.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>-->
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!--content-section-->
            <?php endwhile; ?>
            <?php get_footer(); ?>
        </div><!-- main-wrap -->
        <script type="text/javascript">
          jQuery(document).ready(function () {
              jQuery(".video-thumb").on('touchstart click', function () {
                  var data = jQuery(this).next(".video-block").attr("data");
                  jQuery(this).next(".video-block").attr("src", data);
                  jQuery(this).css("display", "none");
                  jQuery(this).next(".video-block").css("display", "block");

              });
          });
        </script>
        <script>
          jQuery(document).ready(function () {
              jQuery('.faq-question-container').on('click', function () {
                  jQuery(this).parent().toggleClass('active', 1000, 'easeOutSine');
              })
          });
        </script>
    <!--<script src="https://www.thelalit.com/faq.js"></script>-->
    </body>

</html>