<?php
/**
 *
  Template Name: Faq Jaipur Template
 *
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Paper_Plane
 * @since PaperPlane 1.0
 */
$page_id = get_the_ID();
$parent_page_id = wp_get_post_parent_id($page_id);

$location = get_the_terms($parent_page_id, 'locations');
$location_id = '';
foreach ($location as $value) {
  $location_id = $value->term_id;
}

$GLOBALS['location'] = $location;
$GLOBALS['location_id'] = $location_id;

$position = 1;
$destination_obj = get_destination_by_taxanomy('locations', $GLOBALS['location'][0]->term_id);
$hotel_name = '';
if ($destination_obj->have_posts()) {

  while ($destination_obj->have_posts()) {

    $destination_obj->the_post();
    $hotel_name = get_post_meta(get_the_id(), 'name', true);
  }
}
wp_reset_postdata();
$itemList = [];
$itemList[0]['@type'] = 'ListItem';
$itemList[0]['position'] = $position;
$itemList[0]['item']['@id'] = site_url() . '/';
$itemList[0]['item']['name'] = 'Home';

$itemList[1]['@type'] = 'ListItem';
$itemList[1]['position'] = $position + 1;
$itemList[1]['item']['@id'] = site_url() . '/' . 'the-lalit-' . $GLOBALS['location'][0]->slug . '/';
$itemList[1]['item']['name'] = $hotel_name;

$itemList[2]['@type'] = 'ListItem';
$itemList[2]['position'] = $position + 2;
$itemList[2]['item']['@id'] = site_url() . $_SERVER['REQUEST_URI'];
$itemList[2]['item']['name'] = get_the_title(get_the_id());
?>
<!DOCTYPE html>
<html lang="en-IN">
    <head>
        <?php wp_head(); ?>
        <?php get_template_part('includes/css', 'js'); ?>
        <script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "BreadcrumbList",
            "itemListElement": <?php echo json_encode($itemList); ?>
            }
        </script>
        <link rel="stylesheet" href="<?= get_stylesheet_directory_uri().'/custom.css' ?>">
    </head>
    <body <?php body_class('global-page'); ?>>
        <div class="main-wrap">
            <?php get_header(); ?>
            <?php while (have_posts()) : the_post(); ?>
              <div class="content-section">
                  <div class="container align-center small-banner-sec js_fade" style="background-image: url('/wp-content/themes/lalit/images/faq.jpg'); opacity: 1;background-size: cover;">
                      <div class="row">
                          <div class="banner-content">
                              <h1 class="main-title text-shadow">Frequently Asked Questions</h1>
                          </div>
                      </div>
                  </div>
                  <div class="page-con">
                      <?php //the_content(); ?>
                      <div class="container section-space intro-text align-center">
                    <div class="row">
                        <div class="seperator"></div>
                        <h1 class="sec-title">Frequently Asked Questions</h1>
                        <div class="col col10 align-content-center ">
                            <!--<p>How can we help you?</p>-->
                        </div>
                    </div>
                    <div class="container">
                        <div class="faq_7" unique-script-id="w-w-dm-id">
                        <div class="responsive-container-block">
                          <div class="responsive-cell-block wk-tab-12 wk-mobile-12 wk-desk-12 wk-ipadp-12 faq-dropdown-bg" id="imiw">
                              <?php echo get_the_content();?>
<!--                            <div class="container" id="iwk5t">
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    1.	Why is The LaLiT Jaipur considered one of the best 5-star luxury hotels in Jaipur?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                  <div class="text-blk faq-answer">
                                    <p>
                                       The LaLiT Jaipur is a symbol of grandeur and regal hospitality, offering an unparalleled blend of Rajasthani heritage and modern luxury. Located in the heart of the Pink City, this 5-star luxury hotel is renowned for its opulent accommodations, award-winning dining, a world-class spa, and elegant event venues. Whether you’re visiting for business, leisure, or a grand celebration, The LaLiT Jaipur ensures a royal experience infused with warmth, sophistication, and impeccable service.
                                    </p> 
                                  </div>
                                </div>
                              </div>
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    2.	Where is The LaLiT Jaipur located?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                  <div class="text-blk faq-answer">
                                      <p>The LaLiT Jaipur is strategically located near Jaipur International Airport (3 km | 10-minute drive), 
                                          offering seamless connectivity to key landmarks such as:
                                      </p>
                                      <ul>
                                          <li>Amber Fort (15 km | 30-minute drive)</li>
                                          <li>Hawa Mahal (12 km | 25-minute drive)</li>
                                          <li>City Palace & Jantar Mantar (13 km | 30-minute drive)</li>
                                          <li>Jaipur Exhibition and Convention Centre (8 km | 15-minute drive)</li>
                                    </ul>
                                  </div>
                                </div>
                              </div>
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    3.	What types of accommodations are available at this luxury hotel?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                    <div class="text-blk faq-answer">
                                  <p>
                                      The exquisitely designed rooms and suites at The LaLiT Jaipur provide an indulgent retreat, blending traditional Rajasthani aesthetics with contemporary elegance. Options include:
                                  </p>
                                  <ul> 
                                      <li>Deluxe Rooms – Stylish interiors with plush bedding and modern amenities.</li>
                                      <li>Luxury Suites – Offering spacious living areas, handcrafted decor, and premium furnishings.</li>
                                      <li>The LaLiT Legacy Suite (Presidential Suite) – A palatial haven with a private lounge, grand bedroom, and breathtaking city views.</li>
                                  </ul>
                                </div>
                                </div>
                              </div>
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    4.	What are the best fine dining experiences at The LaLiT Jaipur?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                  <div class="text-blk faq-answer">
                                    <p>
                                        The LaLiT Jaipur offers an unmatched culinary journey, where every meal is a celebration of authentic flavors and global cuisines:
                                    </p>
                                    <ul>
                                      <li>Baluchi – The hotel’s signature Pan-Indian fine-dining restaurant, renowned for its North-Western Frontier cuisine and signature Naan’ery.</li>
                                      <li>The Circle – An all-day dining restaurant serving a fusion of local Rajasthani delicacies and international flavors.</li>
                                      <li>24/7 In-Room Dining – Enjoy gourmet meals in the comfort of your room, available around the clock.</li>
                                    </ul>
                                  </div>
                                </div>
                              </div>
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    5.	What are the finest wellness and relaxation services at the hotel?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                    <div class="text-blk faq-answer">
                                  <p>
                                      The Spiceology Spa at The LaLiT Jaipur is an oasis of tranquility, offering a curated selection of rejuvenating treatments:
                                  </p>
                                      <ul>
                                          <li>Traditional Ayurvedic massages and aromatherapy sessions for complete relaxation.</li>
                                          <li>Signature detoxifying facials and body treatments for radiant skin.</li>
                                          <li>A fully equipped state-of-the-art gymnasium with personalized fitness sessions.</li>
                                          <li>An outdoor swimming pool featuring a serene lounging area for ultimate rejuvenation.</li>
                                  </ul>
                                </div>
                                </div>
                              </div>
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    6.	What exclusive experiences can guests enjoy at The LaLiT Jaipur?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                    <div class="text-blk faq-answer">
                                  <p>
                                      Guests can indulge in bespoke luxury experiences, including:
                                  </p>
                                    <ul>
                                        <li>Royal Heritage Walks & Private City Tours – Explore Jaipur’s historic palaces, bustling bazaars, and cultural landmarks.</li>
                                        <li>Sunset Camel Safari – Witness the breathtaking desert sunset while enjoying a traditional Rajasthani cultural performance.</li>
                                        <li>Private Rooftop Dining – Experience an intimate candlelit dinner with curated gourmet delicacies and panoramic city views.</li>
                                        <li>Luxury Shopping Assistance – Personalized shopping tours to Jaipur’s famous jewelry, textile, and handicraft markets.</li>
                                    </ul>
                                </div>
                                </div>
                              </div>
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    7.	Is The LaLiT Jaipur a premier venue for weddings and events?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                  <div class="text-blk faq-answer">
                                    <p>
                                        Yes! The LaLiT Jaipur is one of the most sought-after wedding destinations in Jaipur, featuring:
                                    </p>
                                      <ul>
                                          <li>Grand indoor and outdoor wedding venues, including regal banquet halls and sprawling landscape gardens.</li>
                                          <li>Personalized wedding planning services, ensuring every celebration is flawlessly curated.</li>
                                          <li>Exquisite catering options, blending authentic Rajasthani, Indian, and international cuisines.</li>
                                          <li>Premium corporate event facilities, including state-of-the-art boardrooms and conference halls.</li>
                                      </ul>
                                  </div>
                                </div>
                              </div>
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    8.	Which are the top attractions near The LaLiT Jaipur?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                  <div class="text-blk faq-answer">
                                    <p>
                                        Staying at The LaLiT Jaipur provides easy access to Jaipur’s most iconic landmarks, including:
                                    </p>
                                      <ul>
                                          <li>Amber Fort (15 km | 30-minute drive | Private Car, Taxi)</li>
                                          <li>Hawa Mahal (12 km | 25-minute drive | Private Car, Tuk-Tuk).</li>
                                          <li>City Palace & Jantar Mantar (13 km | 30-minute drive | Taxi, Private Car)</li>
                                          <li>Nahargarh Fort (18 km | 35-minute drive | Private Car)</li>
                                          <li>Albert Hall Museum (10 km | 20-minute drive | Taxi, Private Car)</li>
                                      </ul>
                                  </div>
                                </div>
                              </div>
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    9.	Does The LaLiT Jaipur offer airport transfers and concierge services?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                  <div class="text-blk faq-answer">
                                    <p>
                                        Absolutely! The hotel provides luxury airport transfers and personalized concierge services, including:
                                    </p>
                                      <ul>
                                          <li>Chauffeur-driven private car services.</li>
                                          <li>Curated sightseeing tours with expert guides.</li>
                                          <li>Tailor-made itineraries for a seamless and enriching Jaipur experience</li>
                                      </ul>
                                  </div>
                                </div>
                              </div>
                              <div class="faq">
                                <span class="faq-question-container">
                                  <p class="text-blk faq-questions">
                                    10.	How can I book my stay at this 5-star luxury hotel in Jaipur?
                                  </p>
                                  <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                </span>
                                <div class="answer-box">
                                  <div class="text-blk faq-answer">
                                    <p>
                                        Guests can book their stay directly through The LaLiT Jaipur’s official website for exclusive privileges, including:
                                    </p>
                                      <ul>
                                          <li>Early booking discounts and bespoke luxury packages.</li>
                                          <li>Tailor-made experiences for a truly unforgettable stay.</li>
                                          <li>Book your stay today and immerse yourself in the magnificence of Jaipur’s most prestigious luxury retreat!</li>
                                      </ul>
                                  </div>
                                </div>
                              </div>
                            </div>-->
                          </div>
                        </div>
                      </div>
                    </div>
                </div>
                  </div>
              </div>
              <!--content-section-->
            <?php endwhile; ?>
            <?php get_footer(); ?>
        </div><!-- main-wrap -->
        <script type="text/javascript">
          jQuery(document).ready(function () {
              jQuery(".video-thumb").on('touchstart click', function () {
                  var data = jQuery(this).next(".video-block").attr("data");
                  jQuery(this).next(".video-block").attr("src", data);
                  jQuery(this).css("display", "none");
                  jQuery(this).next(".video-block").css("display", "block");

              });
          });
        </script>
        <script>
          jQuery(document).ready(function () {
              jQuery('.faq-question-container').on('click', function () {
                  jQuery(this).parent().toggleClass('active', 1000, 'easeOutSine');
              })
          });
        </script>
    <!--<script src="https://www.thelalit.com/faq.js"></script>-->
    </body>

</html>