<?php
/**
 *
  Template Name: Faq Kolkata Template
 *
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Paper_Plane
 * @since PaperPlane 1.0
 */
$page_id = get_the_ID();
$parent_page_id = wp_get_post_parent_id($page_id);

$location = get_the_terms($parent_page_id, 'locations');
$location_id = '';
foreach ($location as $value) {
  $location_id = $value->term_id;
}

$GLOBALS['location'] = $location;
$GLOBALS['location_id'] = $location_id;

$position = 1;
$destination_obj = get_destination_by_taxanomy('locations', $GLOBALS['location'][0]->term_id);
$hotel_name = '';
if ($destination_obj->have_posts()) {

  while ($destination_obj->have_posts()) {

    $destination_obj->the_post();
    $hotel_name = get_post_meta(get_the_id(), 'name', true);
  }
}
wp_reset_postdata();
$itemList = [];
$itemList[0]['@type'] = 'ListItem';
$itemList[0]['position'] = $position;
$itemList[0]['item']['@id'] = site_url() . '/';
$itemList[0]['item']['name'] = 'Home';

$itemList[1]['@type'] = 'ListItem';
$itemList[1]['position'] = $position + 1;
$itemList[1]['item']['@id'] = site_url() . '/' . 'the-lalit-' . $GLOBALS['location'][0]->slug . '/';
$itemList[1]['item']['name'] = $hotel_name;

$itemList[2]['@type'] = 'ListItem';
$itemList[2]['position'] = $position + 2;
$itemList[2]['item']['@id'] = site_url() . $_SERVER['REQUEST_URI'];
$itemList[2]['item']['name'] = get_the_title(get_the_id());
?>
<!DOCTYPE html>
<html lang="en-IN">
    <head>
        <?php wp_head(); ?>
        <?php get_template_part('includes/css', 'js'); ?>
        <script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "BreadcrumbList",
            "itemListElement": <?php echo json_encode($itemList); ?>
            }
        </script>
        <!--<link rel="stylesheet" href="https://www.thelalit.com/faq.css">-->
        <link rel="stylesheet" href="<?= get_stylesheet_directory_uri().'/custom.css' ?>">
    </head>
    <body <?php body_class('global-page'); ?>>
        <div class="main-wrap">
            <?php get_header(); ?>
            <?php while (have_posts()) : the_post(); ?>
              <div class="content-section">
                  <div class="container align-center small-banner-sec js_fade" style="background-image: url('/wp-content/themes/lalit/images/faq.jpg'); opacity: 1;background-size: cover;">
                      <div class="row">
                          <div class="banner-content">
                              <h1 class="main-title text-shadow">Frequently Asked Questions</h1>
                          </div>
                      </div>
                  </div>
                  <?php
                  /* $page_title = get_the_title();

                    if ($page_title != 'Privacy Policy') {
                    ?>
                    <div class="banner-slider align-center">
                    <div id="banner-slider" class="flexslider">
                    <ul class="slides">
                    <li>
                    <img src="<?php echo home_url(); ?>/wp-content/themes/lalit/images/About-us-1.jpg" />
                    </li>
                    <li>
                    <img src="<?php echo home_url(); ?>/wp-content/themes/lalit/images/About-us-2.jpeg" />
                    </li>
                    </ul>
                    </div>
                    </div>
                    <?php
                    } */
                  ?>
                  <div class="page-con">
                      <?php //the_content(); ?>
                      <div class="container section-space intro-text align-center">
                          <div class="row">
                              <div class="seperator"></div>
                              <h1 class="sec-title">Frequently Asked Questions</h1>
                              <div class="col col10 align-content-center ">
                                  <!--<p>How can we help you?</p>-->
                              </div>
                          </div>
                          <div class="container">
                              <div class="faq_7" unique-script-id="w-w-dm-id">
                                  <div class="responsive-container-block">
                                      <div class="responsive-cell-block wk-tab-12 wk-mobile-12 wk-desk-12 wk-ipadp-12 faq-dropdown-bg" id="imiw">
                                          <?php echo get_the_content();?>
<!--                                          <div class="container" id="iwk5t">
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          1.	Why is The LaLiT Great Eastern Kolkata considered one of the best 5-star
                                                          luxury hotels in Kolkata?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Great Eastern Kolkata is a legendary 5-star luxury hotel renowned
                                                              for its historic grandeur, colonial-era charm, and modern sophistication.
                                                              Established in 1830, this architectural masterpiece seamlessly blends heritage
                                                              elegance with contemporary opulence, offering world-class
                                                              accommodations, gourmet dining, and unmatched hospitality. Located in
                                                              the heart of the city, it provides an indulgent retreat for business and leisure
                                                              travelers, making it one of the best hotels in Kolkata.
                                                          </p> 
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          2.	Where is The LaLiT Great Eastern Kolkata located?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>The LaLiT Great Eastern Kolkata enjoys a prime location in Central Kolkata,
                                                              offering convenient access to iconic landmarks, business districts, and
                                                              cultural attractions. Situated near Dalhousie Square, it is within proximity to
                                                              major sites like Victoria Memorial, Howrah Bridge, Park Street, and the
                                                              Indian Museum, making it an ideal base for exploring the city.
                                                          </p>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          3.	What types of accommodation are available at this 5-star hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The hotel features luxurious rooms and suites designed for absolute comfort
                                                              and elegance, blending colonial charm with contemporary style. Options
                                                              include:
                                                          </p>
                                                          <ul> 
                                                              <li>Deluxe Rooms – Spacious and stylish with modern amenities.</li>
                                                              <li>Luxury Rooms – Offering refined décor and city views.</li>
                                                              <li>Heritage Suites – Featuring classic architecture, vintage furnishings,
                                                                  and lavish comfort.</li>
                                                              <li>The LaLiT Legacy Suite (Presidential Suite) – A grand residence with
                                                                  exclusive living areas, opulent décor, and personalized butler
                                                                  service.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          4.	What are the finest dining options at this luxury hotel in Kolkata?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Great Eastern Kolkata offers a rich culinary experience across its
                                                              diverse dining venues, each showcasing authentic flavors and global
                                                              cuisines:
                                                          </p>
                                                          <ul>
                                                              <li>The Legacy Grill – A premium fine dining steakhouse with curated
                                                                  international dishes.</li>
                                                              <li>Alfresco – An open-air restaurant serving global flavors in a serene
                                                                  ambiance.</li>
                                                              <li>The Bakery – An iconic colonial-era bakery, famous for its freshly
                                                                  baked delicacies and artisanal pastries.</li>
                                                              <li>The Tea Lounge – A perfect spot to unwind with handcrafted teas and
                                                                  gourmet snacks.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          5.	What exclusive wellness and spa services does the hotel offer?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The Spiceology Spa at The LaLiT Great Eastern Kolkata is a haven of
                                                              relaxation and rejuvenation, offering:
                                                          </p>
                                                          <ul>
                                                              <li>Signature Ayurvedic therapies for holistic well-being.</li>
                                                              <li>Luxury massages, facials, and body treatments tailored for deep
                                                                  relaxation.</li>
                                                              <li>A fully equipped fitness center with personal training options.</li>
                                                              <li>Steam and sauna facilities for detoxification and relaxation.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          6.	What unique experiences can guests enjoy at this 5-star hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The hotel curates exceptional experiences that highlight Kolkata’s rich culture
                                                              and history, including:
                                                          </p>
                                                          <ul>
                                                              <li>Heritage Walks – Explore the hotel’s historic architecture and colonial
                                                                  legacy with expert-guided tours.</li>
                                                              <li>Live Cultural Performances – Enjoy traditional Bengali music and
                                                                  dance, offering an immersive cultural journey.</li>
                                                              <li>Private High Tea at The Bakery – Experience an exclusive afternoon
                                                                  tea affair, featuring handcrafted delicacies and gourmet selections.</li>
                                                              <li>Culinary Masterclasses – Engage in interactive sessions with master
                                                                  chefs, learning the art of Bengali and international cuisine.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          7.	Does The LaLiT Great Eastern Kolkata offer wedding and event facilities?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Yes! The hotel is one of the most sought-after wedding and event venues in
                                                              Kolkata, offering:
                                                          </p>
                                                          <ul>
                                                              <li>Exquisite banquet halls with colonial-era charm.</li>
                                                              <li>Bespoke wedding planning and customized catering services.</li>
                                                              <li>State-of-the-art conference rooms for business events and corporate
                                                                  gatherings.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          8.	Which are the top attractions near The LaLiT Great Eastern Kolkata?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests staying at this 5-star luxury hotel in Kolkata can easily explore:
                                                          </p>
                                                          <ul>
                                                              <li>Victoria Memorial (3 km | 10-minute drive | Taxi, Private Car)</li>
                                                              <li>Howrah Bridge (2 km | 8-minute drive | Taxi, Private Car)</li>
                                                              <li>Park Street (2.5 km | 10-minute drive | Taxi, Tuk-Tuk)</li>
                                                              <li>Indian Museum (2 km | 7-minute drive | Taxi, Tuk-Tuk)</li>
                                                              <li>Eden Gardens (1.5 km | 5-minute drive | Taxi, Private Car)</li>
                                                              <li>Kumartuli (Artisan Quarter) (5 km | 15-minute drive | Taxi, Private Car)</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          9.	Does the hotel provide airport transfers and concierge services?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Yes, the hotel offers luxury airport transfers from Netaji Subhas Chandra
                                                              Bose International Airport (17 km | 40-minute drive). Guests can opt for:
                                                          </p>
                                                          <ul>
                                                              <li>Chauffeur-driven luxury cars for a seamless arrival experience.</li>
                                                              <li>Private sightseeing tours and itinerary planning by the concierge
                                                                  team.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          10.	How can I book my stay at this luxury hotel in Kolkata?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests can book directly through The LaLiT Great Eastern Kolkata’s official
                                                              website for exclusive offers and privileges, including:
                                                          </p>
                                                          <ul>
                                                              <li>Early booking discounts and luxury stay packages.</li>
                                                              <li>Personalized concierge assistance for a truly bespoke stay.</li>
                                                              <li>Book your stay today and immerse yourself in the grandeur of Kolkata’s
                                                                  most iconic luxury hotel!</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>-->
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!--content-section-->
            <?php endwhile; ?>
            <?php get_footer(); ?>
        </div><!-- main-wrap -->
        <script type="text/javascript">
          jQuery(document).ready(function () {
              jQuery(".video-thumb").on('touchstart click', function () {
                  var data = jQuery(this).next(".video-block").attr("data");
                  jQuery(this).next(".video-block").attr("src", data);
                  jQuery(this).css("display", "none");
                  jQuery(this).next(".video-block").css("display", "block");

              });
          });
        </script>
        <script>
          jQuery(document).ready(function () {
              jQuery('.faq-question-container').on('click', function () {
                  jQuery(this).parent().toggleClass('active', 1000, 'easeOutSine');
              })
          });
        </script>
    <!--<script src="https://www.thelalit.com/faq.js"></script>-->
    </body>

</html>