<?php
/**
 *
  Template Name: Faq Mumbai Template
 *
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Paper_Plane
 * @since PaperPlane 1.0
 */
$page_id = get_the_ID();
$parent_page_id = wp_get_post_parent_id($page_id);

$location = get_the_terms($parent_page_id, 'locations');
$location_id = '';
foreach ($location as $value) {
  $location_id = $value->term_id;
}

$GLOBALS['location'] = $location;
$GLOBALS['location_id'] = $location_id;

$position = 1;
$destination_obj = get_destination_by_taxanomy('locations', $GLOBALS['location'][0]->term_id);
$hotel_name = '';
if ($destination_obj->have_posts()) {

  while ($destination_obj->have_posts()) {

    $destination_obj->the_post();
    $hotel_name = get_post_meta(get_the_id(), 'name', true);
  }
}
wp_reset_postdata();
$itemList = [];
$itemList[0]['@type'] = 'ListItem';
$itemList[0]['position'] = $position;
$itemList[0]['item']['@id'] = site_url() . '/';
$itemList[0]['item']['name'] = 'Home';

$itemList[1]['@type'] = 'ListItem';
$itemList[1]['position'] = $position + 1;
$itemList[1]['item']['@id'] = site_url() . '/' . 'the-lalit-' . $GLOBALS['location'][0]->slug . '/';
$itemList[1]['item']['name'] = $hotel_name;

$itemList[2]['@type'] = 'ListItem';
$itemList[2]['position'] = $position + 2;
$itemList[2]['item']['@id'] = site_url() . $_SERVER['REQUEST_URI'];
$itemList[2]['item']['name'] = get_the_title(get_the_id());
?>
<!DOCTYPE html>
<html lang="en-IN">
    <head>
        <?php wp_head(); ?>
        <?php get_template_part('includes/css', 'js'); ?>
        <script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "BreadcrumbList",
            "itemListElement": <?php echo json_encode($itemList); ?>
            }
        </script>
        <link rel="stylesheet" href="<?= get_stylesheet_directory_uri().'/custom.css' ?>">
    </head>
    <body <?php body_class('global-page'); ?>>
        <div class="main-wrap">
            <?php get_header(); ?>
            <?php while (have_posts()) : the_post(); ?>
              <div class="content-section">
                  <div class="container align-center small-banner-sec js_fade" style="background-image: url('/wp-content/themes/lalit/images/faq.jpg'); opacity: 1;background-size: cover;">
                      <div class="row">
                          <div class="banner-content">
                              <h1 class="main-title text-shadow">Frequently Asked Questions</h1>
                          </div>
                      </div>
                  </div>
                  <div class="page-con">
                      <?php //the_content(); ?>
                      <div class="container section-space intro-text align-center">
                          <div class="row">
                              <div class="seperator"></div>
                              <h1 class="sec-title">Frequently Asked Questions</h1>
                              <div class="col col10 align-content-center ">
                                  <!--<p>How can we help you?</p>-->
                              </div>
                          </div>
                          <div class="container">
                              <div class="faq_7" unique-script-id="w-w-dm-id">
                                  <div class="responsive-container-block">
                                      <div class="responsive-cell-block wk-tab-12 wk-mobile-12 wk-desk-12 wk-ipadp-12 faq-dropdown-bg" id="imiw">
                                          <?php echo get_the_content();?>
<!--                                          <div class="container" id="iwk5t">
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          1.	Why is The LaLiT Mumbai considered one of the best 5-star luxury hotels in
                                                          Mumbai?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Mumbai is a landmark of opulence, offering an unparalleled blend
                                                              of elegance, comfort, and world-class hospitality. Located near Mumbai’s
                                                              international airport, this 5-star luxury hotel features lavish
                                                              accommodations, award-winning fine dining, a revitalizing spa, and state-
                                                              of-the-art business facilities. Whether visiting for business or leisure, guests
                                                              can expect seamless service, contemporary design, and an indulgent
                                                              retreat in the heart of India’s financial capital.
                                                          </p> 
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          2.	Where is The LaLiT Mumbai located?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>Strategically situated in Andheri East, The LaLiT Mumbai offers prime
                                                              connectivity to Chhatrapati Shivaji Maharaj International Airport (1 km | 5-
                                                              minute drive), key corporate hubs, and Mumbai’s premier shopping and
                                                              entertainment districts. The hotel’s location ensures a serene escape from
                                                              the city’s bustle while providing effortless access to major landmarks.
                                                          </p>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          3.	What types of accommodations are available at this luxury hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The sumptuously designed rooms and suites at The LaLiT Mumbai offer
                                                              sophisticated interiors, plush furnishings, and modern amenities for a truly
                                                              indulgent experience. Guests can choose from:
                                                          </p>
                                                          <ul> 
                                                              <li>Deluxe Rooms – Offering panoramic city or garden views, with
                                                                  contemporary design and refined elegance.</li>
                                                              <li>Luxury Suites – Featuring expansive living areas, bespoke décor, and
                                                                  exclusive privileges.</li>
                                                              <li>The LaLiT Legacy Suite (Presidential Suite) – A magnificent retreat,
                                                                  boasting exquisite interiors, personalized butler service, and
                                                                  breathtaking skyline views.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          4.	What are the best fine dining experiences at The LaLiT Mumbai?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Mumbai offers an exquisite culinary journey, where master chefs
                                                              curate authentic Indian and global flavors in an ambiance of refined luxury.
                                                              Dining options include:
                                                          </p>
                                                          <ul>
                                                              <li>24/7 Restaurant – A multi-cuisine all-day dining experience, serving
                                                                  international delicacies round the clock.</li>
                                                              <li>Baluchi – The hotel’s signature Pan-Indian restaurant, renowned for its
                                                                  flavorsome Awadhi and North-Western frontier cuisine.</li>
                                                              <li>OKO – An award-winning Pan-Asian fine dining destination, serving the
                                                                  finest Japanese, Thai, and Chinese delicacies.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          5.	What are the finest nightlife and entertainment options at the hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Elevating Mumbai’s nightlife scene, The LaLiT Mumbai presents sophisticated
                                                              lounges and exclusive bars, perfect for unwinding and socializing:
                                                          </p>
                                                          <ul>
                                                              <li>Beluga – A chic cocktail lounge with an extensive selection of premium
                                                                  spirits and handcrafted beverages.</li>
                                                              <li>Kitty Su – One of Mumbai’s most iconic nightclubs, offering electrifying
                                                                  music, avant-garde performances, and signature events.</li>
                                                              <li>In-Room Dining – Enjoy a gourmet meal in the privacy of your suite,
                                                                  with a meticulously curated menu available 24/7.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          6.	What wellness and spa facilities does The LaLiT Mumbai offer?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The Spiceology Spa at The LaLiT Mumbai is an oasis of serenity, offering
                                                              holistic therapies and rejuvenating treatments to restore mind, body, and
                                                              soul. Guests can indulge in:
                                                          </p>
                                                          <ul>
                                                              <li>Ayurvedic rituals and aromatherapy massages for deep relaxation.</li>
                                                              <li>Luxury facials, body wraps, and detox treatments designed for
                                                                  ultimate indulgence.</li>
                                                              <li>A state-of-the-art fitness center featuring advanced equipment and
                                                                  personal training services.</li>
                                                              <li>A tranquil swimming pool offering a refreshing retreat from the city’s
                                                                  fast pace.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          7.	What unique experiences can guests enjoy at this luxury hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Mumbai curates extraordinary experiences that elevate every stay,
                                                              including:
                                                          </p>
                                                          <ul>
                                                              <li>Private dining under the stars, with a curated gourmet menu and an
                                                                  intimate setup.</li>
                                                              <li>Culinary masterclasses, where guests can learn from the hotel’s
                                                                  renowned chefs.</li>
                                                              <li>Exclusive spa journeys, blending traditional healing techniques with
                                                                  modern therapies.</li>
                                                              <li>Bespoke concierge services, offering tailored city tours, shopping
                                                                  experiences, and cultural excursions.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          8.	What are the top attractions near The LaLiT Mumbai?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The hotel’s prime location provides easy access to Mumbai’s most iconic
                                                              landmarks, including:
                                                          </p>
                                                          <ul>
                                                              <li>Juhu Beach (6 km | 15-minute drive | Taxi, Private Car)</li>
                                                              <li>Bandra-Worli Sea Link (14 km | 30-minute drive | Taxi, Private Car)</li>
                                                              <li>Gateway of India &amp; Colaba Causeway (26 km | 50-minute drive | Private
                                                                  Car)</li>
                                                              <li>Siddhivinayak Temple (12 km | 25-minute drive | Taxi, Private Car)</li>
                                                              <li>Phoenix Marketcity Mall (4 km | 10-minute drive | Taxi, Private Car)</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          9.	Does The LaLiT Mumbai provide airport transfers and business facilities?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Yes! The hotel offers luxury airport transfers, ensuring a seamless arrival and
                                                              departure experience. Guests can avail:
                                                          </p>
                                                          <ul>
                                                              <li>Private chauffeur-driven car services.</li>
                                                              <li>Limousine transfers upon request.</li>
                                                              <li>Dedicated business lounges and high-tech conference rooms for
                                                                  corporate travelers.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          10.	How can I book my stay at this 5-star luxury hotel in Mumbai?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests can book directly through The LaLiT Mumbai’s official website for
                                                              exclusive privileges, including:
                                                          </p>
                                                          <ul>
                                                              <li>Early booking discounts and customized luxury packages.</li>
                                                              <li>Personalized concierge assistance for an extraordinary stay.</li>
                                                              <li>Book your stay today and immerse yourself in Mumbai’s most prestigious
                                                                  luxury experience!</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>-->
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!--content-section-->
            <?php endwhile; ?>
            <?php get_footer(); ?>
        </div><!-- main-wrap -->
        <script type="text/javascript">
          jQuery(document).ready(function () {
              jQuery(".video-thumb").on('touchstart click', function () {
                  var data = jQuery(this).next(".video-block").attr("data");
                  jQuery(this).next(".video-block").attr("src", data);
                  jQuery(this).css("display", "none");
                  jQuery(this).next(".video-block").css("display", "block");

              });
          });
        </script>
        <script>
          jQuery(document).ready(function () {
              jQuery('.faq-question-container').on('click', function () {
                  jQuery(this).parent().toggleClass('active', 1000, 'easeOutSine');
              })
          });
        </script>
    <!--<script src="https://www.thelalit.com/faq.js"></script>-->
    </body>

</html>